// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for RegisterImage.
 */
class RegisterImageRequest private constructor(builder: BuilderImpl) {
    /**
     * The architecture of the AMI.
     * Default: For Amazon EBS-backed AMIs, i386.
     * For instance store-backed AMIs, the architecture specified in the manifest file.
     */
    val architecture: ArchitectureValues? = builder.architecture
    /**
     * The billing product codes. Your account must be authorized to specify billing product codes. Otherwise,
     * you can use the Amazon Web Services Marketplace to bill for the use of an AMI.
     */
    val billingProducts: List<String>? = builder.billingProducts
    /**
     * The block device mapping entries.
     * If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the encryption state of the volume.
     * If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the Region
     * of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances on the same Outpost
     * only. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami">
     * Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide.
     */
    val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The boot mode of the AMI. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val bootMode: BootModeValues? = builder.bootMode
    /**
     * A description for your AMI.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Set to true to enable enhanced networking with ENA for the AMI and any instances that you launch from the AMI.
     * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.
     */
    val enaSupport: Boolean? = builder.enaSupport
    /**
     * The full path to your AMI manifest in Amazon S3 storage. The specified bucket must have the
     * aws-exec-read canned access control list (ACL) to ensure that it can be accessed
     * by Amazon EC2. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACLs in the
     * Amazon S3 Service Developer Guide.
     */
    val imageLocation: String? = builder.imageLocation
    /**
     * The ID of the kernel.
     */
    val kernelId: String? = builder.kernelId
    /**
     * A name for your AMI.
     * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets (&#91;&#93;), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     */
    val name: String? = builder.name
    /**
     * The ID of the RAM disk.
     */
    val ramdiskId: String? = builder.ramdiskId
    /**
     * The device name of the root device volume (for example, /dev/sda1).
     */
    val rootDeviceName: String? = builder.rootDeviceName
    /**
     * Set to simple to enable enhanced networking with the Intel 82599 Virtual Function interface for the AMI and any instances that you launch from the AMI.
     * There is no way to disable sriovNetSupport at this time.
     * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.
     */
    val sriovNetSupport: String? = builder.sriovNetSupport
    /**
     * The type of virtualization (hvm | paravirtual).
     * Default: paravirtual
     */
    val virtualizationType: String? = builder.virtualizationType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RegisterImageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterImageRequest(")
        append("architecture=$architecture,")
        append("billingProducts=$billingProducts,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("bootMode=$bootMode,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("enaSupport=$enaSupport,")
        append("imageLocation=$imageLocation,")
        append("kernelId=$kernelId,")
        append("name=$name,")
        append("ramdiskId=$ramdiskId,")
        append("rootDeviceName=$rootDeviceName,")
        append("sriovNetSupport=$sriovNetSupport,")
        append("virtualizationType=$virtualizationType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = architecture?.hashCode() ?: 0
        result = 31 * result + (billingProducts?.hashCode() ?: 0)
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (bootMode?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (enaSupport?.hashCode() ?: 0)
        result = 31 * result + (imageLocation?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceName?.hashCode() ?: 0)
        result = 31 * result + (sriovNetSupport?.hashCode() ?: 0)
        result = 31 * result + (virtualizationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RegisterImageRequest

        if (architecture != other.architecture) return false
        if (billingProducts != other.billingProducts) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (bootMode != other.bootMode) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (enaSupport != other.enaSupport) return false
        if (imageLocation != other.imageLocation) return false
        if (kernelId != other.kernelId) return false
        if (name != other.name) return false
        if (ramdiskId != other.ramdiskId) return false
        if (rootDeviceName != other.rootDeviceName) return false
        if (sriovNetSupport != other.sriovNetSupport) return false
        if (virtualizationType != other.virtualizationType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RegisterImageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RegisterImageRequest
        /**
         * The architecture of the AMI.
         * Default: For Amazon EBS-backed AMIs, i386.
         * For instance store-backed AMIs, the architecture specified in the manifest file.
         */
        fun architecture(architecture: ArchitectureValues): FluentBuilder
        /**
         * The billing product codes. Your account must be authorized to specify billing product codes. Otherwise,
         * you can use the Amazon Web Services Marketplace to bill for the use of an AMI.
         */
        fun billingProducts(billingProducts: List<String>): FluentBuilder
        /**
         * The block device mapping entries.
         * If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the encryption state of the volume.
         * If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the Region
         * of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances on the same Outpost
         * only. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami">
         * Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<BlockDeviceMapping>): FluentBuilder
        /**
         * The boot mode of the AMI. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun bootMode(bootMode: BootModeValues): FluentBuilder
        /**
         * A description for your AMI.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Set to true to enable enhanced networking with ENA for the AMI and any instances that you launch from the AMI.
         * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.
         */
        fun enaSupport(enaSupport: Boolean): FluentBuilder
        /**
         * The full path to your AMI manifest in Amazon S3 storage. The specified bucket must have the
         * aws-exec-read canned access control list (ACL) to ensure that it can be accessed
         * by Amazon EC2. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACLs in the
         * Amazon S3 Service Developer Guide.
         */
        fun imageLocation(imageLocation: String): FluentBuilder
        /**
         * The ID of the kernel.
         */
        fun kernelId(kernelId: String): FluentBuilder
        /**
         * A name for your AMI.
         * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets (&#91;&#93;), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         */
        fun name(name: String): FluentBuilder
        /**
         * The ID of the RAM disk.
         */
        fun ramdiskId(ramdiskId: String): FluentBuilder
        /**
         * The device name of the root device volume (for example, /dev/sda1).
         */
        fun rootDeviceName(rootDeviceName: String): FluentBuilder
        /**
         * Set to simple to enable enhanced networking with the Intel 82599 Virtual Function interface for the AMI and any instances that you launch from the AMI.
         * There is no way to disable sriovNetSupport at this time.
         * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.
         */
        fun sriovNetSupport(sriovNetSupport: String): FluentBuilder
        /**
         * The type of virtualization (hvm | paravirtual).
         * Default: paravirtual
         */
        fun virtualizationType(virtualizationType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The architecture of the AMI.
         * Default: For Amazon EBS-backed AMIs, i386.
         * For instance store-backed AMIs, the architecture specified in the manifest file.
         */
        var architecture: ArchitectureValues?
        /**
         * The billing product codes. Your account must be authorized to specify billing product codes. Otherwise,
         * you can use the Amazon Web Services Marketplace to bill for the use of an AMI.
         */
        var billingProducts: List<String>?
        /**
         * The block device mapping entries.
         * If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the encryption state of the volume.
         * If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the Region
         * of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances on the same Outpost
         * only. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami">
         * Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide.
         */
        var blockDeviceMappings: List<BlockDeviceMapping>?
        /**
         * The boot mode of the AMI. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var bootMode: BootModeValues?
        /**
         * A description for your AMI.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * Set to true to enable enhanced networking with ENA for the AMI and any instances that you launch from the AMI.
         * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.
         */
        var enaSupport: Boolean?
        /**
         * The full path to your AMI manifest in Amazon S3 storage. The specified bucket must have the
         * aws-exec-read canned access control list (ACL) to ensure that it can be accessed
         * by Amazon EC2. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACLs in the
         * Amazon S3 Service Developer Guide.
         */
        var imageLocation: String?
        /**
         * The ID of the kernel.
         */
        var kernelId: String?
        /**
         * A name for your AMI.
         * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets (&#91;&#93;), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         */
        var name: String?
        /**
         * The ID of the RAM disk.
         */
        var ramdiskId: String?
        /**
         * The device name of the root device volume (for example, /dev/sda1).
         */
        var rootDeviceName: String?
        /**
         * Set to simple to enable enhanced networking with the Intel 82599 Virtual Function interface for the AMI and any instances that you launch from the AMI.
         * There is no way to disable sriovNetSupport at this time.
         * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.
         */
        var sriovNetSupport: String?
        /**
         * The type of virtualization (hvm | paravirtual).
         * Default: paravirtual
         */
        var virtualizationType: String?

        fun build(): RegisterImageRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var architecture: ArchitectureValues? = null
        override var billingProducts: List<String>? = null
        override var blockDeviceMappings: List<BlockDeviceMapping>? = null
        override var bootMode: BootModeValues? = null
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var enaSupport: Boolean? = null
        override var imageLocation: String? = null
        override var kernelId: String? = null
        override var name: String? = null
        override var ramdiskId: String? = null
        override var rootDeviceName: String? = null
        override var sriovNetSupport: String? = null
        override var virtualizationType: String? = null

        constructor(x: RegisterImageRequest) : this() {
            this.architecture = x.architecture
            this.billingProducts = x.billingProducts
            this.blockDeviceMappings = x.blockDeviceMappings
            this.bootMode = x.bootMode
            this.description = x.description
            this.dryRun = x.dryRun
            this.enaSupport = x.enaSupport
            this.imageLocation = x.imageLocation
            this.kernelId = x.kernelId
            this.name = x.name
            this.ramdiskId = x.ramdiskId
            this.rootDeviceName = x.rootDeviceName
            this.sriovNetSupport = x.sriovNetSupport
            this.virtualizationType = x.virtualizationType
        }

        override fun build(): RegisterImageRequest = RegisterImageRequest(this)
        override fun architecture(architecture: ArchitectureValues): FluentBuilder = apply { this.architecture = architecture }
        override fun billingProducts(billingProducts: List<String>): FluentBuilder = apply { this.billingProducts = billingProducts }
        override fun blockDeviceMappings(blockDeviceMappings: List<BlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun bootMode(bootMode: BootModeValues): FluentBuilder = apply { this.bootMode = bootMode }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun enaSupport(enaSupport: Boolean): FluentBuilder = apply { this.enaSupport = enaSupport }
        override fun imageLocation(imageLocation: String): FluentBuilder = apply { this.imageLocation = imageLocation }
        override fun kernelId(kernelId: String): FluentBuilder = apply { this.kernelId = kernelId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun ramdiskId(ramdiskId: String): FluentBuilder = apply { this.ramdiskId = ramdiskId }
        override fun rootDeviceName(rootDeviceName: String): FluentBuilder = apply { this.rootDeviceName = rootDeviceName }
        override fun sriovNetSupport(sriovNetSupport: String): FluentBuilder = apply { this.sriovNetSupport = sriovNetSupport }
        override fun virtualizationType(virtualizationType: String): FluentBuilder = apply { this.virtualizationType = virtualizationType }
    }
}
