// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about a root volume replacement task.
 */
class ReplaceRootVolumeTask private constructor(builder: BuilderImpl) {
    /**
     * The time the task completed.
     */
    val completeTime: String? = builder.completeTime
    /**
     * The ID of the instance for which the root volume replacement task was created.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The ID of the root volume replacement task.
     */
    val replaceRootVolumeTaskId: String? = builder.replaceRootVolumeTaskId
    /**
     * The time the task was started.
     */
    val startTime: String? = builder.startTime
    /**
     * The tags assigned to the task.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The state of the task. The task can be in one of the following states:
     * pending - the replacement volume is being created.
     * in-progress - the original volume is being detached and the
     * replacement volume is being attached.
     * succeeded - the replacement volume has been successfully attached
     * to the instance and the instance is available.
     * failing - the replacement task is in the process of failing.
     * failed - the replacement task has failed but the original root
     * volume is still attached.
     * failing-detached - the replacement task is in the process of failing.
     * The instance might have no root volume attached.
     * failed-detached - the replacement task has failed and the instance
     * has no root volume attached.
     */
    val taskState: ReplaceRootVolumeTaskState? = builder.taskState

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReplaceRootVolumeTask = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReplaceRootVolumeTask(")
        append("completeTime=$completeTime,")
        append("instanceId=$instanceId,")
        append("replaceRootVolumeTaskId=$replaceRootVolumeTaskId,")
        append("startTime=$startTime,")
        append("tags=$tags,")
        append("taskState=$taskState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = completeTime?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (replaceRootVolumeTaskId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReplaceRootVolumeTask

        if (completeTime != other.completeTime) return false
        if (instanceId != other.instanceId) return false
        if (replaceRootVolumeTaskId != other.replaceRootVolumeTaskId) return false
        if (startTime != other.startTime) return false
        if (tags != other.tags) return false
        if (taskState != other.taskState) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReplaceRootVolumeTask = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReplaceRootVolumeTask
        /**
         * The time the task completed.
         */
        fun completeTime(completeTime: String): FluentBuilder
        /**
         * The ID of the instance for which the root volume replacement task was created.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The ID of the root volume replacement task.
         */
        fun replaceRootVolumeTaskId(replaceRootVolumeTaskId: String): FluentBuilder
        /**
         * The time the task was started.
         */
        fun startTime(startTime: String): FluentBuilder
        /**
         * The tags assigned to the task.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The state of the task. The task can be in one of the following states:
         * pending - the replacement volume is being created.
         * in-progress - the original volume is being detached and the
         * replacement volume is being attached.
         * succeeded - the replacement volume has been successfully attached
         * to the instance and the instance is available.
         * failing - the replacement task is in the process of failing.
         * failed - the replacement task has failed but the original root
         * volume is still attached.
         * failing-detached - the replacement task is in the process of failing.
         * The instance might have no root volume attached.
         * failed-detached - the replacement task has failed and the instance
         * has no root volume attached.
         */
        fun taskState(taskState: ReplaceRootVolumeTaskState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time the task completed.
         */
        var completeTime: String?
        /**
         * The ID of the instance for which the root volume replacement task was created.
         */
        var instanceId: String?
        /**
         * The ID of the root volume replacement task.
         */
        var replaceRootVolumeTaskId: String?
        /**
         * The time the task was started.
         */
        var startTime: String?
        /**
         * The tags assigned to the task.
         */
        var tags: List<Tag>?
        /**
         * The state of the task. The task can be in one of the following states:
         * pending - the replacement volume is being created.
         * in-progress - the original volume is being detached and the
         * replacement volume is being attached.
         * succeeded - the replacement volume has been successfully attached
         * to the instance and the instance is available.
         * failing - the replacement task is in the process of failing.
         * failed - the replacement task has failed but the original root
         * volume is still attached.
         * failing-detached - the replacement task is in the process of failing.
         * The instance might have no root volume attached.
         * failed-detached - the replacement task has failed and the instance
         * has no root volume attached.
         */
        var taskState: ReplaceRootVolumeTaskState?

        fun build(): ReplaceRootVolumeTask
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var completeTime: String? = null
        override var instanceId: String? = null
        override var replaceRootVolumeTaskId: String? = null
        override var startTime: String? = null
        override var tags: List<Tag>? = null
        override var taskState: ReplaceRootVolumeTaskState? = null

        constructor(x: ReplaceRootVolumeTask) : this() {
            this.completeTime = x.completeTime
            this.instanceId = x.instanceId
            this.replaceRootVolumeTaskId = x.replaceRootVolumeTaskId
            this.startTime = x.startTime
            this.tags = x.tags
            this.taskState = x.taskState
        }

        override fun build(): ReplaceRootVolumeTask = ReplaceRootVolumeTask(this)
        override fun completeTime(completeTime: String): FluentBuilder = apply { this.completeTime = completeTime }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun replaceRootVolumeTaskId(replaceRootVolumeTaskId: String): FluentBuilder = apply { this.replaceRootVolumeTaskId = replaceRootVolumeTaskId }
        override fun startTime(startTime: String): FluentBuilder = apply { this.startTime = startTime }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun taskState(taskState: ReplaceRootVolumeTaskState): FluentBuilder = apply { this.taskState = taskState }
    }
}
