// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

class ReportInstanceStatusRequest private constructor(builder: BuilderImpl) {
    /**
     * Descriptive text about the health state of your instance.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The time at which the reported instance health state ended.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The instances.
     */
    val instances: List<String>? = builder.instances
    /**
     * The reason codes that describe the health state of your instance.
     * instance-stuck-in-state: My instance is stuck in a state.
     * unresponsive: My instance is unresponsive.
     * not-accepting-credentials: My instance is not accepting my
     * credentials.
     * password-not-available: A password is not available for my
     * instance.
     * performance-network: My instance is experiencing performance
     * problems that I believe are network related.
     * performance-instance-store: My instance is experiencing performance
     * problems that I believe are related to the instance stores.
     * performance-ebs-volume: My instance is experiencing performance
     * problems that I believe are related to an EBS volume.
     * performance-other: My instance is experiencing performance
     * problems.
     * other: &#91;explain using the description parameter&#93;
     */
    val reasonCodes: List<ReportInstanceReasonCodes>? = builder.reasonCodes
    /**
     * The time at which the reported instance health state began.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The status of all instances listed.
     */
    val status: ReportStatusType? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReportInstanceStatusRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReportInstanceStatusRequest(")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("endTime=$endTime,")
        append("instances=$instances,")
        append("reasonCodes=$reasonCodes,")
        append("startTime=$startTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (reasonCodes?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReportInstanceStatusRequest

        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (endTime != other.endTime) return false
        if (instances != other.instances) return false
        if (reasonCodes != other.reasonCodes) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReportInstanceStatusRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReportInstanceStatusRequest
        /**
         * Descriptive text about the health state of your instance.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The time at which the reported instance health state ended.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The instances.
         */
        fun instances(instances: List<String>): FluentBuilder
        /**
         * The reason codes that describe the health state of your instance.
         * instance-stuck-in-state: My instance is stuck in a state.
         * unresponsive: My instance is unresponsive.
         * not-accepting-credentials: My instance is not accepting my
         * credentials.
         * password-not-available: A password is not available for my
         * instance.
         * performance-network: My instance is experiencing performance
         * problems that I believe are network related.
         * performance-instance-store: My instance is experiencing performance
         * problems that I believe are related to the instance stores.
         * performance-ebs-volume: My instance is experiencing performance
         * problems that I believe are related to an EBS volume.
         * performance-other: My instance is experiencing performance
         * problems.
         * other: &#91;explain using the description parameter&#93;
         */
        fun reasonCodes(reasonCodes: List<ReportInstanceReasonCodes>): FluentBuilder
        /**
         * The time at which the reported instance health state began.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The status of all instances listed.
         */
        fun status(status: ReportStatusType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Descriptive text about the health state of your instance.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The time at which the reported instance health state ended.
         */
        var endTime: Instant?
        /**
         * The instances.
         */
        var instances: List<String>?
        /**
         * The reason codes that describe the health state of your instance.
         * instance-stuck-in-state: My instance is stuck in a state.
         * unresponsive: My instance is unresponsive.
         * not-accepting-credentials: My instance is not accepting my
         * credentials.
         * password-not-available: A password is not available for my
         * instance.
         * performance-network: My instance is experiencing performance
         * problems that I believe are network related.
         * performance-instance-store: My instance is experiencing performance
         * problems that I believe are related to the instance stores.
         * performance-ebs-volume: My instance is experiencing performance
         * problems that I believe are related to an EBS volume.
         * performance-other: My instance is experiencing performance
         * problems.
         * other: &#91;explain using the description parameter&#93;
         */
        var reasonCodes: List<ReportInstanceReasonCodes>?
        /**
         * The time at which the reported instance health state began.
         */
        var startTime: Instant?
        /**
         * The status of all instances listed.
         */
        var status: ReportStatusType?

        fun build(): ReportInstanceStatusRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var endTime: Instant? = null
        override var instances: List<String>? = null
        override var reasonCodes: List<ReportInstanceReasonCodes>? = null
        override var startTime: Instant? = null
        override var status: ReportStatusType? = null

        constructor(x: ReportInstanceStatusRequest) : this() {
            this.description = x.description
            this.dryRun = x.dryRun
            this.endTime = x.endTime
            this.instances = x.instances
            this.reasonCodes = x.reasonCodes
            this.startTime = x.startTime
            this.status = x.status
        }

        override fun build(): ReportInstanceStatusRequest = ReportInstanceStatusRequest(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun instances(instances: List<String>): FluentBuilder = apply { this.instances = instances }
        override fun reasonCodes(reasonCodes: List<ReportInstanceReasonCodes>): FluentBuilder = apply { this.reasonCodes = reasonCodes }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun status(status: ReportStatusType): FluentBuilder = apply { this.status = status }
    }
}
