// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The information to include in the launch template.
 */
class RequestLaunchTemplateData private constructor(builder: BuilderImpl) {
    /**
     * The block device mapping.
     */
    val blockDeviceMappings: List<LaunchTemplateBlockDeviceMappingRequest>? = builder.blockDeviceMappings
    /**
     * The Capacity Reservation targeting option. If you do not specify this parameter, the
     * instance's Capacity Reservation preference defaults to open, which enables it
     * to run in any open Capacity Reservation that has matching attributes (instance type,
     * platform, Availability Zone).
     */
    val capacityReservationSpecification: LaunchTemplateCapacityReservationSpecificationRequest? = builder.capacityReservationSpecification
    /**
     * The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU Options in the Amazon Elastic Compute Cloud User
     * Guide.
     */
    val cpuOptions: LaunchTemplateCpuOptionsRequest? = builder.cpuOptions
    /**
     * The credit option for CPU usage of the instance. Valid for T2, T3, or T3a instances
     * only.
     */
    val creditSpecification: CreditSpecificationRequest? = builder.creditSpecification
    /**
     * If you set this parameter to true, you can't terminate the instance using
     * the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch,
     * use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute.
     * Alternatively, if you set InstanceInitiatedShutdownBehavior to
     * terminate, you can terminate the instance by running the shutdown
     * command from the instance.
     */
    val disableApiTermination: Boolean? = builder.disableApiTermination
    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization
     * provides dedicated throughput to Amazon EBS and an optimized configuration stack to
     * provide optimal Amazon EBS I/O performance. This optimization isn't available with all
     * instance types. Additional usage charges apply when using an EBS-optimized
     * instance.
     */
    val ebsOptimized: Boolean? = builder.ebsOptimized
    /**
     * An elastic GPU to associate with the instance.
     */
    val elasticGpuSpecifications: List<ElasticGpuSpecification>? = builder.elasticGpuSpecifications
    /**
     * The elastic inference accelerator for the instance.
     */
    val elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAccelerator>? = builder.elasticInferenceAccelerators
    /**
     * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information,
     * see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">
     * What is Amazon Web Services Nitro Enclaves? in the Amazon Web Services Nitro Enclaves User Guide.
     * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
     */
    val enclaveOptions: LaunchTemplateEnclaveOptionsRequest? = builder.enclaveOptions
    /**
     * Indicates whether an instance is enabled for hibernation. This parameter is valid only
     * if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation
     * prerequisites. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val hibernationOptions: LaunchTemplateHibernationOptionsRequest? = builder.hibernationOptions
    /**
     * The name or Amazon Resource Name (ARN) of an IAM instance profile.
     */
    val iamInstanceProfile: LaunchTemplateIamInstanceProfileSpecificationRequest? = builder.iamInstanceProfile
    /**
     * The ID of the AMI.
     */
    val imageId: String? = builder.imageId
    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from
     * the instance (using the operating system command for system shutdown).
     * Default: stop
     */
    val instanceInitiatedShutdownBehavior: ShutdownBehavior? = builder.instanceInitiatedShutdownBehavior
    /**
     * The market (purchasing) option for the instances.
     */
    val instanceMarketOptions: LaunchTemplateInstanceMarketOptionsRequest? = builder.instanceMarketOptions
    /**
     * The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * The ID of the kernel.
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided
     * Kernels in the Amazon Elastic Compute Cloud User
     * Guide.
     */
    val kernelId: String? = builder.kernelId
    /**
     * The name of the key pair. You can create a key pair using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair.
     * If you do not specify a key pair, you can't connect to the instance unless you
     * choose an AMI that is configured to allow users another way to log in.
     */
    val keyName: String? = builder.keyName
    /**
     * The license configurations.
     */
    val licenseSpecifications: List<LaunchTemplateLicenseConfigurationRequest>? = builder.licenseSpecifications
    /**
     * The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val metadataOptions: LaunchTemplateInstanceMetadataOptionsRequest? = builder.metadataOptions
    /**
     * The monitoring for the instance.
     */
    val monitoring: LaunchTemplatesMonitoringRequest? = builder.monitoring
    /**
     * One or more network interfaces. If you specify a network interface, you must specify
     * any security groups and subnets as part of the network interface.
     */
    val networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>? = builder.networkInterfaces
    /**
     * The placement for the instance.
     */
    val placement: LaunchTemplatePlacementRequest? = builder.placement
    /**
     * The ID of the RAM disk.
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided
     * Kernels in the Amazon Elastic Compute Cloud User
     * Guide.
     */
    val ramDiskId: String? = builder.ramDiskId
    /**
     * One or more security group IDs. You can create a security group using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html">CreateSecurityGroup. You cannot specify both a security group ID and
     * security name in the same request.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * &#91;EC2-Classic, default VPC&#93; One or more security group names. For a nondefault VPC,
     * you must use security group IDs instead. You cannot specify both a security group ID and
     * security name in the same request.
     */
    val securityGroups: List<String>? = builder.securityGroups
    /**
     * The tags to apply to the resources during launch. You can only tag instances and
     * volumes on launch. The specified tags are applied to all instances or volumes that are
     * created during launch. To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
     */
    val tagSpecifications: List<LaunchTemplateTagSpecificationRequest>? = builder.tagSpecifications
    /**
     * The user data to make available to the instance. You must provide base64-encoded text.
     * User data is limited to 16 KB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your Linux Instance
     * at Launch (Linux) or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data">Adding User Data (Windows).
     * If you are creating the launch template for use with Batch, the user data
     * must be provided in the <a href="https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive">
     * MIME multi-part archive format.  For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Amazon EC2 user data in
     * launch templates in the Batch User Guide.
     */
    val userData: String? = builder.userData

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RequestLaunchTemplateData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RequestLaunchTemplateData(")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("capacityReservationSpecification=$capacityReservationSpecification,")
        append("cpuOptions=$cpuOptions,")
        append("creditSpecification=$creditSpecification,")
        append("disableApiTermination=$disableApiTermination,")
        append("ebsOptimized=$ebsOptimized,")
        append("elasticGpuSpecifications=$elasticGpuSpecifications,")
        append("elasticInferenceAccelerators=$elasticInferenceAccelerators,")
        append("enclaveOptions=$enclaveOptions,")
        append("hibernationOptions=$hibernationOptions,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceInitiatedShutdownBehavior=$instanceInitiatedShutdownBehavior,")
        append("instanceMarketOptions=$instanceMarketOptions,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("licenseSpecifications=$licenseSpecifications,")
        append("metadataOptions=$metadataOptions,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("placement=$placement,")
        append("ramDiskId=$ramDiskId,")
        append("securityGroupIds=$securityGroupIds,")
        append("securityGroups=$securityGroups,")
        append("tagSpecifications=$tagSpecifications,")
        append("userData=$userData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDeviceMappings?.hashCode() ?: 0
        result = 31 * result + (capacityReservationSpecification?.hashCode() ?: 0)
        result = 31 * result + (cpuOptions?.hashCode() ?: 0)
        result = 31 * result + (creditSpecification?.hashCode() ?: 0)
        result = 31 * result + (disableApiTermination?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (elasticGpuSpecifications?.hashCode() ?: 0)
        result = 31 * result + (elasticInferenceAccelerators?.hashCode() ?: 0)
        result = 31 * result + (enclaveOptions?.hashCode() ?: 0)
        result = 31 * result + (hibernationOptions?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceInitiatedShutdownBehavior?.hashCode() ?: 0)
        result = 31 * result + (instanceMarketOptions?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (licenseSpecifications?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (ramDiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RequestLaunchTemplateData

        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (capacityReservationSpecification != other.capacityReservationSpecification) return false
        if (cpuOptions != other.cpuOptions) return false
        if (creditSpecification != other.creditSpecification) return false
        if (disableApiTermination != other.disableApiTermination) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (elasticGpuSpecifications != other.elasticGpuSpecifications) return false
        if (elasticInferenceAccelerators != other.elasticInferenceAccelerators) return false
        if (enclaveOptions != other.enclaveOptions) return false
        if (hibernationOptions != other.hibernationOptions) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceInitiatedShutdownBehavior != other.instanceInitiatedShutdownBehavior) return false
        if (instanceMarketOptions != other.instanceMarketOptions) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (licenseSpecifications != other.licenseSpecifications) return false
        if (metadataOptions != other.metadataOptions) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (placement != other.placement) return false
        if (ramDiskId != other.ramDiskId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (securityGroups != other.securityGroups) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (userData != other.userData) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RequestLaunchTemplateData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RequestLaunchTemplateData
        /**
         * The block device mapping.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<LaunchTemplateBlockDeviceMappingRequest>): FluentBuilder
        /**
         * The Capacity Reservation targeting option. If you do not specify this parameter, the
         * instance's Capacity Reservation preference defaults to open, which enables it
         * to run in any open Capacity Reservation that has matching attributes (instance type,
         * platform, Availability Zone).
         */
        fun capacityReservationSpecification(capacityReservationSpecification: LaunchTemplateCapacityReservationSpecificationRequest): FluentBuilder
        /**
         * The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU Options in the Amazon Elastic Compute Cloud User
         * Guide.
         */
        fun cpuOptions(cpuOptions: LaunchTemplateCpuOptionsRequest): FluentBuilder
        /**
         * The credit option for CPU usage of the instance. Valid for T2, T3, or T3a instances
         * only.
         */
        fun creditSpecification(creditSpecification: CreditSpecificationRequest): FluentBuilder
        /**
         * If you set this parameter to true, you can't terminate the instance using
         * the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch,
         * use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute.
         * Alternatively, if you set InstanceInitiatedShutdownBehavior to
         * terminate, you can terminate the instance by running the shutdown
         * command from the instance.
         */
        fun disableApiTermination(disableApiTermination: Boolean): FluentBuilder
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization
         * provides dedicated throughput to Amazon EBS and an optimized configuration stack to
         * provide optimal Amazon EBS I/O performance. This optimization isn't available with all
         * instance types. Additional usage charges apply when using an EBS-optimized
         * instance.
         */
        fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder
        /**
         * An elastic GPU to associate with the instance.
         */
        fun elasticGpuSpecifications(elasticGpuSpecifications: List<ElasticGpuSpecification>): FluentBuilder
        /**
         * The elastic inference accelerator for the instance.
         */
        fun elasticInferenceAccelerators(elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAccelerator>): FluentBuilder
        /**
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information,
         * see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">
         * What is Amazon Web Services Nitro Enclaves? in the Amazon Web Services Nitro Enclaves User Guide.
         * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
         */
        fun enclaveOptions(enclaveOptions: LaunchTemplateEnclaveOptionsRequest): FluentBuilder
        /**
         * Indicates whether an instance is enabled for hibernation. This parameter is valid only
         * if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation
         * prerequisites. For
         * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun hibernationOptions(hibernationOptions: LaunchTemplateHibernationOptionsRequest): FluentBuilder
        /**
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         */
        fun iamInstanceProfile(iamInstanceProfile: LaunchTemplateIamInstanceProfileSpecificationRequest): FluentBuilder
        /**
         * The ID of the AMI.
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from
         * the instance (using the operating system command for system shutdown).
         * Default: stop
         */
        fun instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior: ShutdownBehavior): FluentBuilder
        /**
         * The market (purchasing) option for the instances.
         */
        fun instanceMarketOptions(instanceMarketOptions: LaunchTemplateInstanceMarketOptionsRequest): FluentBuilder
        /**
         * The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * The ID of the kernel.
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided
         * Kernels in the Amazon Elastic Compute Cloud User
         * Guide.
         */
        fun kernelId(kernelId: String): FluentBuilder
        /**
         * The name of the key pair. You can create a key pair using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair.
         * If you do not specify a key pair, you can't connect to the instance unless you
         * choose an AMI that is configured to allow users another way to log in.
         */
        fun keyName(keyName: String): FluentBuilder
        /**
         * The license configurations.
         */
        fun licenseSpecifications(licenseSpecifications: List<LaunchTemplateLicenseConfigurationRequest>): FluentBuilder
        /**
         * The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun metadataOptions(metadataOptions: LaunchTemplateInstanceMetadataOptionsRequest): FluentBuilder
        /**
         * The monitoring for the instance.
         */
        fun monitoring(monitoring: LaunchTemplatesMonitoringRequest): FluentBuilder
        /**
         * One or more network interfaces. If you specify a network interface, you must specify
         * any security groups and subnets as part of the network interface.
         */
        fun networkInterfaces(networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>): FluentBuilder
        /**
         * The placement for the instance.
         */
        fun placement(placement: LaunchTemplatePlacementRequest): FluentBuilder
        /**
         * The ID of the RAM disk.
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided
         * Kernels in the Amazon Elastic Compute Cloud User
         * Guide.
         */
        fun ramDiskId(ramDiskId: String): FluentBuilder
        /**
         * One or more security group IDs. You can create a security group using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html">CreateSecurityGroup. You cannot specify both a security group ID and
         * security name in the same request.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * &#91;EC2-Classic, default VPC&#93; One or more security group names. For a nondefault VPC,
         * you must use security group IDs instead. You cannot specify both a security group ID and
         * security name in the same request.
         */
        fun securityGroups(securityGroups: List<String>): FluentBuilder
        /**
         * The tags to apply to the resources during launch. You can only tag instances and
         * volumes on launch. The specified tags are applied to all instances or volumes that are
         * created during launch. To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
         */
        fun tagSpecifications(tagSpecifications: List<LaunchTemplateTagSpecificationRequest>): FluentBuilder
        /**
         * The user data to make available to the instance. You must provide base64-encoded text.
         * User data is limited to 16 KB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your Linux Instance
         * at Launch (Linux) or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data">Adding User Data (Windows).
         * If you are creating the launch template for use with Batch, the user data
         * must be provided in the <a href="https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive">
         * MIME multi-part archive format.  For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Amazon EC2 user data in
         * launch templates in the Batch User Guide.
         */
        fun userData(userData: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The block device mapping.
         */
        var blockDeviceMappings: List<LaunchTemplateBlockDeviceMappingRequest>?
        /**
         * The Capacity Reservation targeting option. If you do not specify this parameter, the
         * instance's Capacity Reservation preference defaults to open, which enables it
         * to run in any open Capacity Reservation that has matching attributes (instance type,
         * platform, Availability Zone).
         */
        var capacityReservationSpecification: LaunchTemplateCapacityReservationSpecificationRequest?
        /**
         * The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU Options in the Amazon Elastic Compute Cloud User
         * Guide.
         */
        var cpuOptions: LaunchTemplateCpuOptionsRequest?
        /**
         * The credit option for CPU usage of the instance. Valid for T2, T3, or T3a instances
         * only.
         */
        var creditSpecification: CreditSpecificationRequest?
        /**
         * If you set this parameter to true, you can't terminate the instance using
         * the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch,
         * use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute.
         * Alternatively, if you set InstanceInitiatedShutdownBehavior to
         * terminate, you can terminate the instance by running the shutdown
         * command from the instance.
         */
        var disableApiTermination: Boolean?
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization
         * provides dedicated throughput to Amazon EBS and an optimized configuration stack to
         * provide optimal Amazon EBS I/O performance. This optimization isn't available with all
         * instance types. Additional usage charges apply when using an EBS-optimized
         * instance.
         */
        var ebsOptimized: Boolean?
        /**
         * An elastic GPU to associate with the instance.
         */
        var elasticGpuSpecifications: List<ElasticGpuSpecification>?
        /**
         * The elastic inference accelerator for the instance.
         */
        var elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAccelerator>?
        /**
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information,
         * see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">
         * What is Amazon Web Services Nitro Enclaves? in the Amazon Web Services Nitro Enclaves User Guide.
         * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
         */
        var enclaveOptions: LaunchTemplateEnclaveOptionsRequest?
        /**
         * Indicates whether an instance is enabled for hibernation. This parameter is valid only
         * if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation
         * prerequisites. For
         * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var hibernationOptions: LaunchTemplateHibernationOptionsRequest?
        /**
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         */
        var iamInstanceProfile: LaunchTemplateIamInstanceProfileSpecificationRequest?
        /**
         * The ID of the AMI.
         */
        var imageId: String?
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from
         * the instance (using the operating system command for system shutdown).
         * Default: stop
         */
        var instanceInitiatedShutdownBehavior: ShutdownBehavior?
        /**
         * The market (purchasing) option for the instances.
         */
        var instanceMarketOptions: LaunchTemplateInstanceMarketOptionsRequest?
        /**
         * The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var instanceType: InstanceType?
        /**
         * The ID of the kernel.
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided
         * Kernels in the Amazon Elastic Compute Cloud User
         * Guide.
         */
        var kernelId: String?
        /**
         * The name of the key pair. You can create a key pair using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair.
         * If you do not specify a key pair, you can't connect to the instance unless you
         * choose an AMI that is configured to allow users another way to log in.
         */
        var keyName: String?
        /**
         * The license configurations.
         */
        var licenseSpecifications: List<LaunchTemplateLicenseConfigurationRequest>?
        /**
         * The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var metadataOptions: LaunchTemplateInstanceMetadataOptionsRequest?
        /**
         * The monitoring for the instance.
         */
        var monitoring: LaunchTemplatesMonitoringRequest?
        /**
         * One or more network interfaces. If you specify a network interface, you must specify
         * any security groups and subnets as part of the network interface.
         */
        var networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>?
        /**
         * The placement for the instance.
         */
        var placement: LaunchTemplatePlacementRequest?
        /**
         * The ID of the RAM disk.
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided
         * Kernels in the Amazon Elastic Compute Cloud User
         * Guide.
         */
        var ramDiskId: String?
        /**
         * One or more security group IDs. You can create a security group using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html">CreateSecurityGroup. You cannot specify both a security group ID and
         * security name in the same request.
         */
        var securityGroupIds: List<String>?
        /**
         * &#91;EC2-Classic, default VPC&#93; One or more security group names. For a nondefault VPC,
         * you must use security group IDs instead. You cannot specify both a security group ID and
         * security name in the same request.
         */
        var securityGroups: List<String>?
        /**
         * The tags to apply to the resources during launch. You can only tag instances and
         * volumes on launch. The specified tags are applied to all instances or volumes that are
         * created during launch. To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
         */
        var tagSpecifications: List<LaunchTemplateTagSpecificationRequest>?
        /**
         * The user data to make available to the instance. You must provide base64-encoded text.
         * User data is limited to 16 KB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your Linux Instance
         * at Launch (Linux) or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data">Adding User Data (Windows).
         * If you are creating the launch template for use with Batch, the user data
         * must be provided in the <a href="https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive">
         * MIME multi-part archive format.  For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Amazon EC2 user data in
         * launch templates in the Batch User Guide.
         */
        var userData: String?

        fun build(): RequestLaunchTemplateData
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest] inside the given [block]
         */
        fun capacityReservationSpecification(block: LaunchTemplateCapacityReservationSpecificationRequest.DslBuilder.() -> kotlin.Unit) {
            this.capacityReservationSpecification = LaunchTemplateCapacityReservationSpecificationRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptionsRequest] inside the given [block]
         */
        fun cpuOptions(block: LaunchTemplateCpuOptionsRequest.DslBuilder.() -> kotlin.Unit) {
            this.cpuOptions = LaunchTemplateCpuOptionsRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest] inside the given [block]
         */
        fun creditSpecification(block: CreditSpecificationRequest.DslBuilder.() -> kotlin.Unit) {
            this.creditSpecification = CreditSpecificationRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptionsRequest] inside the given [block]
         */
        fun enclaveOptions(block: LaunchTemplateEnclaveOptionsRequest.DslBuilder.() -> kotlin.Unit) {
            this.enclaveOptions = LaunchTemplateEnclaveOptionsRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptionsRequest] inside the given [block]
         */
        fun hibernationOptions(block: LaunchTemplateHibernationOptionsRequest.DslBuilder.() -> kotlin.Unit) {
            this.hibernationOptions = LaunchTemplateHibernationOptionsRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest] inside the given [block]
         */
        fun iamInstanceProfile(block: LaunchTemplateIamInstanceProfileSpecificationRequest.DslBuilder.() -> kotlin.Unit) {
            this.iamInstanceProfile = LaunchTemplateIamInstanceProfileSpecificationRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest] inside the given [block]
         */
        fun instanceMarketOptions(block: LaunchTemplateInstanceMarketOptionsRequest.DslBuilder.() -> kotlin.Unit) {
            this.instanceMarketOptions = LaunchTemplateInstanceMarketOptionsRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest] inside the given [block]
         */
        fun metadataOptions(block: LaunchTemplateInstanceMetadataOptionsRequest.DslBuilder.() -> kotlin.Unit) {
            this.metadataOptions = LaunchTemplateInstanceMetadataOptionsRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoringRequest] inside the given [block]
         */
        fun monitoring(block: LaunchTemplatesMonitoringRequest.DslBuilder.() -> kotlin.Unit) {
            this.monitoring = LaunchTemplatesMonitoringRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacementRequest] inside the given [block]
         */
        fun placement(block: LaunchTemplatePlacementRequest.DslBuilder.() -> kotlin.Unit) {
            this.placement = LaunchTemplatePlacementRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var blockDeviceMappings: List<LaunchTemplateBlockDeviceMappingRequest>? = null
        override var capacityReservationSpecification: LaunchTemplateCapacityReservationSpecificationRequest? = null
        override var cpuOptions: LaunchTemplateCpuOptionsRequest? = null
        override var creditSpecification: CreditSpecificationRequest? = null
        override var disableApiTermination: Boolean? = null
        override var ebsOptimized: Boolean? = null
        override var elasticGpuSpecifications: List<ElasticGpuSpecification>? = null
        override var elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAccelerator>? = null
        override var enclaveOptions: LaunchTemplateEnclaveOptionsRequest? = null
        override var hibernationOptions: LaunchTemplateHibernationOptionsRequest? = null
        override var iamInstanceProfile: LaunchTemplateIamInstanceProfileSpecificationRequest? = null
        override var imageId: String? = null
        override var instanceInitiatedShutdownBehavior: ShutdownBehavior? = null
        override var instanceMarketOptions: LaunchTemplateInstanceMarketOptionsRequest? = null
        override var instanceType: InstanceType? = null
        override var kernelId: String? = null
        override var keyName: String? = null
        override var licenseSpecifications: List<LaunchTemplateLicenseConfigurationRequest>? = null
        override var metadataOptions: LaunchTemplateInstanceMetadataOptionsRequest? = null
        override var monitoring: LaunchTemplatesMonitoringRequest? = null
        override var networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>? = null
        override var placement: LaunchTemplatePlacementRequest? = null
        override var ramDiskId: String? = null
        override var securityGroupIds: List<String>? = null
        override var securityGroups: List<String>? = null
        override var tagSpecifications: List<LaunchTemplateTagSpecificationRequest>? = null
        override var userData: String? = null

        constructor(x: RequestLaunchTemplateData) : this() {
            this.blockDeviceMappings = x.blockDeviceMappings
            this.capacityReservationSpecification = x.capacityReservationSpecification
            this.cpuOptions = x.cpuOptions
            this.creditSpecification = x.creditSpecification
            this.disableApiTermination = x.disableApiTermination
            this.ebsOptimized = x.ebsOptimized
            this.elasticGpuSpecifications = x.elasticGpuSpecifications
            this.elasticInferenceAccelerators = x.elasticInferenceAccelerators
            this.enclaveOptions = x.enclaveOptions
            this.hibernationOptions = x.hibernationOptions
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceInitiatedShutdownBehavior = x.instanceInitiatedShutdownBehavior
            this.instanceMarketOptions = x.instanceMarketOptions
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.licenseSpecifications = x.licenseSpecifications
            this.metadataOptions = x.metadataOptions
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.placement = x.placement
            this.ramDiskId = x.ramDiskId
            this.securityGroupIds = x.securityGroupIds
            this.securityGroups = x.securityGroups
            this.tagSpecifications = x.tagSpecifications
            this.userData = x.userData
        }

        override fun build(): RequestLaunchTemplateData = RequestLaunchTemplateData(this)
        override fun blockDeviceMappings(blockDeviceMappings: List<LaunchTemplateBlockDeviceMappingRequest>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun capacityReservationSpecification(capacityReservationSpecification: LaunchTemplateCapacityReservationSpecificationRequest): FluentBuilder = apply { this.capacityReservationSpecification = capacityReservationSpecification }
        override fun cpuOptions(cpuOptions: LaunchTemplateCpuOptionsRequest): FluentBuilder = apply { this.cpuOptions = cpuOptions }
        override fun creditSpecification(creditSpecification: CreditSpecificationRequest): FluentBuilder = apply { this.creditSpecification = creditSpecification }
        override fun disableApiTermination(disableApiTermination: Boolean): FluentBuilder = apply { this.disableApiTermination = disableApiTermination }
        override fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder = apply { this.ebsOptimized = ebsOptimized }
        override fun elasticGpuSpecifications(elasticGpuSpecifications: List<ElasticGpuSpecification>): FluentBuilder = apply { this.elasticGpuSpecifications = elasticGpuSpecifications }
        override fun elasticInferenceAccelerators(elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAccelerator>): FluentBuilder = apply { this.elasticInferenceAccelerators = elasticInferenceAccelerators }
        override fun enclaveOptions(enclaveOptions: LaunchTemplateEnclaveOptionsRequest): FluentBuilder = apply { this.enclaveOptions = enclaveOptions }
        override fun hibernationOptions(hibernationOptions: LaunchTemplateHibernationOptionsRequest): FluentBuilder = apply { this.hibernationOptions = hibernationOptions }
        override fun iamInstanceProfile(iamInstanceProfile: LaunchTemplateIamInstanceProfileSpecificationRequest): FluentBuilder = apply { this.iamInstanceProfile = iamInstanceProfile }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior: ShutdownBehavior): FluentBuilder = apply { this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior }
        override fun instanceMarketOptions(instanceMarketOptions: LaunchTemplateInstanceMarketOptionsRequest): FluentBuilder = apply { this.instanceMarketOptions = instanceMarketOptions }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun kernelId(kernelId: String): FluentBuilder = apply { this.kernelId = kernelId }
        override fun keyName(keyName: String): FluentBuilder = apply { this.keyName = keyName }
        override fun licenseSpecifications(licenseSpecifications: List<LaunchTemplateLicenseConfigurationRequest>): FluentBuilder = apply { this.licenseSpecifications = licenseSpecifications }
        override fun metadataOptions(metadataOptions: LaunchTemplateInstanceMetadataOptionsRequest): FluentBuilder = apply { this.metadataOptions = metadataOptions }
        override fun monitoring(monitoring: LaunchTemplatesMonitoringRequest): FluentBuilder = apply { this.monitoring = monitoring }
        override fun networkInterfaces(networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>): FluentBuilder = apply { this.networkInterfaces = networkInterfaces }
        override fun placement(placement: LaunchTemplatePlacementRequest): FluentBuilder = apply { this.placement = placement }
        override fun ramDiskId(ramDiskId: String): FluentBuilder = apply { this.ramDiskId = ramDiskId }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun securityGroups(securityGroups: List<String>): FluentBuilder = apply { this.securityGroups = securityGroups }
        override fun tagSpecifications(tagSpecifications: List<LaunchTemplateTagSpecificationRequest>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun userData(userData: String): FluentBuilder = apply { this.userData = userData }
    }
}
