// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the parameters for RequestSpotInstances.
 */
class RequestSpotInstancesRequest private constructor(builder: BuilderImpl) {
    /**
     * The user-specified name for a logical grouping of requests.
     * When you specify an Availability Zone group in a Spot Instance request, all Spot
     * Instances in the request are launched in the same Availability Zone. Instance proximity
     * is maintained with this parameter, but the choice of Availability Zone is not. The group
     * applies only to requests for Spot Instances of the same instance type. Any additional
     * Spot Instance requests that are specified with the same Availability Zone group name are
     * launched in that same Availability Zone, as long as at least one instance from the group
     * is still active.
     * If there is no active instance running in the Availability Zone group that you specify
     * for a new Spot Instance request (all instances are terminated, the request is expired,
     * or the maximum price you specified falls below current Spot price), then Amazon EC2 launches
     * the instance in any Availability Zone where the constraint can be met. Consequently, the
     * subsequent set of Spot Instances could be placed in a different zone from the original
     * request, even if you specified the same Availability Zone group.
     * Default: Instances are launched in any available Availability Zone.
     */
    val availabilityZoneGroup: String? = builder.availabilityZoneGroup
    /**
     * Deprecated.
     */
    val blockDurationMinutes: Int? = builder.blockDurationMinutes
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency in the Amazon EC2 User Guide for Linux Instances.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually
     * making the request, and provides an error response. If you have the required
     * permissions, the error response is DryRunOperation. Otherwise, it is
     * UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The maximum number of Spot Instances to launch.
     * Default: 1
     */
    val instanceCount: Int? = builder.instanceCount
    /**
     * The behavior when a Spot Instance is interrupted. The default is terminate.
     */
    val instanceInterruptionBehavior: InstanceInterruptionBehavior? = builder.instanceInterruptionBehavior
    /**
     * The instance launch group. Launch groups are Spot Instances that launch together and
     * terminate together.
     * Default: Instances are launched and terminated individually
     */
    val launchGroup: String? = builder.launchGroup
    /**
     * The launch specification.
     */
    val launchSpecification: RequestSpotLaunchSpecification? = builder.launchSpecification
    /**
     * The maximum price per hour that you are willing to pay for a Spot Instance. The
     * default is the On-Demand price.
     */
    val spotPrice: String? = builder.spotPrice
    /**
     * The key-value pair for tagging the Spot Instance request on creation. The value for
     * ResourceType must be spot-instances-request, otherwise the
     * Spot Instance request fails. To tag the Spot Instance request after it has been created,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The Spot Instance request type.
     * Default: one-time
     */
    val type: SpotInstanceType? = builder.type
    /**
     * The start date of the request. If this is a one-time request, the request becomes
     * active at this date and time and remains active until all instances launch, the request
     * expires, or the request is canceled. If the request is persistent, the request becomes
     * active at this date and time and remains active until it expires or is canceled.
     * The specified start date and time cannot be equal to the current date and time. You
     * must specify a start date and time that occurs after the current date and time.
     */
    val validFrom: Instant? = builder.validFrom
    /**
     * The end date of the request, in UTC format
     * (YYYY-MM-DDTHH:MM:SSZ).
     * For a persistent request, the request remains active until the
     * ValidUntil date and time is reached. Otherwise, the request
     * remains active until you cancel it.
     * For a one-time request, the request remains active until all instances launch,
     * the request is canceled, or the ValidUntil date and time is
     * reached. By default, the request is valid for 7 days from the date the request
     * was created.
     */
    val validUntil: Instant? = builder.validUntil

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RequestSpotInstancesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RequestSpotInstancesRequest(")
        append("availabilityZoneGroup=$availabilityZoneGroup,")
        append("blockDurationMinutes=$blockDurationMinutes,")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("instanceCount=$instanceCount,")
        append("instanceInterruptionBehavior=$instanceInterruptionBehavior,")
        append("launchGroup=$launchGroup,")
        append("launchSpecification=$launchSpecification,")
        append("spotPrice=$spotPrice,")
        append("tagSpecifications=$tagSpecifications,")
        append("type=$type,")
        append("validFrom=$validFrom,")
        append("validUntil=$validUntil)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneGroup?.hashCode() ?: 0
        result = 31 * result + (blockDurationMinutes ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceInterruptionBehavior?.hashCode() ?: 0)
        result = 31 * result + (launchGroup?.hashCode() ?: 0)
        result = 31 * result + (launchSpecification?.hashCode() ?: 0)
        result = 31 * result + (spotPrice?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (validFrom?.hashCode() ?: 0)
        result = 31 * result + (validUntil?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RequestSpotInstancesRequest

        if (availabilityZoneGroup != other.availabilityZoneGroup) return false
        if (blockDurationMinutes != other.blockDurationMinutes) return false
        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceInterruptionBehavior != other.instanceInterruptionBehavior) return false
        if (launchGroup != other.launchGroup) return false
        if (launchSpecification != other.launchSpecification) return false
        if (spotPrice != other.spotPrice) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (type != other.type) return false
        if (validFrom != other.validFrom) return false
        if (validUntil != other.validUntil) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RequestSpotInstancesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RequestSpotInstancesRequest
        /**
         * The user-specified name for a logical grouping of requests.
         * When you specify an Availability Zone group in a Spot Instance request, all Spot
         * Instances in the request are launched in the same Availability Zone. Instance proximity
         * is maintained with this parameter, but the choice of Availability Zone is not. The group
         * applies only to requests for Spot Instances of the same instance type. Any additional
         * Spot Instance requests that are specified with the same Availability Zone group name are
         * launched in that same Availability Zone, as long as at least one instance from the group
         * is still active.
         * If there is no active instance running in the Availability Zone group that you specify
         * for a new Spot Instance request (all instances are terminated, the request is expired,
         * or the maximum price you specified falls below current Spot price), then Amazon EC2 launches
         * the instance in any Availability Zone where the constraint can be met. Consequently, the
         * subsequent set of Spot Instances could be placed in a different zone from the original
         * request, even if you specified the same Availability Zone group.
         * Default: Instances are launched in any available Availability Zone.
         */
        fun availabilityZoneGroup(availabilityZoneGroup: String): FluentBuilder
        /**
         * Deprecated.
         */
        fun blockDurationMinutes(blockDurationMinutes: Int): FluentBuilder
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency in the Amazon EC2 User Guide for Linux Instances.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The maximum number of Spot Instances to launch.
         * Default: 1
         */
        fun instanceCount(instanceCount: Int): FluentBuilder
        /**
         * The behavior when a Spot Instance is interrupted. The default is terminate.
         */
        fun instanceInterruptionBehavior(instanceInterruptionBehavior: InstanceInterruptionBehavior): FluentBuilder
        /**
         * The instance launch group. Launch groups are Spot Instances that launch together and
         * terminate together.
         * Default: Instances are launched and terminated individually
         */
        fun launchGroup(launchGroup: String): FluentBuilder
        /**
         * The launch specification.
         */
        fun launchSpecification(launchSpecification: RequestSpotLaunchSpecification): FluentBuilder
        /**
         * The maximum price per hour that you are willing to pay for a Spot Instance. The
         * default is the On-Demand price.
         */
        fun spotPrice(spotPrice: String): FluentBuilder
        /**
         * The key-value pair for tagging the Spot Instance request on creation. The value for
         * ResourceType must be spot-instances-request, otherwise the
         * Spot Instance request fails. To tag the Spot Instance request after it has been created,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The Spot Instance request type.
         * Default: one-time
         */
        fun type(type: SpotInstanceType): FluentBuilder
        /**
         * The start date of the request. If this is a one-time request, the request becomes
         * active at this date and time and remains active until all instances launch, the request
         * expires, or the request is canceled. If the request is persistent, the request becomes
         * active at this date and time and remains active until it expires or is canceled.
         * The specified start date and time cannot be equal to the current date and time. You
         * must specify a start date and time that occurs after the current date and time.
         */
        fun validFrom(validFrom: Instant): FluentBuilder
        /**
         * The end date of the request, in UTC format
         * (YYYY-MM-DDTHH:MM:SSZ).
         * For a persistent request, the request remains active until the
         * ValidUntil date and time is reached. Otherwise, the request
         * remains active until you cancel it.
         * For a one-time request, the request remains active until all instances launch,
         * the request is canceled, or the ValidUntil date and time is
         * reached. By default, the request is valid for 7 days from the date the request
         * was created.
         */
        fun validUntil(validUntil: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The user-specified name for a logical grouping of requests.
         * When you specify an Availability Zone group in a Spot Instance request, all Spot
         * Instances in the request are launched in the same Availability Zone. Instance proximity
         * is maintained with this parameter, but the choice of Availability Zone is not. The group
         * applies only to requests for Spot Instances of the same instance type. Any additional
         * Spot Instance requests that are specified with the same Availability Zone group name are
         * launched in that same Availability Zone, as long as at least one instance from the group
         * is still active.
         * If there is no active instance running in the Availability Zone group that you specify
         * for a new Spot Instance request (all instances are terminated, the request is expired,
         * or the maximum price you specified falls below current Spot price), then Amazon EC2 launches
         * the instance in any Availability Zone where the constraint can be met. Consequently, the
         * subsequent set of Spot Instances could be placed in a different zone from the original
         * request, even if you specified the same Availability Zone group.
         * Default: Instances are launched in any available Availability Zone.
         */
        var availabilityZoneGroup: String?
        /**
         * Deprecated.
         */
        var blockDurationMinutes: Int?
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency in the Amazon EC2 User Guide for Linux Instances.
         */
        var clientToken: String?
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The maximum number of Spot Instances to launch.
         * Default: 1
         */
        var instanceCount: Int?
        /**
         * The behavior when a Spot Instance is interrupted. The default is terminate.
         */
        var instanceInterruptionBehavior: InstanceInterruptionBehavior?
        /**
         * The instance launch group. Launch groups are Spot Instances that launch together and
         * terminate together.
         * Default: Instances are launched and terminated individually
         */
        var launchGroup: String?
        /**
         * The launch specification.
         */
        var launchSpecification: RequestSpotLaunchSpecification?
        /**
         * The maximum price per hour that you are willing to pay for a Spot Instance. The
         * default is the On-Demand price.
         */
        var spotPrice: String?
        /**
         * The key-value pair for tagging the Spot Instance request on creation. The value for
         * ResourceType must be spot-instances-request, otherwise the
         * Spot Instance request fails. To tag the Spot Instance request after it has been created,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The Spot Instance request type.
         * Default: one-time
         */
        var type: SpotInstanceType?
        /**
         * The start date of the request. If this is a one-time request, the request becomes
         * active at this date and time and remains active until all instances launch, the request
         * expires, or the request is canceled. If the request is persistent, the request becomes
         * active at this date and time and remains active until it expires or is canceled.
         * The specified start date and time cannot be equal to the current date and time. You
         * must specify a start date and time that occurs after the current date and time.
         */
        var validFrom: Instant?
        /**
         * The end date of the request, in UTC format
         * (YYYY-MM-DDTHH:MM:SSZ).
         * For a persistent request, the request remains active until the
         * ValidUntil date and time is reached. Otherwise, the request
         * remains active until you cancel it.
         * For a one-time request, the request remains active until all instances launch,
         * the request is canceled, or the ValidUntil date and time is
         * reached. By default, the request is valid for 7 days from the date the request
         * was created.
         */
        var validUntil: Instant?

        fun build(): RequestSpotInstancesRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.RequestSpotLaunchSpecification] inside the given [block]
         */
        fun launchSpecification(block: RequestSpotLaunchSpecification.DslBuilder.() -> kotlin.Unit) {
            this.launchSpecification = RequestSpotLaunchSpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZoneGroup: String? = null
        override var blockDurationMinutes: Int? = null
        override var clientToken: String? = null
        override var dryRun: Boolean? = null
        override var instanceCount: Int? = null
        override var instanceInterruptionBehavior: InstanceInterruptionBehavior? = null
        override var launchGroup: String? = null
        override var launchSpecification: RequestSpotLaunchSpecification? = null
        override var spotPrice: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var type: SpotInstanceType? = null
        override var validFrom: Instant? = null
        override var validUntil: Instant? = null

        constructor(x: RequestSpotInstancesRequest) : this() {
            this.availabilityZoneGroup = x.availabilityZoneGroup
            this.blockDurationMinutes = x.blockDurationMinutes
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.instanceCount = x.instanceCount
            this.instanceInterruptionBehavior = x.instanceInterruptionBehavior
            this.launchGroup = x.launchGroup
            this.launchSpecification = x.launchSpecification
            this.spotPrice = x.spotPrice
            this.tagSpecifications = x.tagSpecifications
            this.type = x.type
            this.validFrom = x.validFrom
            this.validUntil = x.validUntil
        }

        override fun build(): RequestSpotInstancesRequest = RequestSpotInstancesRequest(this)
        override fun availabilityZoneGroup(availabilityZoneGroup: String): FluentBuilder = apply { this.availabilityZoneGroup = availabilityZoneGroup }
        override fun blockDurationMinutes(blockDurationMinutes: Int): FluentBuilder = apply { this.blockDurationMinutes = blockDurationMinutes }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun instanceCount(instanceCount: Int): FluentBuilder = apply { this.instanceCount = instanceCount }
        override fun instanceInterruptionBehavior(instanceInterruptionBehavior: InstanceInterruptionBehavior): FluentBuilder = apply { this.instanceInterruptionBehavior = instanceInterruptionBehavior }
        override fun launchGroup(launchGroup: String): FluentBuilder = apply { this.launchGroup = launchGroup }
        override fun launchSpecification(launchSpecification: RequestSpotLaunchSpecification): FluentBuilder = apply { this.launchSpecification = launchSpecification }
        override fun spotPrice(spotPrice: String): FluentBuilder = apply { this.spotPrice = spotPrice }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun type(type: SpotInstanceType): FluentBuilder = apply { this.type = type }
        override fun validFrom(validFrom: Instant): FluentBuilder = apply { this.validFrom = validFrom }
        override fun validUntil(validUntil: Instant): FluentBuilder = apply { this.validUntil = validUntil }
    }
}
