// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about an instance type to use in a Capacity Reservation Fleet.
 */
class ReservationFleetInstanceSpecification private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity
     * Reservation Fleet can't span Availability Zones. All instance type specifications that you specify
     * for the Fleet must use the same Availability Zone.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A
     * Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you
     * specify for the Fleet must use the same Availability Zone.
     */
    val availabilityZoneId: String? = builder.availabilityZoneId
    /**
     * Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types. This
     * optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack
     * to provide optimal I/O performance. This optimization isn't available with all instance types. Additional
     * usage charges apply when using EBS-optimized instance types.
     */
    val ebsOptimized: Boolean? = builder.ebsOptimized
    /**
     * The type of operating system for which the Capacity Reservation Fleet reserves capacity.
     */
    val instancePlatform: CapacityReservationInstancePlatform? = builder.instancePlatform
    /**
     * The instance type for which the Capacity Reservation Fleet reserves capacity.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * The priority to assign to the instance type. This value is used to determine which of the instance types
     * specified for the Fleet should be prioritized for use. A lower value indicates a high priority. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority">Instance type priority
     * in the Amazon EC2 User Guide.
     */
    val priority: Int? = builder.priority
    /**
     * The number of capacity units provided by the specified instance type. This value, together with the
     * total target capacity that you specify for the Fleet determine the number of instances for which the
     * Fleet reserves capacity. Both values are based on units that make sense for your workload. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity
     * in the Amazon EC2 User Guide.
     */
    val weight: Double? = builder.weight

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReservationFleetInstanceSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReservationFleetInstanceSpecification(")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("ebsOptimized=$ebsOptimized,")
        append("instancePlatform=$instancePlatform,")
        append("instanceType=$instanceType,")
        append("priority=$priority,")
        append("weight=$weight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (instancePlatform?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (weight?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReservationFleetInstanceSpecification

        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (instancePlatform != other.instancePlatform) return false
        if (instanceType != other.instanceType) return false
        if (priority != other.priority) return false
        if (weight != other.weight) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReservationFleetInstanceSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReservationFleetInstanceSpecification
        /**
         * The Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity
         * Reservation Fleet can't span Availability Zones. All instance type specifications that you specify
         * for the Fleet must use the same Availability Zone.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A
         * Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you
         * specify for the Fleet must use the same Availability Zone.
         */
        fun availabilityZoneId(availabilityZoneId: String): FluentBuilder
        /**
         * Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types. This
         * optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack
         * to provide optimal I/O performance. This optimization isn't available with all instance types. Additional
         * usage charges apply when using EBS-optimized instance types.
         */
        fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder
        /**
         * The type of operating system for which the Capacity Reservation Fleet reserves capacity.
         */
        fun instancePlatform(instancePlatform: CapacityReservationInstancePlatform): FluentBuilder
        /**
         * The instance type for which the Capacity Reservation Fleet reserves capacity.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * The priority to assign to the instance type. This value is used to determine which of the instance types
         * specified for the Fleet should be prioritized for use. A lower value indicates a high priority. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority">Instance type priority
         * in the Amazon EC2 User Guide.
         */
        fun priority(priority: Int): FluentBuilder
        /**
         * The number of capacity units provided by the specified instance type. This value, together with the
         * total target capacity that you specify for the Fleet determine the number of instances for which the
         * Fleet reserves capacity. Both values are based on units that make sense for your workload. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity
         * in the Amazon EC2 User Guide.
         */
        fun weight(weight: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity
         * Reservation Fleet can't span Availability Zones. All instance type specifications that you specify
         * for the Fleet must use the same Availability Zone.
         */
        var availabilityZone: String?
        /**
         * The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A
         * Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you
         * specify for the Fleet must use the same Availability Zone.
         */
        var availabilityZoneId: String?
        /**
         * Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types. This
         * optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack
         * to provide optimal I/O performance. This optimization isn't available with all instance types. Additional
         * usage charges apply when using EBS-optimized instance types.
         */
        var ebsOptimized: Boolean?
        /**
         * The type of operating system for which the Capacity Reservation Fleet reserves capacity.
         */
        var instancePlatform: CapacityReservationInstancePlatform?
        /**
         * The instance type for which the Capacity Reservation Fleet reserves capacity.
         */
        var instanceType: InstanceType?
        /**
         * The priority to assign to the instance type. This value is used to determine which of the instance types
         * specified for the Fleet should be prioritized for use. A lower value indicates a high priority. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority">Instance type priority
         * in the Amazon EC2 User Guide.
         */
        var priority: Int?
        /**
         * The number of capacity units provided by the specified instance type. This value, together with the
         * total target capacity that you specify for the Fleet determine the number of instances for which the
         * Fleet reserves capacity. Both values are based on units that make sense for your workload. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity
         * in the Amazon EC2 User Guide.
         */
        var weight: Double?

        fun build(): ReservationFleetInstanceSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var availabilityZoneId: String? = null
        override var ebsOptimized: Boolean? = null
        override var instancePlatform: CapacityReservationInstancePlatform? = null
        override var instanceType: InstanceType? = null
        override var priority: Int? = null
        override var weight: Double? = null

        constructor(x: ReservationFleetInstanceSpecification) : this() {
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.ebsOptimized = x.ebsOptimized
            this.instancePlatform = x.instancePlatform
            this.instanceType = x.instanceType
            this.priority = x.priority
            this.weight = x.weight
        }

        override fun build(): ReservationFleetInstanceSpecification = ReservationFleetInstanceSpecification(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun availabilityZoneId(availabilityZoneId: String): FluentBuilder = apply { this.availabilityZoneId = availabilityZoneId }
        override fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder = apply { this.ebsOptimized = ebsOptimized }
        override fun instancePlatform(instancePlatform: CapacityReservationInstancePlatform): FluentBuilder = apply { this.instancePlatform = instancePlatform }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun priority(priority: Int): FluentBuilder = apply { this.priority = priority }
        override fun weight(weight: Double): FluentBuilder = apply { this.weight = weight }
    }
}
