// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Reserved Instance.
 */
class ReservedInstances private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone in which the Reserved Instance can be used.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes.
     * At this time, the only supported currency is USD.
     */
    val currencyCode: CurrencyCodeValues? = builder.currencyCode
    /**
     * The duration of the Reserved Instance, in seconds.
     */
    val duration: Long? = builder.duration
    /**
     * The time when the Reserved Instance expires.
     */
    val end: Instant? = builder.end
    /**
     * The purchase price of the Reserved Instance.
     */
    val fixedPrice: Float? = builder.fixedPrice
    /**
     * The number of reservations purchased.
     */
    val instanceCount: Int? = builder.instanceCount
    /**
     * The tenancy of the instance.
     */
    val instanceTenancy: Tenancy? = builder.instanceTenancy
    /**
     * The instance type on which the Reserved Instance can be used.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * The offering class of the Reserved Instance.
     */
    val offeringClass: OfferingClassType? = builder.offeringClass
    /**
     * The Reserved Instance offering type.
     */
    val offeringType: OfferingTypeValues? = builder.offeringType
    /**
     * The Reserved Instance product platform description.
     */
    val productDescription: RiProductDescription? = builder.productDescription
    /**
     * The recurring charge tag assigned to the resource.
     */
    val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The ID of the Reserved Instance.
     */
    val reservedInstancesId: String? = builder.reservedInstancesId
    /**
     * The scope of the Reserved Instance.
     */
    val scope: Scope? = builder.scope
    /**
     * The date and time the Reserved Instance started.
     */
    val start: Instant? = builder.start
    /**
     * The state of the Reserved Instance purchase.
     */
    val state: ReservedInstanceState? = builder.state
    /**
     * Any tags assigned to the resource.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The usage price of the Reserved Instance, per hour.
     */
    val usagePrice: Float? = builder.usagePrice

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReservedInstances = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedInstances(")
        append("availabilityZone=$availabilityZone,")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("end=$end,")
        append("fixedPrice=$fixedPrice,")
        append("instanceCount=$instanceCount,")
        append("instanceTenancy=$instanceTenancy,")
        append("instanceType=$instanceType,")
        append("offeringClass=$offeringClass,")
        append("offeringType=$offeringType,")
        append("productDescription=$productDescription,")
        append("recurringCharges=$recurringCharges,")
        append("reservedInstancesId=$reservedInstancesId,")
        append("scope=$scope,")
        append("start=$start,")
        append("state=$state,")
        append("tags=$tags,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (duration?.hashCode() ?: 0)
        result = 31 * result + (end?.hashCode() ?: 0)
        result = 31 * result + (fixedPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceTenancy?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (offeringClass?.hashCode() ?: 0)
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (productDescription?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesId?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (start?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (usagePrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReservedInstances

        if (availabilityZone != other.availabilityZone) return false
        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (end != other.end) return false
        if (fixedPrice != other.fixedPrice) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceTenancy != other.instanceTenancy) return false
        if (instanceType != other.instanceType) return false
        if (offeringClass != other.offeringClass) return false
        if (offeringType != other.offeringType) return false
        if (productDescription != other.productDescription) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedInstancesId != other.reservedInstancesId) return false
        if (scope != other.scope) return false
        if (start != other.start) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReservedInstances = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReservedInstances
        /**
         * The Availability Zone in which the Reserved Instance can be used.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes.
         * At this time, the only supported currency is USD.
         */
        fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder
        /**
         * The duration of the Reserved Instance, in seconds.
         */
        fun duration(duration: Long): FluentBuilder
        /**
         * The time when the Reserved Instance expires.
         */
        fun end(end: Instant): FluentBuilder
        /**
         * The purchase price of the Reserved Instance.
         */
        fun fixedPrice(fixedPrice: Float): FluentBuilder
        /**
         * The number of reservations purchased.
         */
        fun instanceCount(instanceCount: Int): FluentBuilder
        /**
         * The tenancy of the instance.
         */
        fun instanceTenancy(instanceTenancy: Tenancy): FluentBuilder
        /**
         * The instance type on which the Reserved Instance can be used.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * The offering class of the Reserved Instance.
         */
        fun offeringClass(offeringClass: OfferingClassType): FluentBuilder
        /**
         * The Reserved Instance offering type.
         */
        fun offeringType(offeringType: OfferingTypeValues): FluentBuilder
        /**
         * The Reserved Instance product platform description.
         */
        fun productDescription(productDescription: RiProductDescription): FluentBuilder
        /**
         * The recurring charge tag assigned to the resource.
         */
        fun recurringCharges(recurringCharges: List<RecurringCharge>): FluentBuilder
        /**
         * The ID of the Reserved Instance.
         */
        fun reservedInstancesId(reservedInstancesId: String): FluentBuilder
        /**
         * The scope of the Reserved Instance.
         */
        fun scope(scope: Scope): FluentBuilder
        /**
         * The date and time the Reserved Instance started.
         */
        fun start(start: Instant): FluentBuilder
        /**
         * The state of the Reserved Instance purchase.
         */
        fun state(state: ReservedInstanceState): FluentBuilder
        /**
         * Any tags assigned to the resource.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The usage price of the Reserved Instance, per hour.
         */
        fun usagePrice(usagePrice: Float): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone in which the Reserved Instance can be used.
         */
        var availabilityZone: String?
        /**
         * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes.
         * At this time, the only supported currency is USD.
         */
        var currencyCode: CurrencyCodeValues?
        /**
         * The duration of the Reserved Instance, in seconds.
         */
        var duration: Long?
        /**
         * The time when the Reserved Instance expires.
         */
        var end: Instant?
        /**
         * The purchase price of the Reserved Instance.
         */
        var fixedPrice: Float?
        /**
         * The number of reservations purchased.
         */
        var instanceCount: Int?
        /**
         * The tenancy of the instance.
         */
        var instanceTenancy: Tenancy?
        /**
         * The instance type on which the Reserved Instance can be used.
         */
        var instanceType: InstanceType?
        /**
         * The offering class of the Reserved Instance.
         */
        var offeringClass: OfferingClassType?
        /**
         * The Reserved Instance offering type.
         */
        var offeringType: OfferingTypeValues?
        /**
         * The Reserved Instance product platform description.
         */
        var productDescription: RiProductDescription?
        /**
         * The recurring charge tag assigned to the resource.
         */
        var recurringCharges: List<RecurringCharge>?
        /**
         * The ID of the Reserved Instance.
         */
        var reservedInstancesId: String?
        /**
         * The scope of the Reserved Instance.
         */
        var scope: Scope?
        /**
         * The date and time the Reserved Instance started.
         */
        var start: Instant?
        /**
         * The state of the Reserved Instance purchase.
         */
        var state: ReservedInstanceState?
        /**
         * Any tags assigned to the resource.
         */
        var tags: List<Tag>?
        /**
         * The usage price of the Reserved Instance, per hour.
         */
        var usagePrice: Float?

        fun build(): ReservedInstances
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var currencyCode: CurrencyCodeValues? = null
        override var duration: Long? = null
        override var end: Instant? = null
        override var fixedPrice: Float? = null
        override var instanceCount: Int? = null
        override var instanceTenancy: Tenancy? = null
        override var instanceType: InstanceType? = null
        override var offeringClass: OfferingClassType? = null
        override var offeringType: OfferingTypeValues? = null
        override var productDescription: RiProductDescription? = null
        override var recurringCharges: List<RecurringCharge>? = null
        override var reservedInstancesId: String? = null
        override var scope: Scope? = null
        override var start: Instant? = null
        override var state: ReservedInstanceState? = null
        override var tags: List<Tag>? = null
        override var usagePrice: Float? = null

        constructor(x: ReservedInstances) : this() {
            this.availabilityZone = x.availabilityZone
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.end = x.end
            this.fixedPrice = x.fixedPrice
            this.instanceCount = x.instanceCount
            this.instanceTenancy = x.instanceTenancy
            this.instanceType = x.instanceType
            this.offeringClass = x.offeringClass
            this.offeringType = x.offeringType
            this.productDescription = x.productDescription
            this.recurringCharges = x.recurringCharges
            this.reservedInstancesId = x.reservedInstancesId
            this.scope = x.scope
            this.start = x.start
            this.state = x.state
            this.tags = x.tags
            this.usagePrice = x.usagePrice
        }

        override fun build(): ReservedInstances = ReservedInstances(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun duration(duration: Long): FluentBuilder = apply { this.duration = duration }
        override fun end(end: Instant): FluentBuilder = apply { this.end = end }
        override fun fixedPrice(fixedPrice: Float): FluentBuilder = apply { this.fixedPrice = fixedPrice }
        override fun instanceCount(instanceCount: Int): FluentBuilder = apply { this.instanceCount = instanceCount }
        override fun instanceTenancy(instanceTenancy: Tenancy): FluentBuilder = apply { this.instanceTenancy = instanceTenancy }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun offeringClass(offeringClass: OfferingClassType): FluentBuilder = apply { this.offeringClass = offeringClass }
        override fun offeringType(offeringType: OfferingTypeValues): FluentBuilder = apply { this.offeringType = offeringType }
        override fun productDescription(productDescription: RiProductDescription): FluentBuilder = apply { this.productDescription = productDescription }
        override fun recurringCharges(recurringCharges: List<RecurringCharge>): FluentBuilder = apply { this.recurringCharges = recurringCharges }
        override fun reservedInstancesId(reservedInstancesId: String): FluentBuilder = apply { this.reservedInstancesId = reservedInstancesId }
        override fun scope(scope: Scope): FluentBuilder = apply { this.scope = scope }
        override fun start(start: Instant): FluentBuilder = apply { this.start = start }
        override fun state(state: ReservedInstanceState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun usagePrice(usagePrice: Float): FluentBuilder = apply { this.usagePrice = usagePrice }
    }
}
