// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Reserved Instance listing.
 */
class ReservedInstancesListing private constructor(builder: BuilderImpl) {
    /**
     * A unique, case-sensitive key supplied by the client to ensure that the request is
     * idempotent. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The time the listing was created.
     */
    val createDate: Instant? = builder.createDate
    /**
     * The number of instances in this state.
     */
    val instanceCounts: List<InstanceCount>? = builder.instanceCounts
    /**
     * The price of the Reserved Instance listing.
     */
    val priceSchedules: List<PriceSchedule>? = builder.priceSchedules
    /**
     * The ID of the Reserved Instance.
     */
    val reservedInstancesId: String? = builder.reservedInstancesId
    /**
     * The ID of the Reserved Instance listing.
     */
    val reservedInstancesListingId: String? = builder.reservedInstancesListingId
    /**
     * The status of the Reserved Instance listing.
     */
    val status: ListingStatus? = builder.status
    /**
     * The reason for the current status of the Reserved Instance listing. The response can be blank.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * Any tags assigned to the resource.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The last modified timestamp of the listing.
     */
    val updateDate: Instant? = builder.updateDate

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReservedInstancesListing = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedInstancesListing(")
        append("clientToken=$clientToken,")
        append("createDate=$createDate,")
        append("instanceCounts=$instanceCounts,")
        append("priceSchedules=$priceSchedules,")
        append("reservedInstancesId=$reservedInstancesId,")
        append("reservedInstancesListingId=$reservedInstancesListingId,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags,")
        append("updateDate=$updateDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (instanceCounts?.hashCode() ?: 0)
        result = 31 * result + (priceSchedules?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesId?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesListingId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReservedInstancesListing

        if (clientToken != other.clientToken) return false
        if (createDate != other.createDate) return false
        if (instanceCounts != other.instanceCounts) return false
        if (priceSchedules != other.priceSchedules) return false
        if (reservedInstancesId != other.reservedInstancesId) return false
        if (reservedInstancesListingId != other.reservedInstancesListingId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false
        if (updateDate != other.updateDate) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReservedInstancesListing = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReservedInstancesListing
        /**
         * A unique, case-sensitive key supplied by the client to ensure that the request is
         * idempotent. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The time the listing was created.
         */
        fun createDate(createDate: Instant): FluentBuilder
        /**
         * The number of instances in this state.
         */
        fun instanceCounts(instanceCounts: List<InstanceCount>): FluentBuilder
        /**
         * The price of the Reserved Instance listing.
         */
        fun priceSchedules(priceSchedules: List<PriceSchedule>): FluentBuilder
        /**
         * The ID of the Reserved Instance.
         */
        fun reservedInstancesId(reservedInstancesId: String): FluentBuilder
        /**
         * The ID of the Reserved Instance listing.
         */
        fun reservedInstancesListingId(reservedInstancesListingId: String): FluentBuilder
        /**
         * The status of the Reserved Instance listing.
         */
        fun status(status: ListingStatus): FluentBuilder
        /**
         * The reason for the current status of the Reserved Instance listing. The response can be blank.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * Any tags assigned to the resource.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The last modified timestamp of the listing.
         */
        fun updateDate(updateDate: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique, case-sensitive key supplied by the client to ensure that the request is
         * idempotent. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: String?
        /**
         * The time the listing was created.
         */
        var createDate: Instant?
        /**
         * The number of instances in this state.
         */
        var instanceCounts: List<InstanceCount>?
        /**
         * The price of the Reserved Instance listing.
         */
        var priceSchedules: List<PriceSchedule>?
        /**
         * The ID of the Reserved Instance.
         */
        var reservedInstancesId: String?
        /**
         * The ID of the Reserved Instance listing.
         */
        var reservedInstancesListingId: String?
        /**
         * The status of the Reserved Instance listing.
         */
        var status: ListingStatus?
        /**
         * The reason for the current status of the Reserved Instance listing. The response can be blank.
         */
        var statusMessage: String?
        /**
         * Any tags assigned to the resource.
         */
        var tags: List<Tag>?
        /**
         * The last modified timestamp of the listing.
         */
        var updateDate: Instant?

        fun build(): ReservedInstancesListing
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var createDate: Instant? = null
        override var instanceCounts: List<InstanceCount>? = null
        override var priceSchedules: List<PriceSchedule>? = null
        override var reservedInstancesId: String? = null
        override var reservedInstancesListingId: String? = null
        override var status: ListingStatus? = null
        override var statusMessage: String? = null
        override var tags: List<Tag>? = null
        override var updateDate: Instant? = null

        constructor(x: ReservedInstancesListing) : this() {
            this.clientToken = x.clientToken
            this.createDate = x.createDate
            this.instanceCounts = x.instanceCounts
            this.priceSchedules = x.priceSchedules
            this.reservedInstancesId = x.reservedInstancesId
            this.reservedInstancesListingId = x.reservedInstancesListingId
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.tags = x.tags
            this.updateDate = x.updateDate
        }

        override fun build(): ReservedInstancesListing = ReservedInstancesListing(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun createDate(createDate: Instant): FluentBuilder = apply { this.createDate = createDate }
        override fun instanceCounts(instanceCounts: List<InstanceCount>): FluentBuilder = apply { this.instanceCounts = instanceCounts }
        override fun priceSchedules(priceSchedules: List<PriceSchedule>): FluentBuilder = apply { this.priceSchedules = priceSchedules }
        override fun reservedInstancesId(reservedInstancesId: String): FluentBuilder = apply { this.reservedInstancesId = reservedInstancesId }
        override fun reservedInstancesListingId(reservedInstancesListingId: String): FluentBuilder = apply { this.reservedInstancesListingId = reservedInstancesListingId }
        override fun status(status: ListingStatus): FluentBuilder = apply { this.status = status }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun updateDate(updateDate: Instant): FluentBuilder = apply { this.updateDate = updateDate }
    }
}
