// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Reserved Instance modification.
 */
class ReservedInstancesModification private constructor(builder: BuilderImpl) {
    /**
     * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The time when the modification request was created.
     */
    val createDate: Instant? = builder.createDate
    /**
     * The time for the modification to become effective.
     */
    val effectiveDate: Instant? = builder.effectiveDate
    /**
     * Contains target configurations along with their corresponding new Reserved Instance IDs.
     */
    val modificationResults: List<ReservedInstancesModificationResult>? = builder.modificationResults
    /**
     * The IDs of one or more Reserved Instances.
     */
    val reservedInstancesIds: List<ReservedInstancesId>? = builder.reservedInstancesIds
    /**
     * A unique ID for the Reserved Instance modification.
     */
    val reservedInstancesModificationId: String? = builder.reservedInstancesModificationId
    /**
     * The status of the Reserved Instances modification request.
     */
    val status: String? = builder.status
    /**
     * The reason for the status.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * The time when the modification request was last updated.
     */
    val updateDate: Instant? = builder.updateDate

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReservedInstancesModification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedInstancesModification(")
        append("clientToken=$clientToken,")
        append("createDate=$createDate,")
        append("effectiveDate=$effectiveDate,")
        append("modificationResults=$modificationResults,")
        append("reservedInstancesIds=$reservedInstancesIds,")
        append("reservedInstancesModificationId=$reservedInstancesModificationId,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("updateDate=$updateDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (effectiveDate?.hashCode() ?: 0)
        result = 31 * result + (modificationResults?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesIds?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesModificationId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (updateDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReservedInstancesModification

        if (clientToken != other.clientToken) return false
        if (createDate != other.createDate) return false
        if (effectiveDate != other.effectiveDate) return false
        if (modificationResults != other.modificationResults) return false
        if (reservedInstancesIds != other.reservedInstancesIds) return false
        if (reservedInstancesModificationId != other.reservedInstancesModificationId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (updateDate != other.updateDate) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReservedInstancesModification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReservedInstancesModification
        /**
         * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The time when the modification request was created.
         */
        fun createDate(createDate: Instant): FluentBuilder
        /**
         * The time for the modification to become effective.
         */
        fun effectiveDate(effectiveDate: Instant): FluentBuilder
        /**
         * Contains target configurations along with their corresponding new Reserved Instance IDs.
         */
        fun modificationResults(modificationResults: List<ReservedInstancesModificationResult>): FluentBuilder
        /**
         * The IDs of one or more Reserved Instances.
         */
        fun reservedInstancesIds(reservedInstancesIds: List<ReservedInstancesId>): FluentBuilder
        /**
         * A unique ID for the Reserved Instance modification.
         */
        fun reservedInstancesModificationId(reservedInstancesModificationId: String): FluentBuilder
        /**
         * The status of the Reserved Instances modification request.
         */
        fun status(status: String): FluentBuilder
        /**
         * The reason for the status.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * The time when the modification request was last updated.
         */
        fun updateDate(updateDate: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         */
        var clientToken: String?
        /**
         * The time when the modification request was created.
         */
        var createDate: Instant?
        /**
         * The time for the modification to become effective.
         */
        var effectiveDate: Instant?
        /**
         * Contains target configurations along with their corresponding new Reserved Instance IDs.
         */
        var modificationResults: List<ReservedInstancesModificationResult>?
        /**
         * The IDs of one or more Reserved Instances.
         */
        var reservedInstancesIds: List<ReservedInstancesId>?
        /**
         * A unique ID for the Reserved Instance modification.
         */
        var reservedInstancesModificationId: String?
        /**
         * The status of the Reserved Instances modification request.
         */
        var status: String?
        /**
         * The reason for the status.
         */
        var statusMessage: String?
        /**
         * The time when the modification request was last updated.
         */
        var updateDate: Instant?

        fun build(): ReservedInstancesModification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var createDate: Instant? = null
        override var effectiveDate: Instant? = null
        override var modificationResults: List<ReservedInstancesModificationResult>? = null
        override var reservedInstancesIds: List<ReservedInstancesId>? = null
        override var reservedInstancesModificationId: String? = null
        override var status: String? = null
        override var statusMessage: String? = null
        override var updateDate: Instant? = null

        constructor(x: ReservedInstancesModification) : this() {
            this.clientToken = x.clientToken
            this.createDate = x.createDate
            this.effectiveDate = x.effectiveDate
            this.modificationResults = x.modificationResults
            this.reservedInstancesIds = x.reservedInstancesIds
            this.reservedInstancesModificationId = x.reservedInstancesModificationId
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.updateDate = x.updateDate
        }

        override fun build(): ReservedInstancesModification = ReservedInstancesModification(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun createDate(createDate: Instant): FluentBuilder = apply { this.createDate = createDate }
        override fun effectiveDate(effectiveDate: Instant): FluentBuilder = apply { this.effectiveDate = effectiveDate }
        override fun modificationResults(modificationResults: List<ReservedInstancesModificationResult>): FluentBuilder = apply { this.modificationResults = modificationResults }
        override fun reservedInstancesIds(reservedInstancesIds: List<ReservedInstancesId>): FluentBuilder = apply { this.reservedInstancesIds = reservedInstancesIds }
        override fun reservedInstancesModificationId(reservedInstancesModificationId: String): FluentBuilder = apply { this.reservedInstancesModificationId = reservedInstancesModificationId }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun updateDate(updateDate: Instant): FluentBuilder = apply { this.updateDate = updateDate }
    }
}
