// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a Reserved Instance offering.
 */
class ReservedInstancesOffering private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone in which the Reserved Instance can be used.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The currency of the Reserved Instance offering you are purchasing. It's
     * specified using ISO 4217 standard currency codes. At this time,
     * the only supported currency is USD.
     */
    val currencyCode: CurrencyCodeValues? = builder.currencyCode
    /**
     * The duration of the Reserved Instance, in seconds.
     */
    val duration: Long? = builder.duration
    /**
     * The purchase price of the Reserved Instance.
     */
    val fixedPrice: Float? = builder.fixedPrice
    /**
     * The tenancy of the instance.
     */
    val instanceTenancy: Tenancy? = builder.instanceTenancy
    /**
     * The instance type on which the Reserved Instance can be used.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or Amazon Web Services.
     * If it's a Reserved Instance Marketplace offering, this is true.
     */
    val marketplace: Boolean? = builder.marketplace
    /**
     * If convertible it can be exchanged for Reserved Instances of
     * the same or higher monetary value, with different configurations. If standard, it is not
     * possible to perform an exchange.
     */
    val offeringClass: OfferingClassType? = builder.offeringClass
    /**
     * The Reserved Instance offering type.
     */
    val offeringType: OfferingTypeValues? = builder.offeringType
    /**
     * The pricing details of the Reserved Instance offering.
     */
    val pricingDetails: List<PricingDetail>? = builder.pricingDetails
    /**
     * The Reserved Instance product platform description.
     */
    val productDescription: RiProductDescription? = builder.productDescription
    /**
     * The recurring charge tag assigned to the resource.
     */
    val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The ID of the Reserved Instance offering. This is the offering ID used in GetReservedInstancesExchangeQuote
     * to confirm that an exchange can be made.
     */
    val reservedInstancesOfferingId: String? = builder.reservedInstancesOfferingId
    /**
     * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
     */
    val scope: Scope? = builder.scope
    /**
     * The usage price of the Reserved Instance, per hour.
     */
    val usagePrice: Float? = builder.usagePrice

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReservedInstancesOffering = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedInstancesOffering(")
        append("availabilityZone=$availabilityZone,")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("instanceTenancy=$instanceTenancy,")
        append("instanceType=$instanceType,")
        append("marketplace=$marketplace,")
        append("offeringClass=$offeringClass,")
        append("offeringType=$offeringType,")
        append("pricingDetails=$pricingDetails,")
        append("productDescription=$productDescription,")
        append("recurringCharges=$recurringCharges,")
        append("reservedInstancesOfferingId=$reservedInstancesOfferingId,")
        append("scope=$scope,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (duration?.hashCode() ?: 0)
        result = 31 * result + (fixedPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceTenancy?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (marketplace?.hashCode() ?: 0)
        result = 31 * result + (offeringClass?.hashCode() ?: 0)
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (pricingDetails?.hashCode() ?: 0)
        result = 31 * result + (productDescription?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesOfferingId?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (usagePrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReservedInstancesOffering

        if (availabilityZone != other.availabilityZone) return false
        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (fixedPrice != other.fixedPrice) return false
        if (instanceTenancy != other.instanceTenancy) return false
        if (instanceType != other.instanceType) return false
        if (marketplace != other.marketplace) return false
        if (offeringClass != other.offeringClass) return false
        if (offeringType != other.offeringType) return false
        if (pricingDetails != other.pricingDetails) return false
        if (productDescription != other.productDescription) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedInstancesOfferingId != other.reservedInstancesOfferingId) return false
        if (scope != other.scope) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReservedInstancesOffering = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReservedInstancesOffering
        /**
         * The Availability Zone in which the Reserved Instance can be used.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The currency of the Reserved Instance offering you are purchasing. It's
         * specified using ISO 4217 standard currency codes. At this time,
         * the only supported currency is USD.
         */
        fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder
        /**
         * The duration of the Reserved Instance, in seconds.
         */
        fun duration(duration: Long): FluentBuilder
        /**
         * The purchase price of the Reserved Instance.
         */
        fun fixedPrice(fixedPrice: Float): FluentBuilder
        /**
         * The tenancy of the instance.
         */
        fun instanceTenancy(instanceTenancy: Tenancy): FluentBuilder
        /**
         * The instance type on which the Reserved Instance can be used.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or Amazon Web Services.
         * If it's a Reserved Instance Marketplace offering, this is true.
         */
        fun marketplace(marketplace: Boolean): FluentBuilder
        /**
         * If convertible it can be exchanged for Reserved Instances of
         * the same or higher monetary value, with different configurations. If standard, it is not
         * possible to perform an exchange.
         */
        fun offeringClass(offeringClass: OfferingClassType): FluentBuilder
        /**
         * The Reserved Instance offering type.
         */
        fun offeringType(offeringType: OfferingTypeValues): FluentBuilder
        /**
         * The pricing details of the Reserved Instance offering.
         */
        fun pricingDetails(pricingDetails: List<PricingDetail>): FluentBuilder
        /**
         * The Reserved Instance product platform description.
         */
        fun productDescription(productDescription: RiProductDescription): FluentBuilder
        /**
         * The recurring charge tag assigned to the resource.
         */
        fun recurringCharges(recurringCharges: List<RecurringCharge>): FluentBuilder
        /**
         * The ID of the Reserved Instance offering. This is the offering ID used in GetReservedInstancesExchangeQuote
         * to confirm that an exchange can be made.
         */
        fun reservedInstancesOfferingId(reservedInstancesOfferingId: String): FluentBuilder
        /**
         * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
         */
        fun scope(scope: Scope): FluentBuilder
        /**
         * The usage price of the Reserved Instance, per hour.
         */
        fun usagePrice(usagePrice: Float): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone in which the Reserved Instance can be used.
         */
        var availabilityZone: String?
        /**
         * The currency of the Reserved Instance offering you are purchasing. It's
         * specified using ISO 4217 standard currency codes. At this time,
         * the only supported currency is USD.
         */
        var currencyCode: CurrencyCodeValues?
        /**
         * The duration of the Reserved Instance, in seconds.
         */
        var duration: Long?
        /**
         * The purchase price of the Reserved Instance.
         */
        var fixedPrice: Float?
        /**
         * The tenancy of the instance.
         */
        var instanceTenancy: Tenancy?
        /**
         * The instance type on which the Reserved Instance can be used.
         */
        var instanceType: InstanceType?
        /**
         * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or Amazon Web Services.
         * If it's a Reserved Instance Marketplace offering, this is true.
         */
        var marketplace: Boolean?
        /**
         * If convertible it can be exchanged for Reserved Instances of
         * the same or higher monetary value, with different configurations. If standard, it is not
         * possible to perform an exchange.
         */
        var offeringClass: OfferingClassType?
        /**
         * The Reserved Instance offering type.
         */
        var offeringType: OfferingTypeValues?
        /**
         * The pricing details of the Reserved Instance offering.
         */
        var pricingDetails: List<PricingDetail>?
        /**
         * The Reserved Instance product platform description.
         */
        var productDescription: RiProductDescription?
        /**
         * The recurring charge tag assigned to the resource.
         */
        var recurringCharges: List<RecurringCharge>?
        /**
         * The ID of the Reserved Instance offering. This is the offering ID used in GetReservedInstancesExchangeQuote
         * to confirm that an exchange can be made.
         */
        var reservedInstancesOfferingId: String?
        /**
         * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
         */
        var scope: Scope?
        /**
         * The usage price of the Reserved Instance, per hour.
         */
        var usagePrice: Float?

        fun build(): ReservedInstancesOffering
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var currencyCode: CurrencyCodeValues? = null
        override var duration: Long? = null
        override var fixedPrice: Float? = null
        override var instanceTenancy: Tenancy? = null
        override var instanceType: InstanceType? = null
        override var marketplace: Boolean? = null
        override var offeringClass: OfferingClassType? = null
        override var offeringType: OfferingTypeValues? = null
        override var pricingDetails: List<PricingDetail>? = null
        override var productDescription: RiProductDescription? = null
        override var recurringCharges: List<RecurringCharge>? = null
        override var reservedInstancesOfferingId: String? = null
        override var scope: Scope? = null
        override var usagePrice: Float? = null

        constructor(x: ReservedInstancesOffering) : this() {
            this.availabilityZone = x.availabilityZone
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.instanceTenancy = x.instanceTenancy
            this.instanceType = x.instanceType
            this.marketplace = x.marketplace
            this.offeringClass = x.offeringClass
            this.offeringType = x.offeringType
            this.pricingDetails = x.pricingDetails
            this.productDescription = x.productDescription
            this.recurringCharges = x.recurringCharges
            this.reservedInstancesOfferingId = x.reservedInstancesOfferingId
            this.scope = x.scope
            this.usagePrice = x.usagePrice
        }

        override fun build(): ReservedInstancesOffering = ReservedInstancesOffering(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun duration(duration: Long): FluentBuilder = apply { this.duration = duration }
        override fun fixedPrice(fixedPrice: Float): FluentBuilder = apply { this.fixedPrice = fixedPrice }
        override fun instanceTenancy(instanceTenancy: Tenancy): FluentBuilder = apply { this.instanceTenancy = instanceTenancy }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun marketplace(marketplace: Boolean): FluentBuilder = apply { this.marketplace = marketplace }
        override fun offeringClass(offeringClass: OfferingClassType): FluentBuilder = apply { this.offeringClass = offeringClass }
        override fun offeringType(offeringType: OfferingTypeValues): FluentBuilder = apply { this.offeringType = offeringType }
        override fun pricingDetails(pricingDetails: List<PricingDetail>): FluentBuilder = apply { this.pricingDetails = pricingDetails }
        override fun productDescription(productDescription: RiProductDescription): FluentBuilder = apply { this.productDescription = productDescription }
        override fun recurringCharges(recurringCharges: List<RecurringCharge>): FluentBuilder = apply { this.recurringCharges = recurringCharges }
        override fun reservedInstancesOfferingId(reservedInstancesOfferingId: String): FluentBuilder = apply { this.reservedInstancesOfferingId = reservedInstancesOfferingId }
        override fun scope(scope: Scope): FluentBuilder = apply { this.scope = scope }
        override fun usagePrice(usagePrice: Float): FluentBuilder = apply { this.usagePrice = usagePrice }
    }
}
