// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The information for a launch template.
 */
class ResponseLaunchTemplateData private constructor(builder: BuilderImpl) {
    /**
     * The block device mappings.
     */
    val blockDeviceMappings: List<LaunchTemplateBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Information about the Capacity Reservation targeting option.
     */
    val capacityReservationSpecification: LaunchTemplateCapacityReservationSpecificationResponse? = builder.capacityReservationSpecification
    /**
     * The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU options in the Amazon Elastic Compute Cloud User
     * Guide.
     */
    val cpuOptions: LaunchTemplateCpuOptions? = builder.cpuOptions
    /**
     * The credit option for CPU usage of the instance.
     */
    val creditSpecification: CreditSpecification? = builder.creditSpecification
    /**
     * If set to true, indicates that the instance cannot be terminated using
     * the Amazon EC2 console, command line tool, or API.
     */
    val disableApiTermination: Boolean? = builder.disableApiTermination
    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     */
    val ebsOptimized: Boolean? = builder.ebsOptimized
    /**
     * The elastic GPU specification.
     */
    val elasticGpuSpecifications: List<ElasticGpuSpecificationResponse>? = builder.elasticGpuSpecifications
    /**
     * The elastic inference accelerator for the instance.
     */
    val elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAcceleratorResponse>? = builder.elasticInferenceAccelerators
    /**
     * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
     */
    val enclaveOptions: LaunchTemplateEnclaveOptions? = builder.enclaveOptions
    /**
     * Indicates whether an instance is configured for hibernation. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate
     * your instance in the Amazon Elastic Compute Cloud User Guide.
     */
    val hibernationOptions: LaunchTemplateHibernationOptions? = builder.hibernationOptions
    /**
     * The IAM instance profile.
     */
    val iamInstanceProfile: LaunchTemplateIamInstanceProfileSpecification? = builder.iamInstanceProfile
    /**
     * The ID of the AMI that was used to launch the instance.
     */
    val imageId: String? = builder.imageId
    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from
     * the instance (using the operating system command for system shutdown).
     */
    val instanceInitiatedShutdownBehavior: ShutdownBehavior? = builder.instanceInitiatedShutdownBehavior
    /**
     * The market (purchasing) option for the instances.
     */
    val instanceMarketOptions: LaunchTemplateInstanceMarketOptions? = builder.instanceMarketOptions
    /**
     * The instance type.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * The ID of the kernel, if applicable.
     */
    val kernelId: String? = builder.kernelId
    /**
     * The name of the key pair.
     */
    val keyName: String? = builder.keyName
    /**
     * The license configurations.
     */
    val licenseSpecifications: List<LaunchTemplateLicenseConfiguration>? = builder.licenseSpecifications
    /**
     * The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val metadataOptions: LaunchTemplateInstanceMetadataOptions? = builder.metadataOptions
    /**
     * The monitoring for the instance.
     */
    val monitoring: LaunchTemplatesMonitoring? = builder.monitoring
    /**
     * The network interfaces.
     */
    val networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecification>? = builder.networkInterfaces
    /**
     * The placement of the instance.
     */
    val placement: LaunchTemplatePlacement? = builder.placement
    /**
     * The ID of the RAM disk, if applicable.
     */
    val ramDiskId: String? = builder.ramDiskId
    /**
     * The security group IDs.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The security group names.
     */
    val securityGroups: List<String>? = builder.securityGroups
    /**
     * The tags.
     */
    val tagSpecifications: List<LaunchTemplateTagSpecification>? = builder.tagSpecifications
    /**
     * The user data for the instance.
     */
    val userData: String? = builder.userData

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ResponseLaunchTemplateData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseLaunchTemplateData(")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("capacityReservationSpecification=$capacityReservationSpecification,")
        append("cpuOptions=$cpuOptions,")
        append("creditSpecification=$creditSpecification,")
        append("disableApiTermination=$disableApiTermination,")
        append("ebsOptimized=$ebsOptimized,")
        append("elasticGpuSpecifications=$elasticGpuSpecifications,")
        append("elasticInferenceAccelerators=$elasticInferenceAccelerators,")
        append("enclaveOptions=$enclaveOptions,")
        append("hibernationOptions=$hibernationOptions,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceInitiatedShutdownBehavior=$instanceInitiatedShutdownBehavior,")
        append("instanceMarketOptions=$instanceMarketOptions,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("licenseSpecifications=$licenseSpecifications,")
        append("metadataOptions=$metadataOptions,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("placement=$placement,")
        append("ramDiskId=$ramDiskId,")
        append("securityGroupIds=$securityGroupIds,")
        append("securityGroups=$securityGroups,")
        append("tagSpecifications=$tagSpecifications,")
        append("userData=$userData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDeviceMappings?.hashCode() ?: 0
        result = 31 * result + (capacityReservationSpecification?.hashCode() ?: 0)
        result = 31 * result + (cpuOptions?.hashCode() ?: 0)
        result = 31 * result + (creditSpecification?.hashCode() ?: 0)
        result = 31 * result + (disableApiTermination?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (elasticGpuSpecifications?.hashCode() ?: 0)
        result = 31 * result + (elasticInferenceAccelerators?.hashCode() ?: 0)
        result = 31 * result + (enclaveOptions?.hashCode() ?: 0)
        result = 31 * result + (hibernationOptions?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceInitiatedShutdownBehavior?.hashCode() ?: 0)
        result = 31 * result + (instanceMarketOptions?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (licenseSpecifications?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (ramDiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ResponseLaunchTemplateData

        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (capacityReservationSpecification != other.capacityReservationSpecification) return false
        if (cpuOptions != other.cpuOptions) return false
        if (creditSpecification != other.creditSpecification) return false
        if (disableApiTermination != other.disableApiTermination) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (elasticGpuSpecifications != other.elasticGpuSpecifications) return false
        if (elasticInferenceAccelerators != other.elasticInferenceAccelerators) return false
        if (enclaveOptions != other.enclaveOptions) return false
        if (hibernationOptions != other.hibernationOptions) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceInitiatedShutdownBehavior != other.instanceInitiatedShutdownBehavior) return false
        if (instanceMarketOptions != other.instanceMarketOptions) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (licenseSpecifications != other.licenseSpecifications) return false
        if (metadataOptions != other.metadataOptions) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (placement != other.placement) return false
        if (ramDiskId != other.ramDiskId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (securityGroups != other.securityGroups) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (userData != other.userData) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ResponseLaunchTemplateData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ResponseLaunchTemplateData
        /**
         * The block device mappings.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<LaunchTemplateBlockDeviceMapping>): FluentBuilder
        /**
         * Information about the Capacity Reservation targeting option.
         */
        fun capacityReservationSpecification(capacityReservationSpecification: LaunchTemplateCapacityReservationSpecificationResponse): FluentBuilder
        /**
         * The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU options in the Amazon Elastic Compute Cloud User
         * Guide.
         */
        fun cpuOptions(cpuOptions: LaunchTemplateCpuOptions): FluentBuilder
        /**
         * The credit option for CPU usage of the instance.
         */
        fun creditSpecification(creditSpecification: CreditSpecification): FluentBuilder
        /**
         * If set to true, indicates that the instance cannot be terminated using
         * the Amazon EC2 console, command line tool, or API.
         */
        fun disableApiTermination(disableApiTermination: Boolean): FluentBuilder
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         */
        fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder
        /**
         * The elastic GPU specification.
         */
        fun elasticGpuSpecifications(elasticGpuSpecifications: List<ElasticGpuSpecificationResponse>): FluentBuilder
        /**
         * The elastic inference accelerator for the instance.
         */
        fun elasticInferenceAccelerators(elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAcceleratorResponse>): FluentBuilder
        /**
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
         */
        fun enclaveOptions(enclaveOptions: LaunchTemplateEnclaveOptions): FluentBuilder
        /**
         * Indicates whether an instance is configured for hibernation. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate
         * your instance in the Amazon Elastic Compute Cloud User Guide.
         */
        fun hibernationOptions(hibernationOptions: LaunchTemplateHibernationOptions): FluentBuilder
        /**
         * The IAM instance profile.
         */
        fun iamInstanceProfile(iamInstanceProfile: LaunchTemplateIamInstanceProfileSpecification): FluentBuilder
        /**
         * The ID of the AMI that was used to launch the instance.
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from
         * the instance (using the operating system command for system shutdown).
         */
        fun instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior: ShutdownBehavior): FluentBuilder
        /**
         * The market (purchasing) option for the instances.
         */
        fun instanceMarketOptions(instanceMarketOptions: LaunchTemplateInstanceMarketOptions): FluentBuilder
        /**
         * The instance type.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * The ID of the kernel, if applicable.
         */
        fun kernelId(kernelId: String): FluentBuilder
        /**
         * The name of the key pair.
         */
        fun keyName(keyName: String): FluentBuilder
        /**
         * The license configurations.
         */
        fun licenseSpecifications(licenseSpecifications: List<LaunchTemplateLicenseConfiguration>): FluentBuilder
        /**
         * The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun metadataOptions(metadataOptions: LaunchTemplateInstanceMetadataOptions): FluentBuilder
        /**
         * The monitoring for the instance.
         */
        fun monitoring(monitoring: LaunchTemplatesMonitoring): FluentBuilder
        /**
         * The network interfaces.
         */
        fun networkInterfaces(networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecification>): FluentBuilder
        /**
         * The placement of the instance.
         */
        fun placement(placement: LaunchTemplatePlacement): FluentBuilder
        /**
         * The ID of the RAM disk, if applicable.
         */
        fun ramDiskId(ramDiskId: String): FluentBuilder
        /**
         * The security group IDs.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * The security group names.
         */
        fun securityGroups(securityGroups: List<String>): FluentBuilder
        /**
         * The tags.
         */
        fun tagSpecifications(tagSpecifications: List<LaunchTemplateTagSpecification>): FluentBuilder
        /**
         * The user data for the instance.
         */
        fun userData(userData: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The block device mappings.
         */
        var blockDeviceMappings: List<LaunchTemplateBlockDeviceMapping>?
        /**
         * Information about the Capacity Reservation targeting option.
         */
        var capacityReservationSpecification: LaunchTemplateCapacityReservationSpecificationResponse?
        /**
         * The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU options in the Amazon Elastic Compute Cloud User
         * Guide.
         */
        var cpuOptions: LaunchTemplateCpuOptions?
        /**
         * The credit option for CPU usage of the instance.
         */
        var creditSpecification: CreditSpecification?
        /**
         * If set to true, indicates that the instance cannot be terminated using
         * the Amazon EC2 console, command line tool, or API.
         */
        var disableApiTermination: Boolean?
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         */
        var ebsOptimized: Boolean?
        /**
         * The elastic GPU specification.
         */
        var elasticGpuSpecifications: List<ElasticGpuSpecificationResponse>?
        /**
         * The elastic inference accelerator for the instance.
         */
        var elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAcceleratorResponse>?
        /**
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
         */
        var enclaveOptions: LaunchTemplateEnclaveOptions?
        /**
         * Indicates whether an instance is configured for hibernation. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate
         * your instance in the Amazon Elastic Compute Cloud User Guide.
         */
        var hibernationOptions: LaunchTemplateHibernationOptions?
        /**
         * The IAM instance profile.
         */
        var iamInstanceProfile: LaunchTemplateIamInstanceProfileSpecification?
        /**
         * The ID of the AMI that was used to launch the instance.
         */
        var imageId: String?
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from
         * the instance (using the operating system command for system shutdown).
         */
        var instanceInitiatedShutdownBehavior: ShutdownBehavior?
        /**
         * The market (purchasing) option for the instances.
         */
        var instanceMarketOptions: LaunchTemplateInstanceMarketOptions?
        /**
         * The instance type.
         */
        var instanceType: InstanceType?
        /**
         * The ID of the kernel, if applicable.
         */
        var kernelId: String?
        /**
         * The name of the key pair.
         */
        var keyName: String?
        /**
         * The license configurations.
         */
        var licenseSpecifications: List<LaunchTemplateLicenseConfiguration>?
        /**
         * The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var metadataOptions: LaunchTemplateInstanceMetadataOptions?
        /**
         * The monitoring for the instance.
         */
        var monitoring: LaunchTemplatesMonitoring?
        /**
         * The network interfaces.
         */
        var networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecification>?
        /**
         * The placement of the instance.
         */
        var placement: LaunchTemplatePlacement?
        /**
         * The ID of the RAM disk, if applicable.
         */
        var ramDiskId: String?
        /**
         * The security group IDs.
         */
        var securityGroupIds: List<String>?
        /**
         * The security group names.
         */
        var securityGroups: List<String>?
        /**
         * The tags.
         */
        var tagSpecifications: List<LaunchTemplateTagSpecification>?
        /**
         * The user data for the instance.
         */
        var userData: String?

        fun build(): ResponseLaunchTemplateData
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse] inside the given [block]
         */
        fun capacityReservationSpecification(block: LaunchTemplateCapacityReservationSpecificationResponse.DslBuilder.() -> kotlin.Unit) {
            this.capacityReservationSpecification = LaunchTemplateCapacityReservationSpecificationResponse.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptions] inside the given [block]
         */
        fun cpuOptions(block: LaunchTemplateCpuOptions.DslBuilder.() -> kotlin.Unit) {
            this.cpuOptions = LaunchTemplateCpuOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CreditSpecification] inside the given [block]
         */
        fun creditSpecification(block: CreditSpecification.DslBuilder.() -> kotlin.Unit) {
            this.creditSpecification = CreditSpecification.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptions] inside the given [block]
         */
        fun enclaveOptions(block: LaunchTemplateEnclaveOptions.DslBuilder.() -> kotlin.Unit) {
            this.enclaveOptions = LaunchTemplateEnclaveOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptions] inside the given [block]
         */
        fun hibernationOptions(block: LaunchTemplateHibernationOptions.DslBuilder.() -> kotlin.Unit) {
            this.hibernationOptions = LaunchTemplateHibernationOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecification] inside the given [block]
         */
        fun iamInstanceProfile(block: LaunchTemplateIamInstanceProfileSpecification.DslBuilder.() -> kotlin.Unit) {
            this.iamInstanceProfile = LaunchTemplateIamInstanceProfileSpecification.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptions] inside the given [block]
         */
        fun instanceMarketOptions(block: LaunchTemplateInstanceMarketOptions.DslBuilder.() -> kotlin.Unit) {
            this.instanceMarketOptions = LaunchTemplateInstanceMarketOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptions] inside the given [block]
         */
        fun metadataOptions(block: LaunchTemplateInstanceMetadataOptions.DslBuilder.() -> kotlin.Unit) {
            this.metadataOptions = LaunchTemplateInstanceMetadataOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoring] inside the given [block]
         */
        fun monitoring(block: LaunchTemplatesMonitoring.DslBuilder.() -> kotlin.Unit) {
            this.monitoring = LaunchTemplatesMonitoring.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacement] inside the given [block]
         */
        fun placement(block: LaunchTemplatePlacement.DslBuilder.() -> kotlin.Unit) {
            this.placement = LaunchTemplatePlacement.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var blockDeviceMappings: List<LaunchTemplateBlockDeviceMapping>? = null
        override var capacityReservationSpecification: LaunchTemplateCapacityReservationSpecificationResponse? = null
        override var cpuOptions: LaunchTemplateCpuOptions? = null
        override var creditSpecification: CreditSpecification? = null
        override var disableApiTermination: Boolean? = null
        override var ebsOptimized: Boolean? = null
        override var elasticGpuSpecifications: List<ElasticGpuSpecificationResponse>? = null
        override var elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAcceleratorResponse>? = null
        override var enclaveOptions: LaunchTemplateEnclaveOptions? = null
        override var hibernationOptions: LaunchTemplateHibernationOptions? = null
        override var iamInstanceProfile: LaunchTemplateIamInstanceProfileSpecification? = null
        override var imageId: String? = null
        override var instanceInitiatedShutdownBehavior: ShutdownBehavior? = null
        override var instanceMarketOptions: LaunchTemplateInstanceMarketOptions? = null
        override var instanceType: InstanceType? = null
        override var kernelId: String? = null
        override var keyName: String? = null
        override var licenseSpecifications: List<LaunchTemplateLicenseConfiguration>? = null
        override var metadataOptions: LaunchTemplateInstanceMetadataOptions? = null
        override var monitoring: LaunchTemplatesMonitoring? = null
        override var networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecification>? = null
        override var placement: LaunchTemplatePlacement? = null
        override var ramDiskId: String? = null
        override var securityGroupIds: List<String>? = null
        override var securityGroups: List<String>? = null
        override var tagSpecifications: List<LaunchTemplateTagSpecification>? = null
        override var userData: String? = null

        constructor(x: ResponseLaunchTemplateData) : this() {
            this.blockDeviceMappings = x.blockDeviceMappings
            this.capacityReservationSpecification = x.capacityReservationSpecification
            this.cpuOptions = x.cpuOptions
            this.creditSpecification = x.creditSpecification
            this.disableApiTermination = x.disableApiTermination
            this.ebsOptimized = x.ebsOptimized
            this.elasticGpuSpecifications = x.elasticGpuSpecifications
            this.elasticInferenceAccelerators = x.elasticInferenceAccelerators
            this.enclaveOptions = x.enclaveOptions
            this.hibernationOptions = x.hibernationOptions
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceInitiatedShutdownBehavior = x.instanceInitiatedShutdownBehavior
            this.instanceMarketOptions = x.instanceMarketOptions
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.licenseSpecifications = x.licenseSpecifications
            this.metadataOptions = x.metadataOptions
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.placement = x.placement
            this.ramDiskId = x.ramDiskId
            this.securityGroupIds = x.securityGroupIds
            this.securityGroups = x.securityGroups
            this.tagSpecifications = x.tagSpecifications
            this.userData = x.userData
        }

        override fun build(): ResponseLaunchTemplateData = ResponseLaunchTemplateData(this)
        override fun blockDeviceMappings(blockDeviceMappings: List<LaunchTemplateBlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun capacityReservationSpecification(capacityReservationSpecification: LaunchTemplateCapacityReservationSpecificationResponse): FluentBuilder = apply { this.capacityReservationSpecification = capacityReservationSpecification }
        override fun cpuOptions(cpuOptions: LaunchTemplateCpuOptions): FluentBuilder = apply { this.cpuOptions = cpuOptions }
        override fun creditSpecification(creditSpecification: CreditSpecification): FluentBuilder = apply { this.creditSpecification = creditSpecification }
        override fun disableApiTermination(disableApiTermination: Boolean): FluentBuilder = apply { this.disableApiTermination = disableApiTermination }
        override fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder = apply { this.ebsOptimized = ebsOptimized }
        override fun elasticGpuSpecifications(elasticGpuSpecifications: List<ElasticGpuSpecificationResponse>): FluentBuilder = apply { this.elasticGpuSpecifications = elasticGpuSpecifications }
        override fun elasticInferenceAccelerators(elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAcceleratorResponse>): FluentBuilder = apply { this.elasticInferenceAccelerators = elasticInferenceAccelerators }
        override fun enclaveOptions(enclaveOptions: LaunchTemplateEnclaveOptions): FluentBuilder = apply { this.enclaveOptions = enclaveOptions }
        override fun hibernationOptions(hibernationOptions: LaunchTemplateHibernationOptions): FluentBuilder = apply { this.hibernationOptions = hibernationOptions }
        override fun iamInstanceProfile(iamInstanceProfile: LaunchTemplateIamInstanceProfileSpecification): FluentBuilder = apply { this.iamInstanceProfile = iamInstanceProfile }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior: ShutdownBehavior): FluentBuilder = apply { this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior }
        override fun instanceMarketOptions(instanceMarketOptions: LaunchTemplateInstanceMarketOptions): FluentBuilder = apply { this.instanceMarketOptions = instanceMarketOptions }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun kernelId(kernelId: String): FluentBuilder = apply { this.kernelId = kernelId }
        override fun keyName(keyName: String): FluentBuilder = apply { this.keyName = keyName }
        override fun licenseSpecifications(licenseSpecifications: List<LaunchTemplateLicenseConfiguration>): FluentBuilder = apply { this.licenseSpecifications = licenseSpecifications }
        override fun metadataOptions(metadataOptions: LaunchTemplateInstanceMetadataOptions): FluentBuilder = apply { this.metadataOptions = metadataOptions }
        override fun monitoring(monitoring: LaunchTemplatesMonitoring): FluentBuilder = apply { this.monitoring = monitoring }
        override fun networkInterfaces(networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecification>): FluentBuilder = apply { this.networkInterfaces = networkInterfaces }
        override fun placement(placement: LaunchTemplatePlacement): FluentBuilder = apply { this.placement = placement }
        override fun ramDiskId(ramDiskId: String): FluentBuilder = apply { this.ramDiskId = ramDiskId }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun securityGroups(securityGroups: List<String>): FluentBuilder = apply { this.securityGroups = securityGroups }
        override fun tagSpecifications(tagSpecifications: List<LaunchTemplateTagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun userData(userData: String): FluentBuilder = apply { this.userData = userData }
    }
}
