// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class RevokeSecurityGroupIngressRequest private constructor(builder: BuilderImpl) {
    /**
     * The CIDR IP address range. You can't specify this parameter when specifying a source security group.
     */
    val cidrIp: String? = builder.cidrIp
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number,
     * use -1 to specify all ICMP types.
     */
    val fromPort: Int? = builder.fromPort
    /**
     * The ID of the security group. You must specify either the security group ID or the
     * security group name in the request. For security groups in a nondefault VPC, you must
     * specify the security group ID.
     */
    val groupId: String? = builder.groupId
    /**
     * &#91;EC2-Classic, default VPC&#93; The name of the security group. You must specify either the
     * security group ID or the security group name in the request.
     */
    val groupName: String? = builder.groupName
    /**
     * The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same set of permissions.
     */
    val ipPermissions: List<IpPermission>? = builder.ipPermissions
    /**
     * The IP protocol name (tcp, udp, icmp) or number
     * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
     * Use -1 to specify all.
     */
    val ipProtocol: String? = builder.ipProtocol
    /**
     * The IDs of the security group rules.
     */
    val securityGroupRuleIds: List<String>? = builder.securityGroupRuleIds
    /**
     * &#91;EC2-Classic, default VPC&#93; The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same VPC. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
     */
    val sourceSecurityGroupName: String? = builder.sourceSecurityGroupName
    /**
     * &#91;EC2-Classic&#93; The Amazon Web Services account ID of the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
     */
    val sourceSecurityGroupOwnerId: String? = builder.sourceSecurityGroupOwnerId
    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number,
     * use -1 to specify all ICMP codes for the ICMP type.
     */
    val toPort: Int? = builder.toPort

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RevokeSecurityGroupIngressRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RevokeSecurityGroupIngressRequest(")
        append("cidrIp=$cidrIp,")
        append("dryRun=$dryRun,")
        append("fromPort=$fromPort,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("ipPermissions=$ipPermissions,")
        append("ipProtocol=$ipProtocol,")
        append("securityGroupRuleIds=$securityGroupRuleIds,")
        append("sourceSecurityGroupName=$sourceSecurityGroupName,")
        append("sourceSecurityGroupOwnerId=$sourceSecurityGroupOwnerId,")
        append("toPort=$toPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrIp?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (fromPort ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (ipPermissions?.hashCode() ?: 0)
        result = 31 * result + (ipProtocol?.hashCode() ?: 0)
        result = 31 * result + (securityGroupRuleIds?.hashCode() ?: 0)
        result = 31 * result + (sourceSecurityGroupName?.hashCode() ?: 0)
        result = 31 * result + (sourceSecurityGroupOwnerId?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RevokeSecurityGroupIngressRequest

        if (cidrIp != other.cidrIp) return false
        if (dryRun != other.dryRun) return false
        if (fromPort != other.fromPort) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (ipPermissions != other.ipPermissions) return false
        if (ipProtocol != other.ipProtocol) return false
        if (securityGroupRuleIds != other.securityGroupRuleIds) return false
        if (sourceSecurityGroupName != other.sourceSecurityGroupName) return false
        if (sourceSecurityGroupOwnerId != other.sourceSecurityGroupOwnerId) return false
        if (toPort != other.toPort) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RevokeSecurityGroupIngressRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RevokeSecurityGroupIngressRequest
        /**
         * The CIDR IP address range. You can't specify this parameter when specifying a source security group.
         */
        fun cidrIp(cidrIp: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number,
         * use -1 to specify all ICMP types.
         */
        fun fromPort(fromPort: Int): FluentBuilder
        /**
         * The ID of the security group. You must specify either the security group ID or the
         * security group name in the request. For security groups in a nondefault VPC, you must
         * specify the security group ID.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * &#91;EC2-Classic, default VPC&#93; The name of the security group. You must specify either the
         * security group ID or the security group name in the request.
         */
        fun groupName(groupName: String): FluentBuilder
        /**
         * The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same set of permissions.
         */
        fun ipPermissions(ipPermissions: List<IpPermission>): FluentBuilder
        /**
         * The IP protocol name (tcp, udp, icmp) or number
         * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
         * Use -1 to specify all.
         */
        fun ipProtocol(ipProtocol: String): FluentBuilder
        /**
         * The IDs of the security group rules.
         */
        fun securityGroupRuleIds(securityGroupRuleIds: List<String>): FluentBuilder
        /**
         * &#91;EC2-Classic, default VPC&#93; The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same VPC. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
         */
        fun sourceSecurityGroupName(sourceSecurityGroupName: String): FluentBuilder
        /**
         * &#91;EC2-Classic&#93; The Amazon Web Services account ID of the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
         */
        fun sourceSecurityGroupOwnerId(sourceSecurityGroupOwnerId: String): FluentBuilder
        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number,
         * use -1 to specify all ICMP codes for the ICMP type.
         */
        fun toPort(toPort: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The CIDR IP address range. You can't specify this parameter when specifying a source security group.
         */
        var cidrIp: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number,
         * use -1 to specify all ICMP types.
         */
        var fromPort: Int?
        /**
         * The ID of the security group. You must specify either the security group ID or the
         * security group name in the request. For security groups in a nondefault VPC, you must
         * specify the security group ID.
         */
        var groupId: String?
        /**
         * &#91;EC2-Classic, default VPC&#93; The name of the security group. You must specify either the
         * security group ID or the security group name in the request.
         */
        var groupName: String?
        /**
         * The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same set of permissions.
         */
        var ipPermissions: List<IpPermission>?
        /**
         * The IP protocol name (tcp, udp, icmp) or number
         * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
         * Use -1 to specify all.
         */
        var ipProtocol: String?
        /**
         * The IDs of the security group rules.
         */
        var securityGroupRuleIds: List<String>?
        /**
         * &#91;EC2-Classic, default VPC&#93; The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same VPC. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
         */
        var sourceSecurityGroupName: String?
        /**
         * &#91;EC2-Classic&#93; The Amazon Web Services account ID of the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
         */
        var sourceSecurityGroupOwnerId: String?
        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number,
         * use -1 to specify all ICMP codes for the ICMP type.
         */
        var toPort: Int?

        fun build(): RevokeSecurityGroupIngressRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidrIp: String? = null
        override var dryRun: Boolean? = null
        override var fromPort: Int? = null
        override var groupId: String? = null
        override var groupName: String? = null
        override var ipPermissions: List<IpPermission>? = null
        override var ipProtocol: String? = null
        override var securityGroupRuleIds: List<String>? = null
        override var sourceSecurityGroupName: String? = null
        override var sourceSecurityGroupOwnerId: String? = null
        override var toPort: Int? = null

        constructor(x: RevokeSecurityGroupIngressRequest) : this() {
            this.cidrIp = x.cidrIp
            this.dryRun = x.dryRun
            this.fromPort = x.fromPort
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.ipPermissions = x.ipPermissions
            this.ipProtocol = x.ipProtocol
            this.securityGroupRuleIds = x.securityGroupRuleIds
            this.sourceSecurityGroupName = x.sourceSecurityGroupName
            this.sourceSecurityGroupOwnerId = x.sourceSecurityGroupOwnerId
            this.toPort = x.toPort
        }

        override fun build(): RevokeSecurityGroupIngressRequest = RevokeSecurityGroupIngressRequest(this)
        override fun cidrIp(cidrIp: String): FluentBuilder = apply { this.cidrIp = cidrIp }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun fromPort(fromPort: Int): FluentBuilder = apply { this.fromPort = fromPort }
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun groupName(groupName: String): FluentBuilder = apply { this.groupName = groupName }
        override fun ipPermissions(ipPermissions: List<IpPermission>): FluentBuilder = apply { this.ipPermissions = ipPermissions }
        override fun ipProtocol(ipProtocol: String): FluentBuilder = apply { this.ipProtocol = ipProtocol }
        override fun securityGroupRuleIds(securityGroupRuleIds: List<String>): FluentBuilder = apply { this.securityGroupRuleIds = securityGroupRuleIds }
        override fun sourceSecurityGroupName(sourceSecurityGroupName: String): FluentBuilder = apply { this.sourceSecurityGroupName = sourceSecurityGroupName }
        override fun sourceSecurityGroupOwnerId(sourceSecurityGroupOwnerId: String): FluentBuilder = apply { this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId }
        override fun toPort(toPort: Int): FluentBuilder = apply { this.toPort = toPort }
    }
}
