// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a route in a route table.
 */
class Route private constructor(builder: BuilderImpl) {
    /**
     * The ID of the carrier gateway.
     */
    val carrierGatewayId: String? = builder.carrierGatewayId
    /**
     * The IPv4 CIDR block used for the destination match.
     */
    val destinationCidrBlock: String? = builder.destinationCidrBlock
    /**
     * The IPv6 CIDR block used for the destination match.
     */
    val destinationIpv6CidrBlock: String? = builder.destinationIpv6CidrBlock
    /**
     * The prefix of the Amazon Web Service.
     */
    val destinationPrefixListId: String? = builder.destinationPrefixListId
    /**
     * The ID of the egress-only internet gateway.
     */
    val egressOnlyInternetGatewayId: String? = builder.egressOnlyInternetGatewayId
    /**
     * The ID of a gateway attached to your VPC.
     */
    val gatewayId: String? = builder.gatewayId
    /**
     * The ID of a NAT instance in your VPC.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The ID of Amazon Web Services account that owns the instance.
     */
    val instanceOwnerId: String? = builder.instanceOwnerId
    /**
     * The ID of the local gateway.
     */
    val localGatewayId: String? = builder.localGatewayId
    /**
     * The ID of a NAT gateway.
     */
    val natGatewayId: String? = builder.natGatewayId
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * Describes how the route was created.
     * CreateRouteTable - The route was automatically created when the route table was created.
     * CreateRoute - The route was manually added to the route table.
     * EnableVgwRoutePropagation - The route was propagated by route propagation.
     */
    val origin: RouteOrigin? = builder.origin
    /**
     * The state of the route. The blackhole state indicates that the
     * route's target isn't available (for example, the specified gateway isn't attached to the
     * VPC, or the specified NAT instance has been terminated).
     */
    val state: RouteState? = builder.state
    /**
     * The ID of a transit gateway.
     */
    val transitGatewayId: String? = builder.transitGatewayId
    /**
     * The ID of a VPC peering connection.
     */
    val vpcPeeringConnectionId: String? = builder.vpcPeeringConnectionId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Route = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Route(")
        append("carrierGatewayId=$carrierGatewayId,")
        append("destinationCidrBlock=$destinationCidrBlock,")
        append("destinationIpv6CidrBlock=$destinationIpv6CidrBlock,")
        append("destinationPrefixListId=$destinationPrefixListId,")
        append("egressOnlyInternetGatewayId=$egressOnlyInternetGatewayId,")
        append("gatewayId=$gatewayId,")
        append("instanceId=$instanceId,")
        append("instanceOwnerId=$instanceOwnerId,")
        append("localGatewayId=$localGatewayId,")
        append("natGatewayId=$natGatewayId,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("origin=$origin,")
        append("state=$state,")
        append("transitGatewayId=$transitGatewayId,")
        append("vpcPeeringConnectionId=$vpcPeeringConnectionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = carrierGatewayId?.hashCode() ?: 0
        result = 31 * result + (destinationCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (destinationIpv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (destinationPrefixListId?.hashCode() ?: 0)
        result = 31 * result + (egressOnlyInternetGatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (localGatewayId?.hashCode() ?: 0)
        result = 31 * result + (natGatewayId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Route

        if (carrierGatewayId != other.carrierGatewayId) return false
        if (destinationCidrBlock != other.destinationCidrBlock) return false
        if (destinationIpv6CidrBlock != other.destinationIpv6CidrBlock) return false
        if (destinationPrefixListId != other.destinationPrefixListId) return false
        if (egressOnlyInternetGatewayId != other.egressOnlyInternetGatewayId) return false
        if (gatewayId != other.gatewayId) return false
        if (instanceId != other.instanceId) return false
        if (instanceOwnerId != other.instanceOwnerId) return false
        if (localGatewayId != other.localGatewayId) return false
        if (natGatewayId != other.natGatewayId) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (origin != other.origin) return false
        if (state != other.state) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (vpcPeeringConnectionId != other.vpcPeeringConnectionId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Route = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Route
        /**
         * The ID of the carrier gateway.
         */
        fun carrierGatewayId(carrierGatewayId: String): FluentBuilder
        /**
         * The IPv4 CIDR block used for the destination match.
         */
        fun destinationCidrBlock(destinationCidrBlock: String): FluentBuilder
        /**
         * The IPv6 CIDR block used for the destination match.
         */
        fun destinationIpv6CidrBlock(destinationIpv6CidrBlock: String): FluentBuilder
        /**
         * The prefix of the Amazon Web Service.
         */
        fun destinationPrefixListId(destinationPrefixListId: String): FluentBuilder
        /**
         * The ID of the egress-only internet gateway.
         */
        fun egressOnlyInternetGatewayId(egressOnlyInternetGatewayId: String): FluentBuilder
        /**
         * The ID of a gateway attached to your VPC.
         */
        fun gatewayId(gatewayId: String): FluentBuilder
        /**
         * The ID of a NAT instance in your VPC.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The ID of Amazon Web Services account that owns the instance.
         */
        fun instanceOwnerId(instanceOwnerId: String): FluentBuilder
        /**
         * The ID of the local gateway.
         */
        fun localGatewayId(localGatewayId: String): FluentBuilder
        /**
         * The ID of a NAT gateway.
         */
        fun natGatewayId(natGatewayId: String): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * Describes how the route was created.
         * CreateRouteTable - The route was automatically created when the route table was created.
         * CreateRoute - The route was manually added to the route table.
         * EnableVgwRoutePropagation - The route was propagated by route propagation.
         */
        fun origin(origin: RouteOrigin): FluentBuilder
        /**
         * The state of the route. The blackhole state indicates that the
         * route's target isn't available (for example, the specified gateway isn't attached to the
         * VPC, or the specified NAT instance has been terminated).
         */
        fun state(state: RouteState): FluentBuilder
        /**
         * The ID of a transit gateway.
         */
        fun transitGatewayId(transitGatewayId: String): FluentBuilder
        /**
         * The ID of a VPC peering connection.
         */
        fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the carrier gateway.
         */
        var carrierGatewayId: String?
        /**
         * The IPv4 CIDR block used for the destination match.
         */
        var destinationCidrBlock: String?
        /**
         * The IPv6 CIDR block used for the destination match.
         */
        var destinationIpv6CidrBlock: String?
        /**
         * The prefix of the Amazon Web Service.
         */
        var destinationPrefixListId: String?
        /**
         * The ID of the egress-only internet gateway.
         */
        var egressOnlyInternetGatewayId: String?
        /**
         * The ID of a gateway attached to your VPC.
         */
        var gatewayId: String?
        /**
         * The ID of a NAT instance in your VPC.
         */
        var instanceId: String?
        /**
         * The ID of Amazon Web Services account that owns the instance.
         */
        var instanceOwnerId: String?
        /**
         * The ID of the local gateway.
         */
        var localGatewayId: String?
        /**
         * The ID of a NAT gateway.
         */
        var natGatewayId: String?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?
        /**
         * Describes how the route was created.
         * CreateRouteTable - The route was automatically created when the route table was created.
         * CreateRoute - The route was manually added to the route table.
         * EnableVgwRoutePropagation - The route was propagated by route propagation.
         */
        var origin: RouteOrigin?
        /**
         * The state of the route. The blackhole state indicates that the
         * route's target isn't available (for example, the specified gateway isn't attached to the
         * VPC, or the specified NAT instance has been terminated).
         */
        var state: RouteState?
        /**
         * The ID of a transit gateway.
         */
        var transitGatewayId: String?
        /**
         * The ID of a VPC peering connection.
         */
        var vpcPeeringConnectionId: String?

        fun build(): Route
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var carrierGatewayId: String? = null
        override var destinationCidrBlock: String? = null
        override var destinationIpv6CidrBlock: String? = null
        override var destinationPrefixListId: String? = null
        override var egressOnlyInternetGatewayId: String? = null
        override var gatewayId: String? = null
        override var instanceId: String? = null
        override var instanceOwnerId: String? = null
        override var localGatewayId: String? = null
        override var natGatewayId: String? = null
        override var networkInterfaceId: String? = null
        override var origin: RouteOrigin? = null
        override var state: RouteState? = null
        override var transitGatewayId: String? = null
        override var vpcPeeringConnectionId: String? = null

        constructor(x: Route) : this() {
            this.carrierGatewayId = x.carrierGatewayId
            this.destinationCidrBlock = x.destinationCidrBlock
            this.destinationIpv6CidrBlock = x.destinationIpv6CidrBlock
            this.destinationPrefixListId = x.destinationPrefixListId
            this.egressOnlyInternetGatewayId = x.egressOnlyInternetGatewayId
            this.gatewayId = x.gatewayId
            this.instanceId = x.instanceId
            this.instanceOwnerId = x.instanceOwnerId
            this.localGatewayId = x.localGatewayId
            this.natGatewayId = x.natGatewayId
            this.networkInterfaceId = x.networkInterfaceId
            this.origin = x.origin
            this.state = x.state
            this.transitGatewayId = x.transitGatewayId
            this.vpcPeeringConnectionId = x.vpcPeeringConnectionId
        }

        override fun build(): Route = Route(this)
        override fun carrierGatewayId(carrierGatewayId: String): FluentBuilder = apply { this.carrierGatewayId = carrierGatewayId }
        override fun destinationCidrBlock(destinationCidrBlock: String): FluentBuilder = apply { this.destinationCidrBlock = destinationCidrBlock }
        override fun destinationIpv6CidrBlock(destinationIpv6CidrBlock: String): FluentBuilder = apply { this.destinationIpv6CidrBlock = destinationIpv6CidrBlock }
        override fun destinationPrefixListId(destinationPrefixListId: String): FluentBuilder = apply { this.destinationPrefixListId = destinationPrefixListId }
        override fun egressOnlyInternetGatewayId(egressOnlyInternetGatewayId: String): FluentBuilder = apply { this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId }
        override fun gatewayId(gatewayId: String): FluentBuilder = apply { this.gatewayId = gatewayId }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun instanceOwnerId(instanceOwnerId: String): FluentBuilder = apply { this.instanceOwnerId = instanceOwnerId }
        override fun localGatewayId(localGatewayId: String): FluentBuilder = apply { this.localGatewayId = localGatewayId }
        override fun natGatewayId(natGatewayId: String): FluentBuilder = apply { this.natGatewayId = natGatewayId }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun origin(origin: RouteOrigin): FluentBuilder = apply { this.origin = origin }
        override fun state(state: RouteState): FluentBuilder = apply { this.state = state }
        override fun transitGatewayId(transitGatewayId: String): FluentBuilder = apply { this.transitGatewayId = transitGatewayId }
        override fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder = apply { this.vpcPeeringConnectionId = vpcPeeringConnectionId }
    }
}
