// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a route table.
 */
class RouteTable private constructor(builder: BuilderImpl) {
    /**
     * The associations between the route table and one or more subnets or a gateway.
     */
    val associations: List<RouteTableAssociation>? = builder.associations
    /**
     * The ID of the Amazon Web Services account that owns the route table.
     */
    val ownerId: String? = builder.ownerId
    /**
     * Any virtual private gateway (VGW) propagating routes.
     */
    val propagatingVgws: List<PropagatingVgw>? = builder.propagatingVgws
    /**
     * The ID of the route table.
     */
    val routeTableId: String? = builder.routeTableId
    /**
     * The routes in the route table.
     */
    val routes: List<Route>? = builder.routes
    /**
     * Any tags assigned to the route table.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RouteTable = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RouteTable(")
        append("associations=$associations,")
        append("ownerId=$ownerId,")
        append("propagatingVgws=$propagatingVgws,")
        append("routeTableId=$routeTableId,")
        append("routes=$routes,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associations?.hashCode() ?: 0
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (propagatingVgws?.hashCode() ?: 0)
        result = 31 * result + (routeTableId?.hashCode() ?: 0)
        result = 31 * result + (routes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RouteTable

        if (associations != other.associations) return false
        if (ownerId != other.ownerId) return false
        if (propagatingVgws != other.propagatingVgws) return false
        if (routeTableId != other.routeTableId) return false
        if (routes != other.routes) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RouteTable = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RouteTable
        /**
         * The associations between the route table and one or more subnets or a gateway.
         */
        fun associations(associations: List<RouteTableAssociation>): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the route table.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * Any virtual private gateway (VGW) propagating routes.
         */
        fun propagatingVgws(propagatingVgws: List<PropagatingVgw>): FluentBuilder
        /**
         * The ID of the route table.
         */
        fun routeTableId(routeTableId: String): FluentBuilder
        /**
         * The routes in the route table.
         */
        fun routes(routes: List<Route>): FluentBuilder
        /**
         * Any tags assigned to the route table.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The associations between the route table and one or more subnets or a gateway.
         */
        var associations: List<RouteTableAssociation>?
        /**
         * The ID of the Amazon Web Services account that owns the route table.
         */
        var ownerId: String?
        /**
         * Any virtual private gateway (VGW) propagating routes.
         */
        var propagatingVgws: List<PropagatingVgw>?
        /**
         * The ID of the route table.
         */
        var routeTableId: String?
        /**
         * The routes in the route table.
         */
        var routes: List<Route>?
        /**
         * Any tags assigned to the route table.
         */
        var tags: List<Tag>?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?

        fun build(): RouteTable
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associations: List<RouteTableAssociation>? = null
        override var ownerId: String? = null
        override var propagatingVgws: List<PropagatingVgw>? = null
        override var routeTableId: String? = null
        override var routes: List<Route>? = null
        override var tags: List<Tag>? = null
        override var vpcId: String? = null

        constructor(x: RouteTable) : this() {
            this.associations = x.associations
            this.ownerId = x.ownerId
            this.propagatingVgws = x.propagatingVgws
            this.routeTableId = x.routeTableId
            this.routes = x.routes
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        override fun build(): RouteTable = RouteTable(this)
        override fun associations(associations: List<RouteTableAssociation>): FluentBuilder = apply { this.associations = associations }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun propagatingVgws(propagatingVgws: List<PropagatingVgw>): FluentBuilder = apply { this.propagatingVgws = propagatingVgws }
        override fun routeTableId(routeTableId: String): FluentBuilder = apply { this.routeTableId = routeTableId }
        override fun routes(routes: List<Route>): FluentBuilder = apply { this.routes = routes }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
