// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an association between a route table and a subnet or gateway.
 */
class RouteTableAssociation private constructor(builder: BuilderImpl) {
    /**
     * The state of the association.
     */
    val associationState: RouteTableAssociationState? = builder.associationState
    /**
     * The ID of the internet gateway or virtual private gateway.
     */
    val gatewayId: String? = builder.gatewayId
    /**
     * Indicates whether this is the main route table.
     */
    val main: Boolean? = builder.main
    /**
     * The ID of the association.
     */
    val routeTableAssociationId: String? = builder.routeTableAssociationId
    /**
     * The ID of the route table.
     */
    val routeTableId: String? = builder.routeTableId
    /**
     * The ID of the subnet. A subnet ID is not returned for an implicit association.
     */
    val subnetId: String? = builder.subnetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RouteTableAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RouteTableAssociation(")
        append("associationState=$associationState,")
        append("gatewayId=$gatewayId,")
        append("main=$main,")
        append("routeTableAssociationId=$routeTableAssociationId,")
        append("routeTableId=$routeTableId,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationState?.hashCode() ?: 0
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (main?.hashCode() ?: 0)
        result = 31 * result + (routeTableAssociationId?.hashCode() ?: 0)
        result = 31 * result + (routeTableId?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RouteTableAssociation

        if (associationState != other.associationState) return false
        if (gatewayId != other.gatewayId) return false
        if (main != other.main) return false
        if (routeTableAssociationId != other.routeTableAssociationId) return false
        if (routeTableId != other.routeTableId) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RouteTableAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RouteTableAssociation
        /**
         * The state of the association.
         */
        fun associationState(associationState: RouteTableAssociationState): FluentBuilder
        /**
         * The ID of the internet gateway or virtual private gateway.
         */
        fun gatewayId(gatewayId: String): FluentBuilder
        /**
         * Indicates whether this is the main route table.
         */
        fun main(main: Boolean): FluentBuilder
        /**
         * The ID of the association.
         */
        fun routeTableAssociationId(routeTableAssociationId: String): FluentBuilder
        /**
         * The ID of the route table.
         */
        fun routeTableId(routeTableId: String): FluentBuilder
        /**
         * The ID of the subnet. A subnet ID is not returned for an implicit association.
         */
        fun subnetId(subnetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The state of the association.
         */
        var associationState: RouteTableAssociationState?
        /**
         * The ID of the internet gateway or virtual private gateway.
         */
        var gatewayId: String?
        /**
         * Indicates whether this is the main route table.
         */
        var main: Boolean?
        /**
         * The ID of the association.
         */
        var routeTableAssociationId: String?
        /**
         * The ID of the route table.
         */
        var routeTableId: String?
        /**
         * The ID of the subnet. A subnet ID is not returned for an implicit association.
         */
        var subnetId: String?

        fun build(): RouteTableAssociation
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.RouteTableAssociationState] inside the given [block]
         */
        fun associationState(block: RouteTableAssociationState.DslBuilder.() -> kotlin.Unit) {
            this.associationState = RouteTableAssociationState.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associationState: RouteTableAssociationState? = null
        override var gatewayId: String? = null
        override var main: Boolean? = null
        override var routeTableAssociationId: String? = null
        override var routeTableId: String? = null
        override var subnetId: String? = null

        constructor(x: RouteTableAssociation) : this() {
            this.associationState = x.associationState
            this.gatewayId = x.gatewayId
            this.main = x.main
            this.routeTableAssociationId = x.routeTableAssociationId
            this.routeTableId = x.routeTableId
            this.subnetId = x.subnetId
        }

        override fun build(): RouteTableAssociation = RouteTableAssociation(this)
        override fun associationState(associationState: RouteTableAssociationState): FluentBuilder = apply { this.associationState = associationState }
        override fun gatewayId(gatewayId: String): FluentBuilder = apply { this.gatewayId = gatewayId }
        override fun main(main: Boolean): FluentBuilder = apply { this.main = main }
        override fun routeTableAssociationId(routeTableAssociationId: String): FluentBuilder = apply { this.routeTableAssociationId = routeTableAssociationId }
        override fun routeTableId(routeTableId: String): FluentBuilder = apply { this.routeTableId = routeTableId }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
    }
}
