// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for RunScheduledInstances.
 */
class RunScheduledInstancesRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that ensures the idempotency of the request.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The number of instances.
     * Default: 1
     */
    val instanceCount: Int? = builder.instanceCount
    /**
     * The launch specification. You must match the instance type, Availability Zone,
     * network, and platform of the schedule that you purchased.
     */
    val launchSpecification: ScheduledInstancesLaunchSpecification? = builder.launchSpecification
    /**
     * The Scheduled Instance ID.
     */
    val scheduledInstanceId: String? = builder.scheduledInstanceId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RunScheduledInstancesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RunScheduledInstancesRequest(")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("instanceCount=$instanceCount,")
        append("launchSpecification=$launchSpecification,")
        append("scheduledInstanceId=$scheduledInstanceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (launchSpecification?.hashCode() ?: 0)
        result = 31 * result + (scheduledInstanceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RunScheduledInstancesRequest

        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (instanceCount != other.instanceCount) return false
        if (launchSpecification != other.launchSpecification) return false
        if (scheduledInstanceId != other.scheduledInstanceId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RunScheduledInstancesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RunScheduledInstancesRequest
        /**
         * Unique, case-sensitive identifier that ensures the idempotency of the request.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The number of instances.
         * Default: 1
         */
        fun instanceCount(instanceCount: Int): FluentBuilder
        /**
         * The launch specification. You must match the instance type, Availability Zone,
         * network, and platform of the schedule that you purchased.
         */
        fun launchSpecification(launchSpecification: ScheduledInstancesLaunchSpecification): FluentBuilder
        /**
         * The Scheduled Instance ID.
         */
        fun scheduledInstanceId(scheduledInstanceId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that ensures the idempotency of the request.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The number of instances.
         * Default: 1
         */
        var instanceCount: Int?
        /**
         * The launch specification. You must match the instance type, Availability Zone,
         * network, and platform of the schedule that you purchased.
         */
        var launchSpecification: ScheduledInstancesLaunchSpecification?
        /**
         * The Scheduled Instance ID.
         */
        var scheduledInstanceId: String?

        fun build(): RunScheduledInstancesRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstancesLaunchSpecification] inside the given [block]
         */
        fun launchSpecification(block: ScheduledInstancesLaunchSpecification.DslBuilder.() -> kotlin.Unit) {
            this.launchSpecification = ScheduledInstancesLaunchSpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var dryRun: Boolean? = null
        override var instanceCount: Int? = null
        override var launchSpecification: ScheduledInstancesLaunchSpecification? = null
        override var scheduledInstanceId: String? = null

        constructor(x: RunScheduledInstancesRequest) : this() {
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.instanceCount = x.instanceCount
            this.launchSpecification = x.launchSpecification
            this.scheduledInstanceId = x.scheduledInstanceId
        }

        override fun build(): RunScheduledInstancesRequest = RunScheduledInstancesRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun instanceCount(instanceCount: Int): FluentBuilder = apply { this.instanceCount = instanceCount }
        override fun launchSpecification(launchSpecification: ScheduledInstancesLaunchSpecification): FluentBuilder = apply { this.launchSpecification = launchSpecification }
        override fun scheduledInstanceId(scheduledInstanceId: String): FluentBuilder = apply { this.scheduledInstanceId = scheduledInstanceId }
    }
}
