// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The tags to apply to the AMI object that will be stored in the Amazon S3 bucket. For more
 * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-tagging.html">Categorizing your storage using
 * tags in the Amazon Simple Storage Service User Guide.
 */
class S3ObjectTag private constructor(builder: BuilderImpl) {
    /**
     * The key of the tag.
     * Constraints: Tag keys are case-sensitive and can be up to 128 Unicode characters in
     * length. May not begin with aws:.
     */
    val key: String? = builder.key
    /**
     * The value of the tag.
     * Constraints: Tag values are case-sensitive and can be up to 256 Unicode characters in
     * length.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3ObjectTag = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3ObjectTag(")
        append("key=$key,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3ObjectTag

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3ObjectTag = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3ObjectTag
        /**
         * The key of the tag.
         * Constraints: Tag keys are case-sensitive and can be up to 128 Unicode characters in
         * length. May not begin with aws:.
         */
        fun key(key: String): FluentBuilder
        /**
         * The value of the tag.
         * Constraints: Tag values are case-sensitive and can be up to 256 Unicode characters in
         * length.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The key of the tag.
         * Constraints: Tag keys are case-sensitive and can be up to 128 Unicode characters in
         * length. May not begin with aws:.
         */
        var key: String?
        /**
         * The value of the tag.
         * Constraints: Tag values are case-sensitive and can be up to 256 Unicode characters in
         * length.
         */
        var value: String?

        fun build(): S3ObjectTag
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var key: String? = null
        override var value: String? = null

        constructor(x: S3ObjectTag) : this() {
            this.key = x.key
            this.value = x.value
        }

        override fun build(): S3ObjectTag = S3ObjectTag(this)
        override fun key(key: String): FluentBuilder = apply { this.key = key }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
