// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the storage parameters for Amazon S3 and Amazon S3 buckets for an instance store-backed AMI.
 */
class S3Storage private constructor(builder: BuilderImpl) {
    /**
     * The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review and follow the guidance
     * in <a href="https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices for Managing Amazon Web Services Access Keys.
     */
    val awsAccessKeyId: String? = builder.awsAccessKeyId
    /**
     * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
     */
    val bucket: String? = builder.bucket
    /**
     * The beginning of the file name of the AMI.
     */
    val prefix: String? = builder.prefix
    /**
     * An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.
     */
    val uploadPolicy: ByteArray? = builder.uploadPolicy
    /**
     * The signature of the JSON document.
     */
    val uploadPolicySignature: String? = builder.uploadPolicySignature

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3Storage = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3Storage(")
        append("awsAccessKeyId=$awsAccessKeyId,")
        append("bucket=$bucket,")
        append("prefix=$prefix,")
        append("uploadPolicy=$uploadPolicy,")
        append("uploadPolicySignature=$uploadPolicySignature)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccessKeyId?.hashCode() ?: 0
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (uploadPolicy?.contentHashCode() ?: 0)
        result = 31 * result + (uploadPolicySignature?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3Storage

        if (awsAccessKeyId != other.awsAccessKeyId) return false
        if (bucket != other.bucket) return false
        if (prefix != other.prefix) return false
        if (uploadPolicy != null) {
            if (other.uploadPolicy == null) return false
            if (!uploadPolicy.contentEquals(other.uploadPolicy)) return false
        } else if (other.uploadPolicy != null) return false
        if (uploadPolicySignature != other.uploadPolicySignature) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3Storage = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3Storage
        /**
         * The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review and follow the guidance
         * in <a href="https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices for Managing Amazon Web Services Access Keys.
         */
        fun awsAccessKeyId(awsAccessKeyId: String): FluentBuilder
        /**
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * The beginning of the file name of the AMI.
         */
        fun prefix(prefix: String): FluentBuilder
        /**
         * An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.
         */
        fun uploadPolicy(uploadPolicy: ByteArray): FluentBuilder
        /**
         * The signature of the JSON document.
         */
        fun uploadPolicySignature(uploadPolicySignature: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review and follow the guidance
         * in <a href="https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices for Managing Amazon Web Services Access Keys.
         */
        var awsAccessKeyId: String?
        /**
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
         */
        var bucket: String?
        /**
         * The beginning of the file name of the AMI.
         */
        var prefix: String?
        /**
         * An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.
         */
        var uploadPolicy: ByteArray?
        /**
         * The signature of the JSON document.
         */
        var uploadPolicySignature: String?

        fun build(): S3Storage
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var awsAccessKeyId: String? = null
        override var bucket: String? = null
        override var prefix: String? = null
        override var uploadPolicy: ByteArray? = null
        override var uploadPolicySignature: String? = null

        constructor(x: S3Storage) : this() {
            this.awsAccessKeyId = x.awsAccessKeyId
            this.bucket = x.bucket
            this.prefix = x.prefix
            this.uploadPolicy = x.uploadPolicy
            this.uploadPolicySignature = x.uploadPolicySignature
        }

        override fun build(): S3Storage = S3Storage(this)
        override fun awsAccessKeyId(awsAccessKeyId: String): FluentBuilder = apply { this.awsAccessKeyId = awsAccessKeyId }
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun prefix(prefix: String): FluentBuilder = apply { this.prefix = prefix }
        override fun uploadPolicy(uploadPolicy: ByteArray): FluentBuilder = apply { this.uploadPolicy = uploadPolicy }
        override fun uploadPolicySignature(uploadPolicySignature: String): FluentBuilder = apply { this.uploadPolicySignature = uploadPolicySignature }
    }
}
