// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Scheduled Instance.
 */
class ScheduledInstance private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The date when the Scheduled Instance was purchased.
     */
    val createDate: Instant? = builder.createDate
    /**
     * The hourly price for a single instance.
     */
    val hourlyPrice: String? = builder.hourlyPrice
    /**
     * The number of instances.
     */
    val instanceCount: Int? = builder.instanceCount
    /**
     * The instance type.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The network platform (EC2-Classic or EC2-VPC).
     */
    val networkPlatform: String? = builder.networkPlatform
    /**
     * The time for the next schedule to start.
     */
    val nextSlotStartTime: Instant? = builder.nextSlotStartTime
    /**
     * The platform (Linux/UNIX or Windows).
     */
    val platform: String? = builder.platform
    /**
     * The time that the previous schedule ended or will end.
     */
    val previousSlotEndTime: Instant? = builder.previousSlotEndTime
    /**
     * The schedule recurrence.
     */
    val recurrence: ScheduledInstanceRecurrence? = builder.recurrence
    /**
     * The Scheduled Instance ID.
     */
    val scheduledInstanceId: String? = builder.scheduledInstanceId
    /**
     * The number of hours in the schedule.
     */
    val slotDurationInHours: Int? = builder.slotDurationInHours
    /**
     * The end date for the Scheduled Instance.
     */
    val termEndDate: Instant? = builder.termEndDate
    /**
     * The start date for the Scheduled Instance.
     */
    val termStartDate: Instant? = builder.termStartDate
    /**
     * The total number of hours for a single instance for the entire term.
     */
    val totalScheduledInstanceHours: Int? = builder.totalScheduledInstanceHours

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScheduledInstance = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledInstance(")
        append("availabilityZone=$availabilityZone,")
        append("createDate=$createDate,")
        append("hourlyPrice=$hourlyPrice,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("networkPlatform=$networkPlatform,")
        append("nextSlotStartTime=$nextSlotStartTime,")
        append("platform=$platform,")
        append("previousSlotEndTime=$previousSlotEndTime,")
        append("recurrence=$recurrence,")
        append("scheduledInstanceId=$scheduledInstanceId,")
        append("slotDurationInHours=$slotDurationInHours,")
        append("termEndDate=$termEndDate,")
        append("termStartDate=$termStartDate,")
        append("totalScheduledInstanceHours=$totalScheduledInstanceHours)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (hourlyPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (networkPlatform?.hashCode() ?: 0)
        result = 31 * result + (nextSlotStartTime?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (previousSlotEndTime?.hashCode() ?: 0)
        result = 31 * result + (recurrence?.hashCode() ?: 0)
        result = 31 * result + (scheduledInstanceId?.hashCode() ?: 0)
        result = 31 * result + (slotDurationInHours ?: 0)
        result = 31 * result + (termEndDate?.hashCode() ?: 0)
        result = 31 * result + (termStartDate?.hashCode() ?: 0)
        result = 31 * result + (totalScheduledInstanceHours ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScheduledInstance

        if (availabilityZone != other.availabilityZone) return false
        if (createDate != other.createDate) return false
        if (hourlyPrice != other.hourlyPrice) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (networkPlatform != other.networkPlatform) return false
        if (nextSlotStartTime != other.nextSlotStartTime) return false
        if (platform != other.platform) return false
        if (previousSlotEndTime != other.previousSlotEndTime) return false
        if (recurrence != other.recurrence) return false
        if (scheduledInstanceId != other.scheduledInstanceId) return false
        if (slotDurationInHours != other.slotDurationInHours) return false
        if (termEndDate != other.termEndDate) return false
        if (termStartDate != other.termStartDate) return false
        if (totalScheduledInstanceHours != other.totalScheduledInstanceHours) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScheduledInstance = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScheduledInstance
        /**
         * The Availability Zone.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The date when the Scheduled Instance was purchased.
         */
        fun createDate(createDate: Instant): FluentBuilder
        /**
         * The hourly price for a single instance.
         */
        fun hourlyPrice(hourlyPrice: String): FluentBuilder
        /**
         * The number of instances.
         */
        fun instanceCount(instanceCount: Int): FluentBuilder
        /**
         * The instance type.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The network platform (EC2-Classic or EC2-VPC).
         */
        fun networkPlatform(networkPlatform: String): FluentBuilder
        /**
         * The time for the next schedule to start.
         */
        fun nextSlotStartTime(nextSlotStartTime: Instant): FluentBuilder
        /**
         * The platform (Linux/UNIX or Windows).
         */
        fun platform(platform: String): FluentBuilder
        /**
         * The time that the previous schedule ended or will end.
         */
        fun previousSlotEndTime(previousSlotEndTime: Instant): FluentBuilder
        /**
         * The schedule recurrence.
         */
        fun recurrence(recurrence: ScheduledInstanceRecurrence): FluentBuilder
        /**
         * The Scheduled Instance ID.
         */
        fun scheduledInstanceId(scheduledInstanceId: String): FluentBuilder
        /**
         * The number of hours in the schedule.
         */
        fun slotDurationInHours(slotDurationInHours: Int): FluentBuilder
        /**
         * The end date for the Scheduled Instance.
         */
        fun termEndDate(termEndDate: Instant): FluentBuilder
        /**
         * The start date for the Scheduled Instance.
         */
        fun termStartDate(termStartDate: Instant): FluentBuilder
        /**
         * The total number of hours for a single instance for the entire term.
         */
        fun totalScheduledInstanceHours(totalScheduledInstanceHours: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone.
         */
        var availabilityZone: String?
        /**
         * The date when the Scheduled Instance was purchased.
         */
        var createDate: Instant?
        /**
         * The hourly price for a single instance.
         */
        var hourlyPrice: String?
        /**
         * The number of instances.
         */
        var instanceCount: Int?
        /**
         * The instance type.
         */
        var instanceType: String?
        /**
         * The network platform (EC2-Classic or EC2-VPC).
         */
        var networkPlatform: String?
        /**
         * The time for the next schedule to start.
         */
        var nextSlotStartTime: Instant?
        /**
         * The platform (Linux/UNIX or Windows).
         */
        var platform: String?
        /**
         * The time that the previous schedule ended or will end.
         */
        var previousSlotEndTime: Instant?
        /**
         * The schedule recurrence.
         */
        var recurrence: ScheduledInstanceRecurrence?
        /**
         * The Scheduled Instance ID.
         */
        var scheduledInstanceId: String?
        /**
         * The number of hours in the schedule.
         */
        var slotDurationInHours: Int?
        /**
         * The end date for the Scheduled Instance.
         */
        var termEndDate: Instant?
        /**
         * The start date for the Scheduled Instance.
         */
        var termStartDate: Instant?
        /**
         * The total number of hours for a single instance for the entire term.
         */
        var totalScheduledInstanceHours: Int?

        fun build(): ScheduledInstance
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstanceRecurrence] inside the given [block]
         */
        fun recurrence(block: ScheduledInstanceRecurrence.DslBuilder.() -> kotlin.Unit) {
            this.recurrence = ScheduledInstanceRecurrence.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var createDate: Instant? = null
        override var hourlyPrice: String? = null
        override var instanceCount: Int? = null
        override var instanceType: String? = null
        override var networkPlatform: String? = null
        override var nextSlotStartTime: Instant? = null
        override var platform: String? = null
        override var previousSlotEndTime: Instant? = null
        override var recurrence: ScheduledInstanceRecurrence? = null
        override var scheduledInstanceId: String? = null
        override var slotDurationInHours: Int? = null
        override var termEndDate: Instant? = null
        override var termStartDate: Instant? = null
        override var totalScheduledInstanceHours: Int? = null

        constructor(x: ScheduledInstance) : this() {
            this.availabilityZone = x.availabilityZone
            this.createDate = x.createDate
            this.hourlyPrice = x.hourlyPrice
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.networkPlatform = x.networkPlatform
            this.nextSlotStartTime = x.nextSlotStartTime
            this.platform = x.platform
            this.previousSlotEndTime = x.previousSlotEndTime
            this.recurrence = x.recurrence
            this.scheduledInstanceId = x.scheduledInstanceId
            this.slotDurationInHours = x.slotDurationInHours
            this.termEndDate = x.termEndDate
            this.termStartDate = x.termStartDate
            this.totalScheduledInstanceHours = x.totalScheduledInstanceHours
        }

        override fun build(): ScheduledInstance = ScheduledInstance(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun createDate(createDate: Instant): FluentBuilder = apply { this.createDate = createDate }
        override fun hourlyPrice(hourlyPrice: String): FluentBuilder = apply { this.hourlyPrice = hourlyPrice }
        override fun instanceCount(instanceCount: Int): FluentBuilder = apply { this.instanceCount = instanceCount }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun networkPlatform(networkPlatform: String): FluentBuilder = apply { this.networkPlatform = networkPlatform }
        override fun nextSlotStartTime(nextSlotStartTime: Instant): FluentBuilder = apply { this.nextSlotStartTime = nextSlotStartTime }
        override fun platform(platform: String): FluentBuilder = apply { this.platform = platform }
        override fun previousSlotEndTime(previousSlotEndTime: Instant): FluentBuilder = apply { this.previousSlotEndTime = previousSlotEndTime }
        override fun recurrence(recurrence: ScheduledInstanceRecurrence): FluentBuilder = apply { this.recurrence = recurrence }
        override fun scheduledInstanceId(scheduledInstanceId: String): FluentBuilder = apply { this.scheduledInstanceId = scheduledInstanceId }
        override fun slotDurationInHours(slotDurationInHours: Int): FluentBuilder = apply { this.slotDurationInHours = slotDurationInHours }
        override fun termEndDate(termEndDate: Instant): FluentBuilder = apply { this.termEndDate = termEndDate }
        override fun termStartDate(termStartDate: Instant): FluentBuilder = apply { this.termStartDate = termStartDate }
        override fun totalScheduledInstanceHours(totalScheduledInstanceHours: Int): FluentBuilder = apply { this.totalScheduledInstanceHours = totalScheduledInstanceHours }
    }
}
