// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a schedule that is available for your Scheduled Instances.
 */
class ScheduledInstanceAvailability private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The number of available instances.
     */
    val availableInstanceCount: Int? = builder.availableInstanceCount
    /**
     * The time period for the first schedule to start.
     */
    val firstSlotStartTime: Instant? = builder.firstSlotStartTime
    /**
     * The hourly price for a single instance.
     */
    val hourlyPrice: String? = builder.hourlyPrice
    /**
     * The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The maximum term. The only possible value is 365 days.
     */
    val maxTermDurationInDays: Int? = builder.maxTermDurationInDays
    /**
     * The minimum term. The only possible value is 365 days.
     */
    val minTermDurationInDays: Int? = builder.minTermDurationInDays
    /**
     * The network platform (EC2-Classic or EC2-VPC).
     */
    val networkPlatform: String? = builder.networkPlatform
    /**
     * The platform (Linux/UNIX or Windows).
     */
    val platform: String? = builder.platform
    /**
     * The purchase token. This token expires in two hours.
     */
    val purchaseToken: String? = builder.purchaseToken
    /**
     * The schedule recurrence.
     */
    val recurrence: ScheduledInstanceRecurrence? = builder.recurrence
    /**
     * The number of hours in the schedule.
     */
    val slotDurationInHours: Int? = builder.slotDurationInHours
    /**
     * The total number of hours for a single instance for the entire term.
     */
    val totalScheduledInstanceHours: Int? = builder.totalScheduledInstanceHours

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScheduledInstanceAvailability = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledInstanceAvailability(")
        append("availabilityZone=$availabilityZone,")
        append("availableInstanceCount=$availableInstanceCount,")
        append("firstSlotStartTime=$firstSlotStartTime,")
        append("hourlyPrice=$hourlyPrice,")
        append("instanceType=$instanceType,")
        append("maxTermDurationInDays=$maxTermDurationInDays,")
        append("minTermDurationInDays=$minTermDurationInDays,")
        append("networkPlatform=$networkPlatform,")
        append("platform=$platform,")
        append("purchaseToken=$purchaseToken,")
        append("recurrence=$recurrence,")
        append("slotDurationInHours=$slotDurationInHours,")
        append("totalScheduledInstanceHours=$totalScheduledInstanceHours)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (availableInstanceCount ?: 0)
        result = 31 * result + (firstSlotStartTime?.hashCode() ?: 0)
        result = 31 * result + (hourlyPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (maxTermDurationInDays ?: 0)
        result = 31 * result + (minTermDurationInDays ?: 0)
        result = 31 * result + (networkPlatform?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (purchaseToken?.hashCode() ?: 0)
        result = 31 * result + (recurrence?.hashCode() ?: 0)
        result = 31 * result + (slotDurationInHours ?: 0)
        result = 31 * result + (totalScheduledInstanceHours ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScheduledInstanceAvailability

        if (availabilityZone != other.availabilityZone) return false
        if (availableInstanceCount != other.availableInstanceCount) return false
        if (firstSlotStartTime != other.firstSlotStartTime) return false
        if (hourlyPrice != other.hourlyPrice) return false
        if (instanceType != other.instanceType) return false
        if (maxTermDurationInDays != other.maxTermDurationInDays) return false
        if (minTermDurationInDays != other.minTermDurationInDays) return false
        if (networkPlatform != other.networkPlatform) return false
        if (platform != other.platform) return false
        if (purchaseToken != other.purchaseToken) return false
        if (recurrence != other.recurrence) return false
        if (slotDurationInHours != other.slotDurationInHours) return false
        if (totalScheduledInstanceHours != other.totalScheduledInstanceHours) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScheduledInstanceAvailability = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScheduledInstanceAvailability
        /**
         * The Availability Zone.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The number of available instances.
         */
        fun availableInstanceCount(availableInstanceCount: Int): FluentBuilder
        /**
         * The time period for the first schedule to start.
         */
        fun firstSlotStartTime(firstSlotStartTime: Instant): FluentBuilder
        /**
         * The hourly price for a single instance.
         */
        fun hourlyPrice(hourlyPrice: String): FluentBuilder
        /**
         * The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The maximum term. The only possible value is 365 days.
         */
        fun maxTermDurationInDays(maxTermDurationInDays: Int): FluentBuilder
        /**
         * The minimum term. The only possible value is 365 days.
         */
        fun minTermDurationInDays(minTermDurationInDays: Int): FluentBuilder
        /**
         * The network platform (EC2-Classic or EC2-VPC).
         */
        fun networkPlatform(networkPlatform: String): FluentBuilder
        /**
         * The platform (Linux/UNIX or Windows).
         */
        fun platform(platform: String): FluentBuilder
        /**
         * The purchase token. This token expires in two hours.
         */
        fun purchaseToken(purchaseToken: String): FluentBuilder
        /**
         * The schedule recurrence.
         */
        fun recurrence(recurrence: ScheduledInstanceRecurrence): FluentBuilder
        /**
         * The number of hours in the schedule.
         */
        fun slotDurationInHours(slotDurationInHours: Int): FluentBuilder
        /**
         * The total number of hours for a single instance for the entire term.
         */
        fun totalScheduledInstanceHours(totalScheduledInstanceHours: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone.
         */
        var availabilityZone: String?
        /**
         * The number of available instances.
         */
        var availableInstanceCount: Int?
        /**
         * The time period for the first schedule to start.
         */
        var firstSlotStartTime: Instant?
        /**
         * The hourly price for a single instance.
         */
        var hourlyPrice: String?
        /**
         * The instance type. You can specify one of the C3, C4, M4, or R3 instance types.
         */
        var instanceType: String?
        /**
         * The maximum term. The only possible value is 365 days.
         */
        var maxTermDurationInDays: Int?
        /**
         * The minimum term. The only possible value is 365 days.
         */
        var minTermDurationInDays: Int?
        /**
         * The network platform (EC2-Classic or EC2-VPC).
         */
        var networkPlatform: String?
        /**
         * The platform (Linux/UNIX or Windows).
         */
        var platform: String?
        /**
         * The purchase token. This token expires in two hours.
         */
        var purchaseToken: String?
        /**
         * The schedule recurrence.
         */
        var recurrence: ScheduledInstanceRecurrence?
        /**
         * The number of hours in the schedule.
         */
        var slotDurationInHours: Int?
        /**
         * The total number of hours for a single instance for the entire term.
         */
        var totalScheduledInstanceHours: Int?

        fun build(): ScheduledInstanceAvailability
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstanceRecurrence] inside the given [block]
         */
        fun recurrence(block: ScheduledInstanceRecurrence.DslBuilder.() -> kotlin.Unit) {
            this.recurrence = ScheduledInstanceRecurrence.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var availableInstanceCount: Int? = null
        override var firstSlotStartTime: Instant? = null
        override var hourlyPrice: String? = null
        override var instanceType: String? = null
        override var maxTermDurationInDays: Int? = null
        override var minTermDurationInDays: Int? = null
        override var networkPlatform: String? = null
        override var platform: String? = null
        override var purchaseToken: String? = null
        override var recurrence: ScheduledInstanceRecurrence? = null
        override var slotDurationInHours: Int? = null
        override var totalScheduledInstanceHours: Int? = null

        constructor(x: ScheduledInstanceAvailability) : this() {
            this.availabilityZone = x.availabilityZone
            this.availableInstanceCount = x.availableInstanceCount
            this.firstSlotStartTime = x.firstSlotStartTime
            this.hourlyPrice = x.hourlyPrice
            this.instanceType = x.instanceType
            this.maxTermDurationInDays = x.maxTermDurationInDays
            this.minTermDurationInDays = x.minTermDurationInDays
            this.networkPlatform = x.networkPlatform
            this.platform = x.platform
            this.purchaseToken = x.purchaseToken
            this.recurrence = x.recurrence
            this.slotDurationInHours = x.slotDurationInHours
            this.totalScheduledInstanceHours = x.totalScheduledInstanceHours
        }

        override fun build(): ScheduledInstanceAvailability = ScheduledInstanceAvailability(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun availableInstanceCount(availableInstanceCount: Int): FluentBuilder = apply { this.availableInstanceCount = availableInstanceCount }
        override fun firstSlotStartTime(firstSlotStartTime: Instant): FluentBuilder = apply { this.firstSlotStartTime = firstSlotStartTime }
        override fun hourlyPrice(hourlyPrice: String): FluentBuilder = apply { this.hourlyPrice = hourlyPrice }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun maxTermDurationInDays(maxTermDurationInDays: Int): FluentBuilder = apply { this.maxTermDurationInDays = maxTermDurationInDays }
        override fun minTermDurationInDays(minTermDurationInDays: Int): FluentBuilder = apply { this.minTermDurationInDays = minTermDurationInDays }
        override fun networkPlatform(networkPlatform: String): FluentBuilder = apply { this.networkPlatform = networkPlatform }
        override fun platform(platform: String): FluentBuilder = apply { this.platform = platform }
        override fun purchaseToken(purchaseToken: String): FluentBuilder = apply { this.purchaseToken = purchaseToken }
        override fun recurrence(recurrence: ScheduledInstanceRecurrence): FluentBuilder = apply { this.recurrence = recurrence }
        override fun slotDurationInHours(slotDurationInHours: Int): FluentBuilder = apply { this.slotDurationInHours = slotDurationInHours }
        override fun totalScheduledInstanceHours(totalScheduledInstanceHours: Int): FluentBuilder = apply { this.totalScheduledInstanceHours = totalScheduledInstanceHours }
    }
}
