// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the recurring schedule for a Scheduled Instance.
 */
class ScheduledInstanceRecurrence private constructor(builder: BuilderImpl) {
    /**
     * The frequency (Daily, Weekly, or Monthly).
     */
    val frequency: String? = builder.frequency
    /**
     * The interval quantity. The interval unit depends on the value of frequency. For example, every 2
     * weeks or every 2 months.
     */
    val interval: Int? = builder.interval
    /**
     * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday).
     */
    val occurrenceDaySet: List<Int>? = builder.occurrenceDaySet
    /**
     * Indicates whether the occurrence is relative to the end of the specified week or month.
     */
    val occurrenceRelativeToEnd: Boolean? = builder.occurrenceRelativeToEnd
    /**
     * The unit for occurrenceDaySet (DayOfWeek or DayOfMonth).
     */
    val occurrenceUnit: String? = builder.occurrenceUnit

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScheduledInstanceRecurrence = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledInstanceRecurrence(")
        append("frequency=$frequency,")
        append("interval=$interval,")
        append("occurrenceDaySet=$occurrenceDaySet,")
        append("occurrenceRelativeToEnd=$occurrenceRelativeToEnd,")
        append("occurrenceUnit=$occurrenceUnit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = frequency?.hashCode() ?: 0
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (occurrenceDaySet?.hashCode() ?: 0)
        result = 31 * result + (occurrenceRelativeToEnd?.hashCode() ?: 0)
        result = 31 * result + (occurrenceUnit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScheduledInstanceRecurrence

        if (frequency != other.frequency) return false
        if (interval != other.interval) return false
        if (occurrenceDaySet != other.occurrenceDaySet) return false
        if (occurrenceRelativeToEnd != other.occurrenceRelativeToEnd) return false
        if (occurrenceUnit != other.occurrenceUnit) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScheduledInstanceRecurrence = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScheduledInstanceRecurrence
        /**
         * The frequency (Daily, Weekly, or Monthly).
         */
        fun frequency(frequency: String): FluentBuilder
        /**
         * The interval quantity. The interval unit depends on the value of frequency. For example, every 2
         * weeks or every 2 months.
         */
        fun interval(interval: Int): FluentBuilder
        /**
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday).
         */
        fun occurrenceDaySet(occurrenceDaySet: List<Int>): FluentBuilder
        /**
         * Indicates whether the occurrence is relative to the end of the specified week or month.
         */
        fun occurrenceRelativeToEnd(occurrenceRelativeToEnd: Boolean): FluentBuilder
        /**
         * The unit for occurrenceDaySet (DayOfWeek or DayOfMonth).
         */
        fun occurrenceUnit(occurrenceUnit: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The frequency (Daily, Weekly, or Monthly).
         */
        var frequency: String?
        /**
         * The interval quantity. The interval unit depends on the value of frequency. For example, every 2
         * weeks or every 2 months.
         */
        var interval: Int?
        /**
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday).
         */
        var occurrenceDaySet: List<Int>?
        /**
         * Indicates whether the occurrence is relative to the end of the specified week or month.
         */
        var occurrenceRelativeToEnd: Boolean?
        /**
         * The unit for occurrenceDaySet (DayOfWeek or DayOfMonth).
         */
        var occurrenceUnit: String?

        fun build(): ScheduledInstanceRecurrence
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var frequency: String? = null
        override var interval: Int? = null
        override var occurrenceDaySet: List<Int>? = null
        override var occurrenceRelativeToEnd: Boolean? = null
        override var occurrenceUnit: String? = null

        constructor(x: ScheduledInstanceRecurrence) : this() {
            this.frequency = x.frequency
            this.interval = x.interval
            this.occurrenceDaySet = x.occurrenceDaySet
            this.occurrenceRelativeToEnd = x.occurrenceRelativeToEnd
            this.occurrenceUnit = x.occurrenceUnit
        }

        override fun build(): ScheduledInstanceRecurrence = ScheduledInstanceRecurrence(this)
        override fun frequency(frequency: String): FluentBuilder = apply { this.frequency = frequency }
        override fun interval(interval: Int): FluentBuilder = apply { this.interval = interval }
        override fun occurrenceDaySet(occurrenceDaySet: List<Int>): FluentBuilder = apply { this.occurrenceDaySet = occurrenceDaySet }
        override fun occurrenceRelativeToEnd(occurrenceRelativeToEnd: Boolean): FluentBuilder = apply { this.occurrenceRelativeToEnd = occurrenceRelativeToEnd }
        override fun occurrenceUnit(occurrenceUnit: String): FluentBuilder = apply { this.occurrenceUnit = occurrenceUnit }
    }
}
