// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the recurring schedule for a Scheduled Instance.
 */
class ScheduledInstanceRecurrenceRequest private constructor(builder: BuilderImpl) {
    /**
     * The frequency (Daily, Weekly, or Monthly).
     */
    val frequency: String? = builder.frequency
    /**
     * The interval quantity. The interval unit depends on the value of Frequency. For example, every 2
     * weeks or every 2 months.
     */
    val interval: Int? = builder.interval
    /**
     * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily schedule. If the occurrence is relative to the end of the month, you can specify only a single day.
     */
    val occurrenceDays: List<Int>? = builder.occurrenceDays
    /**
     * Indicates whether the occurrence is relative to the end of the specified week or month. You can't specify this value with a daily schedule.
     */
    val occurrenceRelativeToEnd: Boolean? = builder.occurrenceRelativeToEnd
    /**
     * The unit for OccurrenceDays (DayOfWeek or DayOfMonth).
     * This value is required for a monthly schedule.
     * You can't specify DayOfWeek with a weekly schedule.
     * You can't specify this value with a daily schedule.
     */
    val occurrenceUnit: String? = builder.occurrenceUnit

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScheduledInstanceRecurrenceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledInstanceRecurrenceRequest(")
        append("frequency=$frequency,")
        append("interval=$interval,")
        append("occurrenceDays=$occurrenceDays,")
        append("occurrenceRelativeToEnd=$occurrenceRelativeToEnd,")
        append("occurrenceUnit=$occurrenceUnit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = frequency?.hashCode() ?: 0
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (occurrenceDays?.hashCode() ?: 0)
        result = 31 * result + (occurrenceRelativeToEnd?.hashCode() ?: 0)
        result = 31 * result + (occurrenceUnit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScheduledInstanceRecurrenceRequest

        if (frequency != other.frequency) return false
        if (interval != other.interval) return false
        if (occurrenceDays != other.occurrenceDays) return false
        if (occurrenceRelativeToEnd != other.occurrenceRelativeToEnd) return false
        if (occurrenceUnit != other.occurrenceUnit) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScheduledInstanceRecurrenceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScheduledInstanceRecurrenceRequest
        /**
         * The frequency (Daily, Weekly, or Monthly).
         */
        fun frequency(frequency: String): FluentBuilder
        /**
         * The interval quantity. The interval unit depends on the value of Frequency. For example, every 2
         * weeks or every 2 months.
         */
        fun interval(interval: Int): FluentBuilder
        /**
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily schedule. If the occurrence is relative to the end of the month, you can specify only a single day.
         */
        fun occurrenceDays(occurrenceDays: List<Int>): FluentBuilder
        /**
         * Indicates whether the occurrence is relative to the end of the specified week or month. You can't specify this value with a daily schedule.
         */
        fun occurrenceRelativeToEnd(occurrenceRelativeToEnd: Boolean): FluentBuilder
        /**
         * The unit for OccurrenceDays (DayOfWeek or DayOfMonth).
         * This value is required for a monthly schedule.
         * You can't specify DayOfWeek with a weekly schedule.
         * You can't specify this value with a daily schedule.
         */
        fun occurrenceUnit(occurrenceUnit: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The frequency (Daily, Weekly, or Monthly).
         */
        var frequency: String?
        /**
         * The interval quantity. The interval unit depends on the value of Frequency. For example, every 2
         * weeks or every 2 months.
         */
        var interval: Int?
        /**
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily schedule. If the occurrence is relative to the end of the month, you can specify only a single day.
         */
        var occurrenceDays: List<Int>?
        /**
         * Indicates whether the occurrence is relative to the end of the specified week or month. You can't specify this value with a daily schedule.
         */
        var occurrenceRelativeToEnd: Boolean?
        /**
         * The unit for OccurrenceDays (DayOfWeek or DayOfMonth).
         * This value is required for a monthly schedule.
         * You can't specify DayOfWeek with a weekly schedule.
         * You can't specify this value with a daily schedule.
         */
        var occurrenceUnit: String?

        fun build(): ScheduledInstanceRecurrenceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var frequency: String? = null
        override var interval: Int? = null
        override var occurrenceDays: List<Int>? = null
        override var occurrenceRelativeToEnd: Boolean? = null
        override var occurrenceUnit: String? = null

        constructor(x: ScheduledInstanceRecurrenceRequest) : this() {
            this.frequency = x.frequency
            this.interval = x.interval
            this.occurrenceDays = x.occurrenceDays
            this.occurrenceRelativeToEnd = x.occurrenceRelativeToEnd
            this.occurrenceUnit = x.occurrenceUnit
        }

        override fun build(): ScheduledInstanceRecurrenceRequest = ScheduledInstanceRecurrenceRequest(this)
        override fun frequency(frequency: String): FluentBuilder = apply { this.frequency = frequency }
        override fun interval(interval: Int): FluentBuilder = apply { this.interval = interval }
        override fun occurrenceDays(occurrenceDays: List<Int>): FluentBuilder = apply { this.occurrenceDays = occurrenceDays }
        override fun occurrenceRelativeToEnd(occurrenceRelativeToEnd: Boolean): FluentBuilder = apply { this.occurrenceRelativeToEnd = occurrenceRelativeToEnd }
        override fun occurrenceUnit(occurrenceUnit: String): FluentBuilder = apply { this.occurrenceUnit = occurrenceUnit }
    }
}
