// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the launch specification for a Scheduled Instance.
 * If you are launching the Scheduled Instance in EC2-VPC, you must specify the ID of the subnet.
 * You can specify the subnet using either SubnetId or NetworkInterface.
 */
class ScheduledInstancesLaunchSpecification private constructor(builder: BuilderImpl) {
    /**
     * The block device mapping entries.
     */
    val blockDeviceMappings: List<ScheduledInstancesBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * Default: false
     */
    val ebsOptimized: Boolean? = builder.ebsOptimized
    /**
     * The IAM instance profile.
     */
    val iamInstanceProfile: ScheduledInstancesIamInstanceProfile? = builder.iamInstanceProfile
    /**
     * The ID of the Amazon Machine Image (AMI).
     */
    val imageId: String? = builder.imageId
    /**
     * The instance type.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The ID of the kernel.
     */
    val kernelId: String? = builder.kernelId
    /**
     * The name of the key pair.
     */
    val keyName: String? = builder.keyName
    /**
     * Enable or disable monitoring for the instances.
     */
    val monitoring: ScheduledInstancesMonitoring? = builder.monitoring
    /**
     * The network interfaces.
     */
    val networkInterfaces: List<ScheduledInstancesNetworkInterface>? = builder.networkInterfaces
    /**
     * The placement information.
     */
    val placement: ScheduledInstancesPlacement? = builder.placement
    /**
     * The ID of the RAM disk.
     */
    val ramdiskId: String? = builder.ramdiskId
    /**
     * The IDs of the security groups.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The ID of the subnet in which to launch the instances.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The base64-encoded MIME user data.
     */
    val userData: String? = builder.userData

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScheduledInstancesLaunchSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledInstancesLaunchSpecification(")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("ebsOptimized=$ebsOptimized,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("placement=$placement,")
        append("ramdiskId=$ramdiskId,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetId=$subnetId,")
        append("userData=$userData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDeviceMappings?.hashCode() ?: 0
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScheduledInstancesLaunchSpecification

        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (placement != other.placement) return false
        if (ramdiskId != other.ramdiskId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetId != other.subnetId) return false
        if (userData != other.userData) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScheduledInstancesLaunchSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScheduledInstancesLaunchSpecification
        /**
         * The block device mapping entries.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<ScheduledInstancesBlockDeviceMapping>): FluentBuilder
        /**
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * Default: false
         */
        fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder
        /**
         * The IAM instance profile.
         */
        fun iamInstanceProfile(iamInstanceProfile: ScheduledInstancesIamInstanceProfile): FluentBuilder
        /**
         * The ID of the Amazon Machine Image (AMI).
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * The instance type.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The ID of the kernel.
         */
        fun kernelId(kernelId: String): FluentBuilder
        /**
         * The name of the key pair.
         */
        fun keyName(keyName: String): FluentBuilder
        /**
         * Enable or disable monitoring for the instances.
         */
        fun monitoring(monitoring: ScheduledInstancesMonitoring): FluentBuilder
        /**
         * The network interfaces.
         */
        fun networkInterfaces(networkInterfaces: List<ScheduledInstancesNetworkInterface>): FluentBuilder
        /**
         * The placement information.
         */
        fun placement(placement: ScheduledInstancesPlacement): FluentBuilder
        /**
         * The ID of the RAM disk.
         */
        fun ramdiskId(ramdiskId: String): FluentBuilder
        /**
         * The IDs of the security groups.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * The ID of the subnet in which to launch the instances.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The base64-encoded MIME user data.
         */
        fun userData(userData: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The block device mapping entries.
         */
        var blockDeviceMappings: List<ScheduledInstancesBlockDeviceMapping>?
        /**
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * Default: false
         */
        var ebsOptimized: Boolean?
        /**
         * The IAM instance profile.
         */
        var iamInstanceProfile: ScheduledInstancesIamInstanceProfile?
        /**
         * The ID of the Amazon Machine Image (AMI).
         */
        var imageId: String?
        /**
         * The instance type.
         */
        var instanceType: String?
        /**
         * The ID of the kernel.
         */
        var kernelId: String?
        /**
         * The name of the key pair.
         */
        var keyName: String?
        /**
         * Enable or disable monitoring for the instances.
         */
        var monitoring: ScheduledInstancesMonitoring?
        /**
         * The network interfaces.
         */
        var networkInterfaces: List<ScheduledInstancesNetworkInterface>?
        /**
         * The placement information.
         */
        var placement: ScheduledInstancesPlacement?
        /**
         * The ID of the RAM disk.
         */
        var ramdiskId: String?
        /**
         * The IDs of the security groups.
         */
        var securityGroupIds: List<String>?
        /**
         * The ID of the subnet in which to launch the instances.
         */
        var subnetId: String?
        /**
         * The base64-encoded MIME user data.
         */
        var userData: String?

        fun build(): ScheduledInstancesLaunchSpecification
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstancesIamInstanceProfile] inside the given [block]
         */
        fun iamInstanceProfile(block: ScheduledInstancesIamInstanceProfile.DslBuilder.() -> kotlin.Unit) {
            this.iamInstanceProfile = ScheduledInstancesIamInstanceProfile.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstancesMonitoring] inside the given [block]
         */
        fun monitoring(block: ScheduledInstancesMonitoring.DslBuilder.() -> kotlin.Unit) {
            this.monitoring = ScheduledInstancesMonitoring.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstancesPlacement] inside the given [block]
         */
        fun placement(block: ScheduledInstancesPlacement.DslBuilder.() -> kotlin.Unit) {
            this.placement = ScheduledInstancesPlacement.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var blockDeviceMappings: List<ScheduledInstancesBlockDeviceMapping>? = null
        override var ebsOptimized: Boolean? = null
        override var iamInstanceProfile: ScheduledInstancesIamInstanceProfile? = null
        override var imageId: String? = null
        override var instanceType: String? = null
        override var kernelId: String? = null
        override var keyName: String? = null
        override var monitoring: ScheduledInstancesMonitoring? = null
        override var networkInterfaces: List<ScheduledInstancesNetworkInterface>? = null
        override var placement: ScheduledInstancesPlacement? = null
        override var ramdiskId: String? = null
        override var securityGroupIds: List<String>? = null
        override var subnetId: String? = null
        override var userData: String? = null

        constructor(x: ScheduledInstancesLaunchSpecification) : this() {
            this.blockDeviceMappings = x.blockDeviceMappings
            this.ebsOptimized = x.ebsOptimized
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.placement = x.placement
            this.ramdiskId = x.ramdiskId
            this.securityGroupIds = x.securityGroupIds
            this.subnetId = x.subnetId
            this.userData = x.userData
        }

        override fun build(): ScheduledInstancesLaunchSpecification = ScheduledInstancesLaunchSpecification(this)
        override fun blockDeviceMappings(blockDeviceMappings: List<ScheduledInstancesBlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder = apply { this.ebsOptimized = ebsOptimized }
        override fun iamInstanceProfile(iamInstanceProfile: ScheduledInstancesIamInstanceProfile): FluentBuilder = apply { this.iamInstanceProfile = iamInstanceProfile }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun kernelId(kernelId: String): FluentBuilder = apply { this.kernelId = kernelId }
        override fun keyName(keyName: String): FluentBuilder = apply { this.keyName = keyName }
        override fun monitoring(monitoring: ScheduledInstancesMonitoring): FluentBuilder = apply { this.monitoring = monitoring }
        override fun networkInterfaces(networkInterfaces: List<ScheduledInstancesNetworkInterface>): FluentBuilder = apply { this.networkInterfaces = networkInterfaces }
        override fun placement(placement: ScheduledInstancesPlacement): FluentBuilder = apply { this.placement = placement }
        override fun ramdiskId(ramdiskId: String): FluentBuilder = apply { this.ramdiskId = ramdiskId }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun userData(userData: String): FluentBuilder = apply { this.userData = userData }
    }
}
