// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a network interface for a Scheduled Instance.
 */
class ScheduledInstancesNetworkInterface private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether to assign a public IPv4 address to instances launched in a VPC. The
     * public IPv4 address can only be assigned to a network interface for eth0, and can only be
     * assigned to a new network interface, not an existing one. You cannot specify more than one
     * network interface in the request. If launching into a default subnet, the default value is
     * true.
     */
    val associatePublicIpAddress: Boolean? = builder.associatePublicIpAddress
    /**
     * Indicates whether to delete the interface when the instance is terminated.
     */
    val deleteOnTermination: Boolean? = builder.deleteOnTermination
    /**
     * The description.
     */
    val description: String? = builder.description
    /**
     * The index of the device for the network interface attachment.
     */
    val deviceIndex: Int? = builder.deviceIndex
    /**
     * The IDs of the security groups.
     */
    val groups: List<String>? = builder.groups
    /**
     * The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.
     */
    val ipv6AddressCount: Int? = builder.ipv6AddressCount
    /**
     * The specific IPv6 addresses from the subnet range.
     */
    val ipv6Addresses: List<ScheduledInstancesIpv6Address>? = builder.ipv6Addresses
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The IPv4 address of the network interface within the subnet.
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * The private IPv4 addresses.
     */
    val privateIpAddressConfigs: List<ScheduledInstancesPrivateIpAddressConfig>? = builder.privateIpAddressConfigs
    /**
     * The number of secondary private IPv4 addresses.
     */
    val secondaryPrivateIpAddressCount: Int? = builder.secondaryPrivateIpAddressCount
    /**
     * The ID of the subnet.
     */
    val subnetId: String? = builder.subnetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScheduledInstancesNetworkInterface = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledInstancesNetworkInterface(")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("deleteOnTermination=$deleteOnTermination,")
        append("description=$description,")
        append("deviceIndex=$deviceIndex,")
        append("groups=$groups,")
        append("ipv6AddressCount=$ipv6AddressCount,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddressConfigs=$privateIpAddressConfigs,")
        append("secondaryPrivateIpAddressCount=$secondaryPrivateIpAddressCount,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatePublicIpAddress?.hashCode() ?: 0
        result = 31 * result + (deleteOnTermination?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceIndex ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (ipv6AddressCount ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddressConfigs?.hashCode() ?: 0)
        result = 31 * result + (secondaryPrivateIpAddressCount ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScheduledInstancesNetworkInterface

        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (deleteOnTermination != other.deleteOnTermination) return false
        if (description != other.description) return false
        if (deviceIndex != other.deviceIndex) return false
        if (groups != other.groups) return false
        if (ipv6AddressCount != other.ipv6AddressCount) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddressConfigs != other.privateIpAddressConfigs) return false
        if (secondaryPrivateIpAddressCount != other.secondaryPrivateIpAddressCount) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScheduledInstancesNetworkInterface = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScheduledInstancesNetworkInterface
        /**
         * Indicates whether to assign a public IPv4 address to instances launched in a VPC. The
         * public IPv4 address can only be assigned to a network interface for eth0, and can only be
         * assigned to a new network interface, not an existing one. You cannot specify more than one
         * network interface in the request. If launching into a default subnet, the default value is
         * true.
         */
        fun associatePublicIpAddress(associatePublicIpAddress: Boolean): FluentBuilder
        /**
         * Indicates whether to delete the interface when the instance is terminated.
         */
        fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder
        /**
         * The description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The index of the device for the network interface attachment.
         */
        fun deviceIndex(deviceIndex: Int): FluentBuilder
        /**
         * The IDs of the security groups.
         */
        fun groups(groups: List<String>): FluentBuilder
        /**
         * The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.
         */
        fun ipv6AddressCount(ipv6AddressCount: Int): FluentBuilder
        /**
         * The specific IPv6 addresses from the subnet range.
         */
        fun ipv6Addresses(ipv6Addresses: List<ScheduledInstancesIpv6Address>): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The IPv4 address of the network interface within the subnet.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * The private IPv4 addresses.
         */
        fun privateIpAddressConfigs(privateIpAddressConfigs: List<ScheduledInstancesPrivateIpAddressConfig>): FluentBuilder
        /**
         * The number of secondary private IPv4 addresses.
         */
        fun secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount: Int): FluentBuilder
        /**
         * The ID of the subnet.
         */
        fun subnetId(subnetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether to assign a public IPv4 address to instances launched in a VPC. The
         * public IPv4 address can only be assigned to a network interface for eth0, and can only be
         * assigned to a new network interface, not an existing one. You cannot specify more than one
         * network interface in the request. If launching into a default subnet, the default value is
         * true.
         */
        var associatePublicIpAddress: Boolean?
        /**
         * Indicates whether to delete the interface when the instance is terminated.
         */
        var deleteOnTermination: Boolean?
        /**
         * The description.
         */
        var description: String?
        /**
         * The index of the device for the network interface attachment.
         */
        var deviceIndex: Int?
        /**
         * The IDs of the security groups.
         */
        var groups: List<String>?
        /**
         * The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.
         */
        var ipv6AddressCount: Int?
        /**
         * The specific IPv6 addresses from the subnet range.
         */
        var ipv6Addresses: List<ScheduledInstancesIpv6Address>?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?
        /**
         * The IPv4 address of the network interface within the subnet.
         */
        var privateIpAddress: String?
        /**
         * The private IPv4 addresses.
         */
        var privateIpAddressConfigs: List<ScheduledInstancesPrivateIpAddressConfig>?
        /**
         * The number of secondary private IPv4 addresses.
         */
        var secondaryPrivateIpAddressCount: Int?
        /**
         * The ID of the subnet.
         */
        var subnetId: String?

        fun build(): ScheduledInstancesNetworkInterface
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associatePublicIpAddress: Boolean? = null
        override var deleteOnTermination: Boolean? = null
        override var description: String? = null
        override var deviceIndex: Int? = null
        override var groups: List<String>? = null
        override var ipv6AddressCount: Int? = null
        override var ipv6Addresses: List<ScheduledInstancesIpv6Address>? = null
        override var networkInterfaceId: String? = null
        override var privateIpAddress: String? = null
        override var privateIpAddressConfigs: List<ScheduledInstancesPrivateIpAddressConfig>? = null
        override var secondaryPrivateIpAddressCount: Int? = null
        override var subnetId: String? = null

        constructor(x: ScheduledInstancesNetworkInterface) : this() {
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.deleteOnTermination = x.deleteOnTermination
            this.description = x.description
            this.deviceIndex = x.deviceIndex
            this.groups = x.groups
            this.ipv6AddressCount = x.ipv6AddressCount
            this.ipv6Addresses = x.ipv6Addresses
            this.networkInterfaceId = x.networkInterfaceId
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddressConfigs = x.privateIpAddressConfigs
            this.secondaryPrivateIpAddressCount = x.secondaryPrivateIpAddressCount
            this.subnetId = x.subnetId
        }

        override fun build(): ScheduledInstancesNetworkInterface = ScheduledInstancesNetworkInterface(this)
        override fun associatePublicIpAddress(associatePublicIpAddress: Boolean): FluentBuilder = apply { this.associatePublicIpAddress = associatePublicIpAddress }
        override fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder = apply { this.deleteOnTermination = deleteOnTermination }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun deviceIndex(deviceIndex: Int): FluentBuilder = apply { this.deviceIndex = deviceIndex }
        override fun groups(groups: List<String>): FluentBuilder = apply { this.groups = groups }
        override fun ipv6AddressCount(ipv6AddressCount: Int): FluentBuilder = apply { this.ipv6AddressCount = ipv6AddressCount }
        override fun ipv6Addresses(ipv6Addresses: List<ScheduledInstancesIpv6Address>): FluentBuilder = apply { this.ipv6Addresses = ipv6Addresses }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun privateIpAddressConfigs(privateIpAddressConfigs: List<ScheduledInstancesPrivateIpAddressConfig>): FluentBuilder = apply { this.privateIpAddressConfigs = privateIpAddressConfigs }
        override fun secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount: Int): FluentBuilder = apply { this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
    }
}
