// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class SearchTransitGatewayMulticastGroupsRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters. The possible values are:
     * group-ip-address - The IP address of the  transit gateway multicast group.
     * is-group-member - The resource is a group member. Valid values are true | false.
     * is-group-source - The resource is a group source. Valid values are true | false.
     * member-type - The member type. Valid values are igmp | static.
     * resource-id - The ID of the resource.
     * resource-type - The type of resource. Valid values are vpc | vpn | direct-connect-gateway | tgw-peering.
     * source-type - The source type. Valid values are igmp | static.
     * subnet-id - The ID of the subnet.
     * transit-gateway-attachment-id - The id of the transit gateway attachment.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return with a single call.
     * To retrieve the remaining results, make another call with the returned nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The ID of the transit gateway multicast domain.
     */
    val transitGatewayMulticastDomainId: String? = builder.transitGatewayMulticastDomainId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SearchTransitGatewayMulticastGroupsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SearchTransitGatewayMulticastGroupsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("transitGatewayMulticastDomainId=$transitGatewayMulticastDomainId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayMulticastDomainId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SearchTransitGatewayMulticastGroupsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (transitGatewayMulticastDomainId != other.transitGatewayMulticastDomainId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SearchTransitGatewayMulticastGroupsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SearchTransitGatewayMulticastGroupsRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters. The possible values are:
         * group-ip-address - The IP address of the  transit gateway multicast group.
         * is-group-member - The resource is a group member. Valid values are true | false.
         * is-group-source - The resource is a group source. Valid values are true | false.
         * member-type - The member type. Valid values are igmp | static.
         * resource-id - The ID of the resource.
         * resource-type - The type of resource. Valid values are vpc | vpn | direct-connect-gateway | tgw-peering.
         * source-type - The source type. Valid values are igmp | static.
         * subnet-id - The ID of the subnet.
         * transit-gateway-attachment-id - The id of the transit gateway attachment.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The ID of the transit gateway multicast domain.
         */
        fun transitGatewayMulticastDomainId(transitGatewayMulticastDomainId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters. The possible values are:
         * group-ip-address - The IP address of the  transit gateway multicast group.
         * is-group-member - The resource is a group member. Valid values are true | false.
         * is-group-source - The resource is a group source. Valid values are true | false.
         * member-type - The member type. Valid values are igmp | static.
         * resource-id - The ID of the resource.
         * resource-type - The type of resource. Valid values are vpc | vpn | direct-connect-gateway | tgw-peering.
         * source-type - The source type. Valid values are igmp | static.
         * subnet-id - The ID of the subnet.
         * transit-gateway-attachment-id - The id of the transit gateway attachment.
         */
        var filters: List<Filter>?
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next page of results.
         */
        var nextToken: String?
        /**
         * The ID of the transit gateway multicast domain.
         */
        var transitGatewayMulticastDomainId: String?

        fun build(): SearchTransitGatewayMulticastGroupsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var transitGatewayMulticastDomainId: String? = null

        constructor(x: SearchTransitGatewayMulticastGroupsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.transitGatewayMulticastDomainId = x.transitGatewayMulticastDomainId
        }

        override fun build(): SearchTransitGatewayMulticastGroupsRequest = SearchTransitGatewayMulticastGroupsRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun transitGatewayMulticastDomainId(transitGatewayMulticastDomainId: String): FluentBuilder = apply { this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId }
    }
}
