// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a security group.
 */
class SecurityGroup private constructor(builder: BuilderImpl) {
    /**
     * A description of the security group.
     */
    val description: String? = builder.description
    /**
     * The ID of the security group.
     */
    val groupId: String? = builder.groupId
    /**
     * The name of the security group.
     */
    val groupName: String? = builder.groupName
    /**
     * The inbound rules associated with the security group.
     */
    val ipPermissions: List<IpPermission>? = builder.ipPermissions
    /**
     * &#91;VPC only&#93; The outbound rules associated with the security group.
     */
    val ipPermissionsEgress: List<IpPermission>? = builder.ipPermissionsEgress
    /**
     * The Amazon Web Services account ID of the owner of the security group.
     */
    val ownerId: String? = builder.ownerId
    /**
     * Any tags assigned to the security group.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * &#91;VPC only&#93; The ID of the VPC for the security group.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SecurityGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityGroup(")
        append("description=$description,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("ipPermissions=$ipPermissions,")
        append("ipPermissionsEgress=$ipPermissionsEgress,")
        append("ownerId=$ownerId,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (ipPermissions?.hashCode() ?: 0)
        result = 31 * result + (ipPermissionsEgress?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SecurityGroup

        if (description != other.description) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (ipPermissions != other.ipPermissions) return false
        if (ipPermissionsEgress != other.ipPermissionsEgress) return false
        if (ownerId != other.ownerId) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SecurityGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SecurityGroup
        /**
         * A description of the security group.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ID of the security group.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * The name of the security group.
         */
        fun groupName(groupName: String): FluentBuilder
        /**
         * The inbound rules associated with the security group.
         */
        fun ipPermissions(ipPermissions: List<IpPermission>): FluentBuilder
        /**
         * &#91;VPC only&#93; The outbound rules associated with the security group.
         */
        fun ipPermissionsEgress(ipPermissionsEgress: List<IpPermission>): FluentBuilder
        /**
         * The Amazon Web Services account ID of the owner of the security group.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * Any tags assigned to the security group.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * &#91;VPC only&#93; The ID of the VPC for the security group.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A description of the security group.
         */
        var description: String?
        /**
         * The ID of the security group.
         */
        var groupId: String?
        /**
         * The name of the security group.
         */
        var groupName: String?
        /**
         * The inbound rules associated with the security group.
         */
        var ipPermissions: List<IpPermission>?
        /**
         * &#91;VPC only&#93; The outbound rules associated with the security group.
         */
        var ipPermissionsEgress: List<IpPermission>?
        /**
         * The Amazon Web Services account ID of the owner of the security group.
         */
        var ownerId: String?
        /**
         * Any tags assigned to the security group.
         */
        var tags: List<Tag>?
        /**
         * &#91;VPC only&#93; The ID of the VPC for the security group.
         */
        var vpcId: String?

        fun build(): SecurityGroup
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var groupId: String? = null
        override var groupName: String? = null
        override var ipPermissions: List<IpPermission>? = null
        override var ipPermissionsEgress: List<IpPermission>? = null
        override var ownerId: String? = null
        override var tags: List<Tag>? = null
        override var vpcId: String? = null

        constructor(x: SecurityGroup) : this() {
            this.description = x.description
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.ipPermissions = x.ipPermissions
            this.ipPermissionsEgress = x.ipPermissionsEgress
            this.ownerId = x.ownerId
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        override fun build(): SecurityGroup = SecurityGroup(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun groupName(groupName: String): FluentBuilder = apply { this.groupName = groupName }
        override fun ipPermissions(ipPermissions: List<IpPermission>): FluentBuilder = apply { this.ipPermissions = ipPermissions }
        override fun ipPermissionsEgress(ipPermissionsEgress: List<IpPermission>): FluentBuilder = apply { this.ipPermissionsEgress = ipPermissionsEgress }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
