// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a VPC with a security group that references your security group.
 */
class SecurityGroupReference private constructor(builder: BuilderImpl) {
    /**
     * The ID of your security group.
     */
    val groupId: String? = builder.groupId
    /**
     * The ID of the VPC with the referencing security group.
     */
    val referencingVpcId: String? = builder.referencingVpcId
    /**
     * The ID of the VPC peering connection.
     */
    val vpcPeeringConnectionId: String? = builder.vpcPeeringConnectionId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SecurityGroupReference = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityGroupReference(")
        append("groupId=$groupId,")
        append("referencingVpcId=$referencingVpcId,")
        append("vpcPeeringConnectionId=$vpcPeeringConnectionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupId?.hashCode() ?: 0
        result = 31 * result + (referencingVpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SecurityGroupReference

        if (groupId != other.groupId) return false
        if (referencingVpcId != other.referencingVpcId) return false
        if (vpcPeeringConnectionId != other.vpcPeeringConnectionId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SecurityGroupReference = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SecurityGroupReference
        /**
         * The ID of your security group.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * The ID of the VPC with the referencing security group.
         */
        fun referencingVpcId(referencingVpcId: String): FluentBuilder
        /**
         * The ID of the VPC peering connection.
         */
        fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of your security group.
         */
        var groupId: String?
        /**
         * The ID of the VPC with the referencing security group.
         */
        var referencingVpcId: String?
        /**
         * The ID of the VPC peering connection.
         */
        var vpcPeeringConnectionId: String?

        fun build(): SecurityGroupReference
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var groupId: String? = null
        override var referencingVpcId: String? = null
        override var vpcPeeringConnectionId: String? = null

        constructor(x: SecurityGroupReference) : this() {
            this.groupId = x.groupId
            this.referencingVpcId = x.referencingVpcId
            this.vpcPeeringConnectionId = x.vpcPeeringConnectionId
        }

        override fun build(): SecurityGroupReference = SecurityGroupReference(this)
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun referencingVpcId(referencingVpcId: String): FluentBuilder = apply { this.referencingVpcId = referencingVpcId }
        override fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder = apply { this.vpcPeeringConnectionId = vpcPeeringConnectionId }
    }
}
