// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a security group rule.
 */
class SecurityGroupRule private constructor(builder: BuilderImpl) {
    /**
     * The IPv4 CIDR range.
     */
    val cidrIpv4: String? = builder.cidrIpv4
    /**
     * The IPv6 CIDR range.
     */
    val cidrIpv6: String? = builder.cidrIpv6
    /**
     * The security group rule description.
     */
    val description: String? = builder.description
    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type. A value
     * of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must
     * specify all codes.
     */
    val fromPort: Int? = builder.fromPort
    /**
     * The ID of the security group.
     */
    val groupId: String? = builder.groupId
    /**
     * The ID of the Amazon Web Services account that owns the security group.
     */
    val groupOwnerId: String? = builder.groupOwnerId
    /**
     * The IP protocol name (tcp, udp, icmp,
     * icmpv6) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
     * Use -1 to specify all protocols.
     */
    val ipProtocol: String? = builder.ipProtocol
    /**
     * Indicates whether the security group rule is an outbound rule.
     */
    val isEgress: Boolean? = builder.isEgress
    /**
     * The ID of the prefix list.
     */
    val prefixListId: String? = builder.prefixListId
    /**
     * Describes the security group that is referenced in the rule.
     */
    val referencedGroupInfo: ReferencedSecurityGroup? = builder.referencedGroupInfo
    /**
     * The ID of the security group rule.
     */
    val securityGroupRuleId: String? = builder.securityGroupRuleId
    /**
     * The tags applied to the security group rule.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    val toPort: Int? = builder.toPort

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SecurityGroupRule = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityGroupRule(")
        append("cidrIpv4=$cidrIpv4,")
        append("cidrIpv6=$cidrIpv6,")
        append("description=$description,")
        append("fromPort=$fromPort,")
        append("groupId=$groupId,")
        append("groupOwnerId=$groupOwnerId,")
        append("ipProtocol=$ipProtocol,")
        append("isEgress=$isEgress,")
        append("prefixListId=$prefixListId,")
        append("referencedGroupInfo=$referencedGroupInfo,")
        append("securityGroupRuleId=$securityGroupRuleId,")
        append("tags=$tags,")
        append("toPort=$toPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrIpv4?.hashCode() ?: 0
        result = 31 * result + (cidrIpv6?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fromPort ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupOwnerId?.hashCode() ?: 0)
        result = 31 * result + (ipProtocol?.hashCode() ?: 0)
        result = 31 * result + (isEgress?.hashCode() ?: 0)
        result = 31 * result + (prefixListId?.hashCode() ?: 0)
        result = 31 * result + (referencedGroupInfo?.hashCode() ?: 0)
        result = 31 * result + (securityGroupRuleId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SecurityGroupRule

        if (cidrIpv4 != other.cidrIpv4) return false
        if (cidrIpv6 != other.cidrIpv6) return false
        if (description != other.description) return false
        if (fromPort != other.fromPort) return false
        if (groupId != other.groupId) return false
        if (groupOwnerId != other.groupOwnerId) return false
        if (ipProtocol != other.ipProtocol) return false
        if (isEgress != other.isEgress) return false
        if (prefixListId != other.prefixListId) return false
        if (referencedGroupInfo != other.referencedGroupInfo) return false
        if (securityGroupRuleId != other.securityGroupRuleId) return false
        if (tags != other.tags) return false
        if (toPort != other.toPort) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SecurityGroupRule = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SecurityGroupRule
        /**
         * The IPv4 CIDR range.
         */
        fun cidrIpv4(cidrIpv4: String): FluentBuilder
        /**
         * The IPv6 CIDR range.
         */
        fun cidrIpv6(cidrIpv6: String): FluentBuilder
        /**
         * The security group rule description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type. A value
         * of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must
         * specify all codes.
         */
        fun fromPort(fromPort: Int): FluentBuilder
        /**
         * The ID of the security group.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the security group.
         */
        fun groupOwnerId(groupOwnerId: String): FluentBuilder
        /**
         * The IP protocol name (tcp, udp, icmp,
         * icmpv6) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
         * Use -1 to specify all protocols.
         */
        fun ipProtocol(ipProtocol: String): FluentBuilder
        /**
         * Indicates whether the security group rule is an outbound rule.
         */
        fun isEgress(isEgress: Boolean): FluentBuilder
        /**
         * The ID of the prefix list.
         */
        fun prefixListId(prefixListId: String): FluentBuilder
        /**
         * Describes the security group that is referenced in the rule.
         */
        fun referencedGroupInfo(referencedGroupInfo: ReferencedSecurityGroup): FluentBuilder
        /**
         * The ID of the security group rule.
         */
        fun securityGroupRuleId(securityGroupRuleId: String): FluentBuilder
        /**
         * The tags applied to the security group rule.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         */
        fun toPort(toPort: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IPv4 CIDR range.
         */
        var cidrIpv4: String?
        /**
         * The IPv6 CIDR range.
         */
        var cidrIpv6: String?
        /**
         * The security group rule description.
         */
        var description: String?
        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type. A value
         * of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must
         * specify all codes.
         */
        var fromPort: Int?
        /**
         * The ID of the security group.
         */
        var groupId: String?
        /**
         * The ID of the Amazon Web Services account that owns the security group.
         */
        var groupOwnerId: String?
        /**
         * The IP protocol name (tcp, udp, icmp,
         * icmpv6) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
         * Use -1 to specify all protocols.
         */
        var ipProtocol: String?
        /**
         * Indicates whether the security group rule is an outbound rule.
         */
        var isEgress: Boolean?
        /**
         * The ID of the prefix list.
         */
        var prefixListId: String?
        /**
         * Describes the security group that is referenced in the rule.
         */
        var referencedGroupInfo: ReferencedSecurityGroup?
        /**
         * The ID of the security group rule.
         */
        var securityGroupRuleId: String?
        /**
         * The tags applied to the security group rule.
         */
        var tags: List<Tag>?
        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         */
        var toPort: Int?

        fun build(): SecurityGroupRule
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ReferencedSecurityGroup] inside the given [block]
         */
        fun referencedGroupInfo(block: ReferencedSecurityGroup.DslBuilder.() -> kotlin.Unit) {
            this.referencedGroupInfo = ReferencedSecurityGroup.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidrIpv4: String? = null
        override var cidrIpv6: String? = null
        override var description: String? = null
        override var fromPort: Int? = null
        override var groupId: String? = null
        override var groupOwnerId: String? = null
        override var ipProtocol: String? = null
        override var isEgress: Boolean? = null
        override var prefixListId: String? = null
        override var referencedGroupInfo: ReferencedSecurityGroup? = null
        override var securityGroupRuleId: String? = null
        override var tags: List<Tag>? = null
        override var toPort: Int? = null

        constructor(x: SecurityGroupRule) : this() {
            this.cidrIpv4 = x.cidrIpv4
            this.cidrIpv6 = x.cidrIpv6
            this.description = x.description
            this.fromPort = x.fromPort
            this.groupId = x.groupId
            this.groupOwnerId = x.groupOwnerId
            this.ipProtocol = x.ipProtocol
            this.isEgress = x.isEgress
            this.prefixListId = x.prefixListId
            this.referencedGroupInfo = x.referencedGroupInfo
            this.securityGroupRuleId = x.securityGroupRuleId
            this.tags = x.tags
            this.toPort = x.toPort
        }

        override fun build(): SecurityGroupRule = SecurityGroupRule(this)
        override fun cidrIpv4(cidrIpv4: String): FluentBuilder = apply { this.cidrIpv4 = cidrIpv4 }
        override fun cidrIpv6(cidrIpv6: String): FluentBuilder = apply { this.cidrIpv6 = cidrIpv6 }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun fromPort(fromPort: Int): FluentBuilder = apply { this.fromPort = fromPort }
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun groupOwnerId(groupOwnerId: String): FluentBuilder = apply { this.groupOwnerId = groupOwnerId }
        override fun ipProtocol(ipProtocol: String): FluentBuilder = apply { this.ipProtocol = ipProtocol }
        override fun isEgress(isEgress: Boolean): FluentBuilder = apply { this.isEgress = isEgress }
        override fun prefixListId(prefixListId: String): FluentBuilder = apply { this.prefixListId = prefixListId }
        override fun referencedGroupInfo(referencedGroupInfo: ReferencedSecurityGroup): FluentBuilder = apply { this.referencedGroupInfo = referencedGroupInfo }
        override fun securityGroupRuleId(securityGroupRuleId: String): FluentBuilder = apply { this.securityGroupRuleId = securityGroupRuleId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun toPort(toPort: Int): FluentBuilder = apply { this.toPort = toPort }
    }
}
