// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a service configuration for a VPC endpoint service.
 */
class ServiceConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.
     */
    val acceptanceRequired: Boolean? = builder.acceptanceRequired
    /**
     * The Availability Zones in which the service is available.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The DNS names for the service.
     */
    val baseEndpointDnsNames: List<String>? = builder.baseEndpointDnsNames
    /**
     * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
     */
    val gatewayLoadBalancerArns: List<String>? = builder.gatewayLoadBalancerArns
    /**
     * Indicates whether the service manages its VPC endpoints. Management of the service VPC
     * endpoints using the VPC endpoint API is restricted.
     */
    val managesVpcEndpoints: Boolean? = builder.managesVpcEndpoints
    /**
     * The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
     */
    val networkLoadBalancerArns: List<String>? = builder.networkLoadBalancerArns
    /**
     * The private DNS name for the service.
     */
    val privateDnsName: String? = builder.privateDnsName
    /**
     * Information about the endpoint service private DNS name configuration.
     */
    val privateDnsNameConfiguration: PrivateDnsNameConfiguration? = builder.privateDnsNameConfiguration
    /**
     * The ID of the service.
     */
    val serviceId: String? = builder.serviceId
    /**
     * The name of the service.
     */
    val serviceName: String? = builder.serviceName
    /**
     * The service state.
     */
    val serviceState: ServiceState? = builder.serviceState
    /**
     * The type of service.
     */
    val serviceType: List<ServiceTypeDetail>? = builder.serviceType
    /**
     * Any tags assigned to the service.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ServiceConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceConfiguration(")
        append("acceptanceRequired=$acceptanceRequired,")
        append("availabilityZones=$availabilityZones,")
        append("baseEndpointDnsNames=$baseEndpointDnsNames,")
        append("gatewayLoadBalancerArns=$gatewayLoadBalancerArns,")
        append("managesVpcEndpoints=$managesVpcEndpoints,")
        append("networkLoadBalancerArns=$networkLoadBalancerArns,")
        append("privateDnsName=$privateDnsName,")
        append("privateDnsNameConfiguration=$privateDnsNameConfiguration,")
        append("serviceId=$serviceId,")
        append("serviceName=$serviceName,")
        append("serviceState=$serviceState,")
        append("serviceType=$serviceType,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptanceRequired?.hashCode() ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (baseEndpointDnsNames?.hashCode() ?: 0)
        result = 31 * result + (gatewayLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (managesVpcEndpoints?.hashCode() ?: 0)
        result = 31 * result + (networkLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateDnsNameConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceId?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceState?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ServiceConfiguration

        if (acceptanceRequired != other.acceptanceRequired) return false
        if (availabilityZones != other.availabilityZones) return false
        if (baseEndpointDnsNames != other.baseEndpointDnsNames) return false
        if (gatewayLoadBalancerArns != other.gatewayLoadBalancerArns) return false
        if (managesVpcEndpoints != other.managesVpcEndpoints) return false
        if (networkLoadBalancerArns != other.networkLoadBalancerArns) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateDnsNameConfiguration != other.privateDnsNameConfiguration) return false
        if (serviceId != other.serviceId) return false
        if (serviceName != other.serviceName) return false
        if (serviceState != other.serviceState) return false
        if (serviceType != other.serviceType) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ServiceConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ServiceConfiguration
        /**
         * Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.
         */
        fun acceptanceRequired(acceptanceRequired: Boolean): FluentBuilder
        /**
         * The Availability Zones in which the service is available.
         */
        fun availabilityZones(availabilityZones: List<String>): FluentBuilder
        /**
         * The DNS names for the service.
         */
        fun baseEndpointDnsNames(baseEndpointDnsNames: List<String>): FluentBuilder
        /**
         * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
         */
        fun gatewayLoadBalancerArns(gatewayLoadBalancerArns: List<String>): FluentBuilder
        /**
         * Indicates whether the service manages its VPC endpoints. Management of the service VPC
         * endpoints using the VPC endpoint API is restricted.
         */
        fun managesVpcEndpoints(managesVpcEndpoints: Boolean): FluentBuilder
        /**
         * The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
         */
        fun networkLoadBalancerArns(networkLoadBalancerArns: List<String>): FluentBuilder
        /**
         * The private DNS name for the service.
         */
        fun privateDnsName(privateDnsName: String): FluentBuilder
        /**
         * Information about the endpoint service private DNS name configuration.
         */
        fun privateDnsNameConfiguration(privateDnsNameConfiguration: PrivateDnsNameConfiguration): FluentBuilder
        /**
         * The ID of the service.
         */
        fun serviceId(serviceId: String): FluentBuilder
        /**
         * The name of the service.
         */
        fun serviceName(serviceName: String): FluentBuilder
        /**
         * The service state.
         */
        fun serviceState(serviceState: ServiceState): FluentBuilder
        /**
         * The type of service.
         */
        fun serviceType(serviceType: List<ServiceTypeDetail>): FluentBuilder
        /**
         * Any tags assigned to the service.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.
         */
        var acceptanceRequired: Boolean?
        /**
         * The Availability Zones in which the service is available.
         */
        var availabilityZones: List<String>?
        /**
         * The DNS names for the service.
         */
        var baseEndpointDnsNames: List<String>?
        /**
         * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
         */
        var gatewayLoadBalancerArns: List<String>?
        /**
         * Indicates whether the service manages its VPC endpoints. Management of the service VPC
         * endpoints using the VPC endpoint API is restricted.
         */
        var managesVpcEndpoints: Boolean?
        /**
         * The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
         */
        var networkLoadBalancerArns: List<String>?
        /**
         * The private DNS name for the service.
         */
        var privateDnsName: String?
        /**
         * Information about the endpoint service private DNS name configuration.
         */
        var privateDnsNameConfiguration: PrivateDnsNameConfiguration?
        /**
         * The ID of the service.
         */
        var serviceId: String?
        /**
         * The name of the service.
         */
        var serviceName: String?
        /**
         * The service state.
         */
        var serviceState: ServiceState?
        /**
         * The type of service.
         */
        var serviceType: List<ServiceTypeDetail>?
        /**
         * Any tags assigned to the service.
         */
        var tags: List<Tag>?

        fun build(): ServiceConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PrivateDnsNameConfiguration] inside the given [block]
         */
        fun privateDnsNameConfiguration(block: PrivateDnsNameConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.privateDnsNameConfiguration = PrivateDnsNameConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var acceptanceRequired: Boolean? = null
        override var availabilityZones: List<String>? = null
        override var baseEndpointDnsNames: List<String>? = null
        override var gatewayLoadBalancerArns: List<String>? = null
        override var managesVpcEndpoints: Boolean? = null
        override var networkLoadBalancerArns: List<String>? = null
        override var privateDnsName: String? = null
        override var privateDnsNameConfiguration: PrivateDnsNameConfiguration? = null
        override var serviceId: String? = null
        override var serviceName: String? = null
        override var serviceState: ServiceState? = null
        override var serviceType: List<ServiceTypeDetail>? = null
        override var tags: List<Tag>? = null

        constructor(x: ServiceConfiguration) : this() {
            this.acceptanceRequired = x.acceptanceRequired
            this.availabilityZones = x.availabilityZones
            this.baseEndpointDnsNames = x.baseEndpointDnsNames
            this.gatewayLoadBalancerArns = x.gatewayLoadBalancerArns
            this.managesVpcEndpoints = x.managesVpcEndpoints
            this.networkLoadBalancerArns = x.networkLoadBalancerArns
            this.privateDnsName = x.privateDnsName
            this.privateDnsNameConfiguration = x.privateDnsNameConfiguration
            this.serviceId = x.serviceId
            this.serviceName = x.serviceName
            this.serviceState = x.serviceState
            this.serviceType = x.serviceType
            this.tags = x.tags
        }

        override fun build(): ServiceConfiguration = ServiceConfiguration(this)
        override fun acceptanceRequired(acceptanceRequired: Boolean): FluentBuilder = apply { this.acceptanceRequired = acceptanceRequired }
        override fun availabilityZones(availabilityZones: List<String>): FluentBuilder = apply { this.availabilityZones = availabilityZones }
        override fun baseEndpointDnsNames(baseEndpointDnsNames: List<String>): FluentBuilder = apply { this.baseEndpointDnsNames = baseEndpointDnsNames }
        override fun gatewayLoadBalancerArns(gatewayLoadBalancerArns: List<String>): FluentBuilder = apply { this.gatewayLoadBalancerArns = gatewayLoadBalancerArns }
        override fun managesVpcEndpoints(managesVpcEndpoints: Boolean): FluentBuilder = apply { this.managesVpcEndpoints = managesVpcEndpoints }
        override fun networkLoadBalancerArns(networkLoadBalancerArns: List<String>): FluentBuilder = apply { this.networkLoadBalancerArns = networkLoadBalancerArns }
        override fun privateDnsName(privateDnsName: String): FluentBuilder = apply { this.privateDnsName = privateDnsName }
        override fun privateDnsNameConfiguration(privateDnsNameConfiguration: PrivateDnsNameConfiguration): FluentBuilder = apply { this.privateDnsNameConfiguration = privateDnsNameConfiguration }
        override fun serviceId(serviceId: String): FluentBuilder = apply { this.serviceId = serviceId }
        override fun serviceName(serviceName: String): FluentBuilder = apply { this.serviceName = serviceName }
        override fun serviceState(serviceState: ServiceState): FluentBuilder = apply { this.serviceState = serviceState }
        override fun serviceType(serviceType: List<ServiceTypeDetail>): FluentBuilder = apply { this.serviceType = serviceType }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
