// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a VPC endpoint service.
 */
class ServiceDetail private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.
     */
    val acceptanceRequired: Boolean? = builder.acceptanceRequired
    /**
     * The Availability Zones in which the service is available.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The DNS names for the service.
     */
    val baseEndpointDnsNames: List<String>? = builder.baseEndpointDnsNames
    /**
     * Indicates whether the service manages its VPC endpoints. Management of the service VPC
     * endpoints using the VPC endpoint API is restricted.
     */
    val managesVpcEndpoints: Boolean? = builder.managesVpcEndpoints
    /**
     * The Amazon Web Services account ID of the service owner.
     */
    val owner: String? = builder.owner
    /**
     * The private DNS name for the service.
     */
    val privateDnsName: String? = builder.privateDnsName
    /**
     * The verification state of the VPC endpoint service.
     * Consumers of the endpoint service cannot use the private name when the state is not verified.
     */
    val privateDnsNameVerificationState: DnsNameState? = builder.privateDnsNameVerificationState
    /**
     * The private DNS names assigned to the VPC endpoint service.
     */
    val privateDnsNames: List<PrivateDnsDetails>? = builder.privateDnsNames
    /**
     * The ID of the endpoint service.
     */
    val serviceId: String? = builder.serviceId
    /**
     * The Amazon Resource Name (ARN) of the service.
     */
    val serviceName: String? = builder.serviceName
    /**
     * The type of service.
     */
    val serviceType: List<ServiceTypeDetail>? = builder.serviceType
    /**
     * Any tags assigned to the service.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Indicates whether the service supports endpoint policies.
     */
    val vpcEndpointPolicySupported: Boolean? = builder.vpcEndpointPolicySupported

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ServiceDetail = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceDetail(")
        append("acceptanceRequired=$acceptanceRequired,")
        append("availabilityZones=$availabilityZones,")
        append("baseEndpointDnsNames=$baseEndpointDnsNames,")
        append("managesVpcEndpoints=$managesVpcEndpoints,")
        append("owner=$owner,")
        append("privateDnsName=$privateDnsName,")
        append("privateDnsNameVerificationState=$privateDnsNameVerificationState,")
        append("privateDnsNames=$privateDnsNames,")
        append("serviceId=$serviceId,")
        append("serviceName=$serviceName,")
        append("serviceType=$serviceType,")
        append("tags=$tags,")
        append("vpcEndpointPolicySupported=$vpcEndpointPolicySupported)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptanceRequired?.hashCode() ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (baseEndpointDnsNames?.hashCode() ?: 0)
        result = 31 * result + (managesVpcEndpoints?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateDnsNameVerificationState?.hashCode() ?: 0)
        result = 31 * result + (privateDnsNames?.hashCode() ?: 0)
        result = 31 * result + (serviceId?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointPolicySupported?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ServiceDetail

        if (acceptanceRequired != other.acceptanceRequired) return false
        if (availabilityZones != other.availabilityZones) return false
        if (baseEndpointDnsNames != other.baseEndpointDnsNames) return false
        if (managesVpcEndpoints != other.managesVpcEndpoints) return false
        if (owner != other.owner) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateDnsNameVerificationState != other.privateDnsNameVerificationState) return false
        if (privateDnsNames != other.privateDnsNames) return false
        if (serviceId != other.serviceId) return false
        if (serviceName != other.serviceName) return false
        if (serviceType != other.serviceType) return false
        if (tags != other.tags) return false
        if (vpcEndpointPolicySupported != other.vpcEndpointPolicySupported) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ServiceDetail = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ServiceDetail
        /**
         * Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.
         */
        fun acceptanceRequired(acceptanceRequired: Boolean): FluentBuilder
        /**
         * The Availability Zones in which the service is available.
         */
        fun availabilityZones(availabilityZones: List<String>): FluentBuilder
        /**
         * The DNS names for the service.
         */
        fun baseEndpointDnsNames(baseEndpointDnsNames: List<String>): FluentBuilder
        /**
         * Indicates whether the service manages its VPC endpoints. Management of the service VPC
         * endpoints using the VPC endpoint API is restricted.
         */
        fun managesVpcEndpoints(managesVpcEndpoints: Boolean): FluentBuilder
        /**
         * The Amazon Web Services account ID of the service owner.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The private DNS name for the service.
         */
        fun privateDnsName(privateDnsName: String): FluentBuilder
        /**
         * The verification state of the VPC endpoint service.
         * Consumers of the endpoint service cannot use the private name when the state is not verified.
         */
        fun privateDnsNameVerificationState(privateDnsNameVerificationState: DnsNameState): FluentBuilder
        /**
         * The private DNS names assigned to the VPC endpoint service.
         */
        fun privateDnsNames(privateDnsNames: List<PrivateDnsDetails>): FluentBuilder
        /**
         * The ID of the endpoint service.
         */
        fun serviceId(serviceId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the service.
         */
        fun serviceName(serviceName: String): FluentBuilder
        /**
         * The type of service.
         */
        fun serviceType(serviceType: List<ServiceTypeDetail>): FluentBuilder
        /**
         * Any tags assigned to the service.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * Indicates whether the service supports endpoint policies.
         */
        fun vpcEndpointPolicySupported(vpcEndpointPolicySupported: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.
         */
        var acceptanceRequired: Boolean?
        /**
         * The Availability Zones in which the service is available.
         */
        var availabilityZones: List<String>?
        /**
         * The DNS names for the service.
         */
        var baseEndpointDnsNames: List<String>?
        /**
         * Indicates whether the service manages its VPC endpoints. Management of the service VPC
         * endpoints using the VPC endpoint API is restricted.
         */
        var managesVpcEndpoints: Boolean?
        /**
         * The Amazon Web Services account ID of the service owner.
         */
        var owner: String?
        /**
         * The private DNS name for the service.
         */
        var privateDnsName: String?
        /**
         * The verification state of the VPC endpoint service.
         * Consumers of the endpoint service cannot use the private name when the state is not verified.
         */
        var privateDnsNameVerificationState: DnsNameState?
        /**
         * The private DNS names assigned to the VPC endpoint service.
         */
        var privateDnsNames: List<PrivateDnsDetails>?
        /**
         * The ID of the endpoint service.
         */
        var serviceId: String?
        /**
         * The Amazon Resource Name (ARN) of the service.
         */
        var serviceName: String?
        /**
         * The type of service.
         */
        var serviceType: List<ServiceTypeDetail>?
        /**
         * Any tags assigned to the service.
         */
        var tags: List<Tag>?
        /**
         * Indicates whether the service supports endpoint policies.
         */
        var vpcEndpointPolicySupported: Boolean?

        fun build(): ServiceDetail
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var acceptanceRequired: Boolean? = null
        override var availabilityZones: List<String>? = null
        override var baseEndpointDnsNames: List<String>? = null
        override var managesVpcEndpoints: Boolean? = null
        override var owner: String? = null
        override var privateDnsName: String? = null
        override var privateDnsNameVerificationState: DnsNameState? = null
        override var privateDnsNames: List<PrivateDnsDetails>? = null
        override var serviceId: String? = null
        override var serviceName: String? = null
        override var serviceType: List<ServiceTypeDetail>? = null
        override var tags: List<Tag>? = null
        override var vpcEndpointPolicySupported: Boolean? = null

        constructor(x: ServiceDetail) : this() {
            this.acceptanceRequired = x.acceptanceRequired
            this.availabilityZones = x.availabilityZones
            this.baseEndpointDnsNames = x.baseEndpointDnsNames
            this.managesVpcEndpoints = x.managesVpcEndpoints
            this.owner = x.owner
            this.privateDnsName = x.privateDnsName
            this.privateDnsNameVerificationState = x.privateDnsNameVerificationState
            this.privateDnsNames = x.privateDnsNames
            this.serviceId = x.serviceId
            this.serviceName = x.serviceName
            this.serviceType = x.serviceType
            this.tags = x.tags
            this.vpcEndpointPolicySupported = x.vpcEndpointPolicySupported
        }

        override fun build(): ServiceDetail = ServiceDetail(this)
        override fun acceptanceRequired(acceptanceRequired: Boolean): FluentBuilder = apply { this.acceptanceRequired = acceptanceRequired }
        override fun availabilityZones(availabilityZones: List<String>): FluentBuilder = apply { this.availabilityZones = availabilityZones }
        override fun baseEndpointDnsNames(baseEndpointDnsNames: List<String>): FluentBuilder = apply { this.baseEndpointDnsNames = baseEndpointDnsNames }
        override fun managesVpcEndpoints(managesVpcEndpoints: Boolean): FluentBuilder = apply { this.managesVpcEndpoints = managesVpcEndpoints }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun privateDnsName(privateDnsName: String): FluentBuilder = apply { this.privateDnsName = privateDnsName }
        override fun privateDnsNameVerificationState(privateDnsNameVerificationState: DnsNameState): FluentBuilder = apply { this.privateDnsNameVerificationState = privateDnsNameVerificationState }
        override fun privateDnsNames(privateDnsNames: List<PrivateDnsDetails>): FluentBuilder = apply { this.privateDnsNames = privateDnsNames }
        override fun serviceId(serviceId: String): FluentBuilder = apply { this.serviceId = serviceId }
        override fun serviceName(serviceName: String): FluentBuilder = apply { this.serviceName = serviceName }
        override fun serviceType(serviceType: List<ServiceTypeDetail>): FluentBuilder = apply { this.serviceType = serviceType }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcEndpointPolicySupported(vpcEndpointPolicySupported: Boolean): FluentBuilder = apply { this.vpcEndpointPolicySupported = vpcEndpointPolicySupported }
    }
}
