// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the snapshot created from the imported disk.
 */
class SnapshotDetail private constructor(builder: BuilderImpl) {
    /**
     * A description for the snapshot.
     */
    val description: String? = builder.description
    /**
     * The block device mapping for the snapshot.
     */
    val deviceName: String? = builder.deviceName
    /**
     * The size of the disk in the snapshot, in GiB.
     */
    val diskImageSize: Double? = builder.diskImageSize
    /**
     * The format of the disk image from which the snapshot is created.
     */
    val format: String? = builder.format
    /**
     * The percentage of progress for the task.
     */
    val progress: String? = builder.progress
    /**
     * The snapshot ID of the disk being imported.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * A brief status of the snapshot creation.
     */
    val status: String? = builder.status
    /**
     * A detailed status message for the snapshot creation.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * The URL used to access the disk image.
     */
    val url: String? = builder.url
    /**
     * The Amazon S3 bucket for the disk image.
     */
    val userBucket: UserBucketDetails? = builder.userBucket

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SnapshotDetail = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SnapshotDetail(")
        append("description=$description,")
        append("deviceName=$deviceName,")
        append("diskImageSize=$diskImageSize,")
        append("format=$format,")
        append("progress=$progress,")
        append("snapshotId=$snapshotId,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("url=$url,")
        append("userBucket=$userBucket)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (diskImageSize?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (userBucket?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SnapshotDetail

        if (description != other.description) return false
        if (deviceName != other.deviceName) return false
        if (diskImageSize != other.diskImageSize) return false
        if (format != other.format) return false
        if (progress != other.progress) return false
        if (snapshotId != other.snapshotId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (url != other.url) return false
        if (userBucket != other.userBucket) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SnapshotDetail = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SnapshotDetail
        /**
         * A description for the snapshot.
         */
        fun description(description: String): FluentBuilder
        /**
         * The block device mapping for the snapshot.
         */
        fun deviceName(deviceName: String): FluentBuilder
        /**
         * The size of the disk in the snapshot, in GiB.
         */
        fun diskImageSize(diskImageSize: Double): FluentBuilder
        /**
         * The format of the disk image from which the snapshot is created.
         */
        fun format(format: String): FluentBuilder
        /**
         * The percentage of progress for the task.
         */
        fun progress(progress: String): FluentBuilder
        /**
         * The snapshot ID of the disk being imported.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * A brief status of the snapshot creation.
         */
        fun status(status: String): FluentBuilder
        /**
         * A detailed status message for the snapshot creation.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * The URL used to access the disk image.
         */
        fun url(url: String): FluentBuilder
        /**
         * The Amazon S3 bucket for the disk image.
         */
        fun userBucket(userBucket: UserBucketDetails): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A description for the snapshot.
         */
        var description: String?
        /**
         * The block device mapping for the snapshot.
         */
        var deviceName: String?
        /**
         * The size of the disk in the snapshot, in GiB.
         */
        var diskImageSize: Double?
        /**
         * The format of the disk image from which the snapshot is created.
         */
        var format: String?
        /**
         * The percentage of progress for the task.
         */
        var progress: String?
        /**
         * The snapshot ID of the disk being imported.
         */
        var snapshotId: String?
        /**
         * A brief status of the snapshot creation.
         */
        var status: String?
        /**
         * A detailed status message for the snapshot creation.
         */
        var statusMessage: String?
        /**
         * The URL used to access the disk image.
         */
        var url: String?
        /**
         * The Amazon S3 bucket for the disk image.
         */
        var userBucket: UserBucketDetails?

        fun build(): SnapshotDetail
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.UserBucketDetails] inside the given [block]
         */
        fun userBucket(block: UserBucketDetails.DslBuilder.() -> kotlin.Unit) {
            this.userBucket = UserBucketDetails.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var deviceName: String? = null
        override var diskImageSize: Double? = null
        override var format: String? = null
        override var progress: String? = null
        override var snapshotId: String? = null
        override var status: String? = null
        override var statusMessage: String? = null
        override var url: String? = null
        override var userBucket: UserBucketDetails? = null

        constructor(x: SnapshotDetail) : this() {
            this.description = x.description
            this.deviceName = x.deviceName
            this.diskImageSize = x.diskImageSize
            this.format = x.format
            this.progress = x.progress
            this.snapshotId = x.snapshotId
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.url = x.url
            this.userBucket = x.userBucket
        }

        override fun build(): SnapshotDetail = SnapshotDetail(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun deviceName(deviceName: String): FluentBuilder = apply { this.deviceName = deviceName }
        override fun diskImageSize(diskImageSize: Double): FluentBuilder = apply { this.diskImageSize = diskImageSize }
        override fun format(format: String): FluentBuilder = apply { this.format = format }
        override fun progress(progress: String): FluentBuilder = apply { this.progress = progress }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun url(url: String): FluentBuilder = apply { this.url = url }
        override fun userBucket(userBucket: UserBucketDetails): FluentBuilder = apply { this.userBucket = userBucket }
    }
}
