// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Details about the import snapshot task.
 */
class SnapshotTaskDetail private constructor(builder: BuilderImpl) {
    /**
     * The description of the snapshot.
     */
    val description: String? = builder.description
    /**
     * The size of the disk in the snapshot, in GiB.
     */
    val diskImageSize: Double? = builder.diskImageSize
    /**
     * Indicates whether the snapshot is encrypted.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * The format of the disk image from which the snapshot is created.
     */
    val format: String? = builder.format
    /**
     * The identifier for the KMS key that was used to create the encrypted snapshot.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The percentage of completion for the import snapshot task.
     */
    val progress: String? = builder.progress
    /**
     * The snapshot ID of the disk being imported.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * A brief status for the import snapshot task.
     */
    val status: String? = builder.status
    /**
     * A detailed status message for the import snapshot task.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * The URL of the disk image from which the snapshot is created.
     */
    val url: String? = builder.url
    /**
     * The Amazon S3 bucket for the disk image.
     */
    val userBucket: UserBucketDetails? = builder.userBucket

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SnapshotTaskDetail = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SnapshotTaskDetail(")
        append("description=$description,")
        append("diskImageSize=$diskImageSize,")
        append("encrypted=$encrypted,")
        append("format=$format,")
        append("kmsKeyId=$kmsKeyId,")
        append("progress=$progress,")
        append("snapshotId=$snapshotId,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("url=$url,")
        append("userBucket=$userBucket)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (diskImageSize?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (userBucket?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SnapshotTaskDetail

        if (description != other.description) return false
        if (diskImageSize != other.diskImageSize) return false
        if (encrypted != other.encrypted) return false
        if (format != other.format) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (progress != other.progress) return false
        if (snapshotId != other.snapshotId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (url != other.url) return false
        if (userBucket != other.userBucket) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SnapshotTaskDetail = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SnapshotTaskDetail
        /**
         * The description of the snapshot.
         */
        fun description(description: String): FluentBuilder
        /**
         * The size of the disk in the snapshot, in GiB.
         */
        fun diskImageSize(diskImageSize: Double): FluentBuilder
        /**
         * Indicates whether the snapshot is encrypted.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * The format of the disk image from which the snapshot is created.
         */
        fun format(format: String): FluentBuilder
        /**
         * The identifier for the KMS key that was used to create the encrypted snapshot.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The percentage of completion for the import snapshot task.
         */
        fun progress(progress: String): FluentBuilder
        /**
         * The snapshot ID of the disk being imported.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * A brief status for the import snapshot task.
         */
        fun status(status: String): FluentBuilder
        /**
         * A detailed status message for the import snapshot task.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * The URL of the disk image from which the snapshot is created.
         */
        fun url(url: String): FluentBuilder
        /**
         * The Amazon S3 bucket for the disk image.
         */
        fun userBucket(userBucket: UserBucketDetails): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description of the snapshot.
         */
        var description: String?
        /**
         * The size of the disk in the snapshot, in GiB.
         */
        var diskImageSize: Double?
        /**
         * Indicates whether the snapshot is encrypted.
         */
        var encrypted: Boolean?
        /**
         * The format of the disk image from which the snapshot is created.
         */
        var format: String?
        /**
         * The identifier for the KMS key that was used to create the encrypted snapshot.
         */
        var kmsKeyId: String?
        /**
         * The percentage of completion for the import snapshot task.
         */
        var progress: String?
        /**
         * The snapshot ID of the disk being imported.
         */
        var snapshotId: String?
        /**
         * A brief status for the import snapshot task.
         */
        var status: String?
        /**
         * A detailed status message for the import snapshot task.
         */
        var statusMessage: String?
        /**
         * The URL of the disk image from which the snapshot is created.
         */
        var url: String?
        /**
         * The Amazon S3 bucket for the disk image.
         */
        var userBucket: UserBucketDetails?

        fun build(): SnapshotTaskDetail
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.UserBucketDetails] inside the given [block]
         */
        fun userBucket(block: UserBucketDetails.DslBuilder.() -> kotlin.Unit) {
            this.userBucket = UserBucketDetails.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var diskImageSize: Double? = null
        override var encrypted: Boolean? = null
        override var format: String? = null
        override var kmsKeyId: String? = null
        override var progress: String? = null
        override var snapshotId: String? = null
        override var status: String? = null
        override var statusMessage: String? = null
        override var url: String? = null
        override var userBucket: UserBucketDetails? = null

        constructor(x: SnapshotTaskDetail) : this() {
            this.description = x.description
            this.diskImageSize = x.diskImageSize
            this.encrypted = x.encrypted
            this.format = x.format
            this.kmsKeyId = x.kmsKeyId
            this.progress = x.progress
            this.snapshotId = x.snapshotId
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.url = x.url
            this.userBucket = x.userBucket
        }

        override fun build(): SnapshotTaskDetail = SnapshotTaskDetail(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun diskImageSize(diskImageSize: Double): FluentBuilder = apply { this.diskImageSize = diskImageSize }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun format(format: String): FluentBuilder = apply { this.format = format }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun progress(progress: String): FluentBuilder = apply { this.progress = progress }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun url(url: String): FluentBuilder = apply { this.url = url }
        override fun userBucket(userBucket: UserBucketDetails): FluentBuilder = apply { this.userBucket = userBucket }
    }
}
