// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The Spot Instance replacement strategy to use when Amazon EC2 emits a signal that your
 * Spot Instance is at an elevated risk of being interrupted. For more information, see
 * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#spot-fleet-capacity-rebalance">Capacity rebalancing in the Amazon EC2 User Guide for Linux Instances.
 */
class SpotCapacityRebalance private constructor(builder: BuilderImpl) {
    /**
     * The replacement strategy to use. Only available for fleets of type
     * maintain. You must specify a value, otherwise you get an error.
     * To allow Spot Fleet to launch a replacement Spot Instance when an instance rebalance
     * notification is emitted for a Spot Instance in the fleet, specify
     * launch.
     * When a replacement instance is launched, the instance marked for rebalance is not
     * automatically terminated. You can terminate it, or you can leave it running. You are
     * charged for all instances while they are running.
     */
    val replacementStrategy: ReplacementStrategy? = builder.replacementStrategy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SpotCapacityRebalance = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SpotCapacityRebalance(")
        append("replacementStrategy=$replacementStrategy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = replacementStrategy?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SpotCapacityRebalance

        if (replacementStrategy != other.replacementStrategy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SpotCapacityRebalance = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SpotCapacityRebalance
        /**
         * The replacement strategy to use. Only available for fleets of type
         * maintain. You must specify a value, otherwise you get an error.
         * To allow Spot Fleet to launch a replacement Spot Instance when an instance rebalance
         * notification is emitted for a Spot Instance in the fleet, specify
         * launch.
         * When a replacement instance is launched, the instance marked for rebalance is not
         * automatically terminated. You can terminate it, or you can leave it running. You are
         * charged for all instances while they are running.
         */
        fun replacementStrategy(replacementStrategy: ReplacementStrategy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The replacement strategy to use. Only available for fleets of type
         * maintain. You must specify a value, otherwise you get an error.
         * To allow Spot Fleet to launch a replacement Spot Instance when an instance rebalance
         * notification is emitted for a Spot Instance in the fleet, specify
         * launch.
         * When a replacement instance is launched, the instance marked for rebalance is not
         * automatically terminated. You can terminate it, or you can leave it running. You are
         * charged for all instances while they are running.
         */
        var replacementStrategy: ReplacementStrategy?

        fun build(): SpotCapacityRebalance
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var replacementStrategy: ReplacementStrategy? = null

        constructor(x: SpotCapacityRebalance) : this() {
            this.replacementStrategy = x.replacementStrategy
        }

        override fun build(): SpotCapacityRebalance = SpotCapacityRebalance(this)
        override fun replacementStrategy(replacementStrategy: ReplacementStrategy): FluentBuilder = apply { this.replacementStrategy = replacementStrategy }
    }
}
