// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the data feed for a Spot Instance.
 */
class SpotDatafeedSubscription private constructor(builder: BuilderImpl) {
    /**
     * The name of the Amazon S3 bucket where the Spot Instance data feed is located.
     */
    val bucket: String? = builder.bucket
    /**
     * The fault codes for the Spot Instance request, if any.
     */
    val fault: SpotInstanceStateFault? = builder.fault
    /**
     * The Amazon Web Services account ID of the account.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The prefix for the data feed files.
     */
    val prefix: String? = builder.prefix
    /**
     * The state of the Spot Instance data feed subscription.
     */
    val state: DatafeedSubscriptionState? = builder.state

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SpotDatafeedSubscription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SpotDatafeedSubscription(")
        append("bucket=$bucket,")
        append("fault=$fault,")
        append("ownerId=$ownerId,")
        append("prefix=$prefix,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (fault?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SpotDatafeedSubscription

        if (bucket != other.bucket) return false
        if (fault != other.fault) return false
        if (ownerId != other.ownerId) return false
        if (prefix != other.prefix) return false
        if (state != other.state) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SpotDatafeedSubscription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SpotDatafeedSubscription
        /**
         * The name of the Amazon S3 bucket where the Spot Instance data feed is located.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * The fault codes for the Spot Instance request, if any.
         */
        fun fault(fault: SpotInstanceStateFault): FluentBuilder
        /**
         * The Amazon Web Services account ID of the account.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The prefix for the data feed files.
         */
        fun prefix(prefix: String): FluentBuilder
        /**
         * The state of the Spot Instance data feed subscription.
         */
        fun state(state: DatafeedSubscriptionState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the Amazon S3 bucket where the Spot Instance data feed is located.
         */
        var bucket: String?
        /**
         * The fault codes for the Spot Instance request, if any.
         */
        var fault: SpotInstanceStateFault?
        /**
         * The Amazon Web Services account ID of the account.
         */
        var ownerId: String?
        /**
         * The prefix for the data feed files.
         */
        var prefix: String?
        /**
         * The state of the Spot Instance data feed subscription.
         */
        var state: DatafeedSubscriptionState?

        fun build(): SpotDatafeedSubscription
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotInstanceStateFault] inside the given [block]
         */
        fun fault(block: SpotInstanceStateFault.DslBuilder.() -> kotlin.Unit) {
            this.fault = SpotInstanceStateFault.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucket: String? = null
        override var fault: SpotInstanceStateFault? = null
        override var ownerId: String? = null
        override var prefix: String? = null
        override var state: DatafeedSubscriptionState? = null

        constructor(x: SpotDatafeedSubscription) : this() {
            this.bucket = x.bucket
            this.fault = x.fault
            this.ownerId = x.ownerId
            this.prefix = x.prefix
            this.state = x.state
        }

        override fun build(): SpotDatafeedSubscription = SpotDatafeedSubscription(this)
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun fault(fault: SpotInstanceStateFault): FluentBuilder = apply { this.fault = fault }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun prefix(prefix: String): FluentBuilder = apply { this.prefix = prefix }
        override fun state(state: DatafeedSubscriptionState): FluentBuilder = apply { this.state = state }
    }
}
