// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the launch specification for one or more Spot Instances. If you include
 * On-Demand capacity in your fleet request or want to specify an EFA network device, you
 * can't use SpotFleetLaunchSpecification; you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig.
 */
class SpotFleetLaunchSpecification private constructor(builder: BuilderImpl) {
    /**
     * Deprecated.
     */
    val addressingType: String? = builder.addressingType
    /**
     * One or more block devices that are mapped to the Spot Instances. You can't specify both
     * a snapshot ID and an encryption value. This is because only blank volumes can be
     * encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its
     * encryption status is used for the volume encryption status.
     */
    val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * Default: false
     */
    val ebsOptimized: Boolean? = builder.ebsOptimized
    /**
     * The IAM instance profile.
     */
    val iamInstanceProfile: IamInstanceProfileSpecification? = builder.iamInstanceProfile
    /**
     * The ID of the AMI.
     */
    val imageId: String? = builder.imageId
    /**
     * The instance type.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * The ID of the kernel.
     */
    val kernelId: String? = builder.kernelId
    /**
     * The name of the key pair.
     */
    val keyName: String? = builder.keyName
    /**
     * Enable or disable monitoring for the instances.
     */
    val monitoring: SpotFleetMonitoring? = builder.monitoring
    /**
     * One or more network interfaces. If you specify a network interface, you must specify
     * subnet IDs and security group IDs using the network interface.
     * SpotFleetLaunchSpecification currently does not support Elastic Fabric Adapter (EFA). To specify an EFA, you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig.
     */
    val networkInterfaces: List<InstanceNetworkInterfaceSpecification>? = builder.networkInterfaces
    /**
     * The placement information.
     */
    val placement: SpotPlacement? = builder.placement
    /**
     * The ID of the RAM disk. Some kernels require additional drivers at launch. Check the kernel
     * requirements for information about whether you need to specify a RAM disk. To find kernel
     * requirements, refer to the Amazon Web Services Resource Center and search for the kernel ID.
     */
    val ramdiskId: String? = builder.ramdiskId
    /**
     * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
     */
    val securityGroups: List<GroupIdentifier>? = builder.securityGroups
    /**
     * The maximum price per unit hour that you are willing to pay for a Spot Instance.
     * If this value is not specified, the default is the Spot price specified for the fleet.
     * To determine the Spot price per unit hour, divide the Spot price by the
     * value of WeightedCapacity.
     */
    val spotPrice: String? = builder.spotPrice
    /**
     * The IDs of the subnets in which to launch the instances. To specify multiple subnets, separate
     * them using commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
     */
    val subnetId: String? = builder.subnetId
    /**
     * The tags to apply during creation.
     */
    val tagSpecifications: List<SpotFleetTagSpecification>? = builder.tagSpecifications
    /**
     * The Base64-encoded user data that instances use when starting up.
     */
    val userData: String? = builder.userData
    /**
     * The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
     * If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.
     */
    val weightedCapacity: Double? = builder.weightedCapacity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SpotFleetLaunchSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SpotFleetLaunchSpecification(")
        append("addressingType=$addressingType,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("ebsOptimized=$ebsOptimized,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("placement=$placement,")
        append("ramdiskId=$ramdiskId,")
        append("securityGroups=$securityGroups,")
        append("spotPrice=$spotPrice,")
        append("subnetId=$subnetId,")
        append("tagSpecifications=$tagSpecifications,")
        append("userData=$userData,")
        append("weightedCapacity=$weightedCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressingType?.hashCode() ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (spotPrice?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        result = 31 * result + (weightedCapacity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SpotFleetLaunchSpecification

        if (addressingType != other.addressingType) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (placement != other.placement) return false
        if (ramdiskId != other.ramdiskId) return false
        if (securityGroups != other.securityGroups) return false
        if (spotPrice != other.spotPrice) return false
        if (subnetId != other.subnetId) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (userData != other.userData) return false
        if (weightedCapacity != other.weightedCapacity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SpotFleetLaunchSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SpotFleetLaunchSpecification
        /**
         * Deprecated.
         */
        fun addressingType(addressingType: String): FluentBuilder
        /**
         * One or more block devices that are mapped to the Spot Instances. You can't specify both
         * a snapshot ID and an encryption value. This is because only blank volumes can be
         * encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its
         * encryption status is used for the volume encryption status.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<BlockDeviceMapping>): FluentBuilder
        /**
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         * Default: false
         */
        fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder
        /**
         * The IAM instance profile.
         */
        fun iamInstanceProfile(iamInstanceProfile: IamInstanceProfileSpecification): FluentBuilder
        /**
         * The ID of the AMI.
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * The instance type.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * The ID of the kernel.
         */
        fun kernelId(kernelId: String): FluentBuilder
        /**
         * The name of the key pair.
         */
        fun keyName(keyName: String): FluentBuilder
        /**
         * Enable or disable monitoring for the instances.
         */
        fun monitoring(monitoring: SpotFleetMonitoring): FluentBuilder
        /**
         * One or more network interfaces. If you specify a network interface, you must specify
         * subnet IDs and security group IDs using the network interface.
         * SpotFleetLaunchSpecification currently does not support Elastic Fabric Adapter (EFA). To specify an EFA, you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig.
         */
        fun networkInterfaces(networkInterfaces: List<InstanceNetworkInterfaceSpecification>): FluentBuilder
        /**
         * The placement information.
         */
        fun placement(placement: SpotPlacement): FluentBuilder
        /**
         * The ID of the RAM disk. Some kernels require additional drivers at launch. Check the kernel
         * requirements for information about whether you need to specify a RAM disk. To find kernel
         * requirements, refer to the Amazon Web Services Resource Center and search for the kernel ID.
         */
        fun ramdiskId(ramdiskId: String): FluentBuilder
        /**
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
         */
        fun securityGroups(securityGroups: List<GroupIdentifier>): FluentBuilder
        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         * If this value is not specified, the default is the Spot price specified for the fleet.
         * To determine the Spot price per unit hour, divide the Spot price by the
         * value of WeightedCapacity.
         */
        fun spotPrice(spotPrice: String): FluentBuilder
        /**
         * The IDs of the subnets in which to launch the instances. To specify multiple subnets, separate
         * them using commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The tags to apply during creation.
         */
        fun tagSpecifications(tagSpecifications: List<SpotFleetTagSpecification>): FluentBuilder
        /**
         * The Base64-encoded user data that instances use when starting up.
         */
        fun userData(userData: String): FluentBuilder
        /**
         * The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
         * If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.
         */
        fun weightedCapacity(weightedCapacity: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Deprecated.
         */
        var addressingType: String?
        /**
         * One or more block devices that are mapped to the Spot Instances. You can't specify both
         * a snapshot ID and an encryption value. This is because only blank volumes can be
         * encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its
         * encryption status is used for the volume encryption status.
         */
        var blockDeviceMappings: List<BlockDeviceMapping>?
        /**
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         * Default: false
         */
        var ebsOptimized: Boolean?
        /**
         * The IAM instance profile.
         */
        var iamInstanceProfile: IamInstanceProfileSpecification?
        /**
         * The ID of the AMI.
         */
        var imageId: String?
        /**
         * The instance type.
         */
        var instanceType: InstanceType?
        /**
         * The ID of the kernel.
         */
        var kernelId: String?
        /**
         * The name of the key pair.
         */
        var keyName: String?
        /**
         * Enable or disable monitoring for the instances.
         */
        var monitoring: SpotFleetMonitoring?
        /**
         * One or more network interfaces. If you specify a network interface, you must specify
         * subnet IDs and security group IDs using the network interface.
         * SpotFleetLaunchSpecification currently does not support Elastic Fabric Adapter (EFA). To specify an EFA, you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig.
         */
        var networkInterfaces: List<InstanceNetworkInterfaceSpecification>?
        /**
         * The placement information.
         */
        var placement: SpotPlacement?
        /**
         * The ID of the RAM disk. Some kernels require additional drivers at launch. Check the kernel
         * requirements for information about whether you need to specify a RAM disk. To find kernel
         * requirements, refer to the Amazon Web Services Resource Center and search for the kernel ID.
         */
        var ramdiskId: String?
        /**
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
         */
        var securityGroups: List<GroupIdentifier>?
        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         * If this value is not specified, the default is the Spot price specified for the fleet.
         * To determine the Spot price per unit hour, divide the Spot price by the
         * value of WeightedCapacity.
         */
        var spotPrice: String?
        /**
         * The IDs of the subnets in which to launch the instances. To specify multiple subnets, separate
         * them using commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
         */
        var subnetId: String?
        /**
         * The tags to apply during creation.
         */
        var tagSpecifications: List<SpotFleetTagSpecification>?
        /**
         * The Base64-encoded user data that instances use when starting up.
         */
        var userData: String?
        /**
         * The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
         * If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.
         */
        var weightedCapacity: Double?

        fun build(): SpotFleetLaunchSpecification
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification] inside the given [block]
         */
        fun iamInstanceProfile(block: IamInstanceProfileSpecification.DslBuilder.() -> kotlin.Unit) {
            this.iamInstanceProfile = IamInstanceProfileSpecification.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotFleetMonitoring] inside the given [block]
         */
        fun monitoring(block: SpotFleetMonitoring.DslBuilder.() -> kotlin.Unit) {
            this.monitoring = SpotFleetMonitoring.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotPlacement] inside the given [block]
         */
        fun placement(block: SpotPlacement.DslBuilder.() -> kotlin.Unit) {
            this.placement = SpotPlacement.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var addressingType: String? = null
        override var blockDeviceMappings: List<BlockDeviceMapping>? = null
        override var ebsOptimized: Boolean? = null
        override var iamInstanceProfile: IamInstanceProfileSpecification? = null
        override var imageId: String? = null
        override var instanceType: InstanceType? = null
        override var kernelId: String? = null
        override var keyName: String? = null
        override var monitoring: SpotFleetMonitoring? = null
        override var networkInterfaces: List<InstanceNetworkInterfaceSpecification>? = null
        override var placement: SpotPlacement? = null
        override var ramdiskId: String? = null
        override var securityGroups: List<GroupIdentifier>? = null
        override var spotPrice: String? = null
        override var subnetId: String? = null
        override var tagSpecifications: List<SpotFleetTagSpecification>? = null
        override var userData: String? = null
        override var weightedCapacity: Double? = null

        constructor(x: SpotFleetLaunchSpecification) : this() {
            this.addressingType = x.addressingType
            this.blockDeviceMappings = x.blockDeviceMappings
            this.ebsOptimized = x.ebsOptimized
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.placement = x.placement
            this.ramdiskId = x.ramdiskId
            this.securityGroups = x.securityGroups
            this.spotPrice = x.spotPrice
            this.subnetId = x.subnetId
            this.tagSpecifications = x.tagSpecifications
            this.userData = x.userData
            this.weightedCapacity = x.weightedCapacity
        }

        override fun build(): SpotFleetLaunchSpecification = SpotFleetLaunchSpecification(this)
        override fun addressingType(addressingType: String): FluentBuilder = apply { this.addressingType = addressingType }
        override fun blockDeviceMappings(blockDeviceMappings: List<BlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder = apply { this.ebsOptimized = ebsOptimized }
        override fun iamInstanceProfile(iamInstanceProfile: IamInstanceProfileSpecification): FluentBuilder = apply { this.iamInstanceProfile = iamInstanceProfile }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun kernelId(kernelId: String): FluentBuilder = apply { this.kernelId = kernelId }
        override fun keyName(keyName: String): FluentBuilder = apply { this.keyName = keyName }
        override fun monitoring(monitoring: SpotFleetMonitoring): FluentBuilder = apply { this.monitoring = monitoring }
        override fun networkInterfaces(networkInterfaces: List<InstanceNetworkInterfaceSpecification>): FluentBuilder = apply { this.networkInterfaces = networkInterfaces }
        override fun placement(placement: SpotPlacement): FluentBuilder = apply { this.placement = placement }
        override fun ramdiskId(ramdiskId: String): FluentBuilder = apply { this.ramdiskId = ramdiskId }
        override fun securityGroups(securityGroups: List<GroupIdentifier>): FluentBuilder = apply { this.securityGroups = securityGroups }
        override fun spotPrice(spotPrice: String): FluentBuilder = apply { this.spotPrice = spotPrice }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tagSpecifications(tagSpecifications: List<SpotFleetTagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun userData(userData: String): FluentBuilder = apply { this.userData = userData }
        override fun weightedCapacity(weightedCapacity: Double): FluentBuilder = apply { this.weightedCapacity = weightedCapacity }
    }
}
