// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Spot Fleet request.
 */
class SpotFleetRequestConfig private constructor(builder: BuilderImpl) {
    /**
     * The progress of the Spot Fleet request.
     * If there is an error, the status is error.
     * After all requests are placed, the status is pending_fulfillment.
     * If the size of the fleet is equal to or greater than its target capacity, the status is fulfilled.
     * If the size of the fleet is decreased, the status is pending_termination
     * while Spot Instances are terminating.
     */
    val activityStatus: ActivityStatus? = builder.activityStatus
    /**
     * The creation date and time of the request.
     */
    val createTime: Instant? = builder.createTime
    /**
     * The configuration of the Spot Fleet request.
     */
    val spotFleetRequestConfig: SpotFleetRequestConfigData? = builder.spotFleetRequestConfig
    /**
     * The ID of the Spot Fleet request.
     */
    val spotFleetRequestId: String? = builder.spotFleetRequestId
    /**
     * The state of the Spot Fleet request.
     */
    val spotFleetRequestState: BatchState? = builder.spotFleetRequestState
    /**
     * The tags for a Spot Fleet resource.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SpotFleetRequestConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SpotFleetRequestConfig(")
        append("activityStatus=$activityStatus,")
        append("createTime=$createTime,")
        append("spotFleetRequestConfig=$spotFleetRequestConfig,")
        append("spotFleetRequestId=$spotFleetRequestId,")
        append("spotFleetRequestState=$spotFleetRequestState,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityStatus?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (spotFleetRequestConfig?.hashCode() ?: 0)
        result = 31 * result + (spotFleetRequestId?.hashCode() ?: 0)
        result = 31 * result + (spotFleetRequestState?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SpotFleetRequestConfig

        if (activityStatus != other.activityStatus) return false
        if (createTime != other.createTime) return false
        if (spotFleetRequestConfig != other.spotFleetRequestConfig) return false
        if (spotFleetRequestId != other.spotFleetRequestId) return false
        if (spotFleetRequestState != other.spotFleetRequestState) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SpotFleetRequestConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SpotFleetRequestConfig
        /**
         * The progress of the Spot Fleet request.
         * If there is an error, the status is error.
         * After all requests are placed, the status is pending_fulfillment.
         * If the size of the fleet is equal to or greater than its target capacity, the status is fulfilled.
         * If the size of the fleet is decreased, the status is pending_termination
         * while Spot Instances are terminating.
         */
        fun activityStatus(activityStatus: ActivityStatus): FluentBuilder
        /**
         * The creation date and time of the request.
         */
        fun createTime(createTime: Instant): FluentBuilder
        /**
         * The configuration of the Spot Fleet request.
         */
        fun spotFleetRequestConfig(spotFleetRequestConfig: SpotFleetRequestConfigData): FluentBuilder
        /**
         * The ID of the Spot Fleet request.
         */
        fun spotFleetRequestId(spotFleetRequestId: String): FluentBuilder
        /**
         * The state of the Spot Fleet request.
         */
        fun spotFleetRequestState(spotFleetRequestState: BatchState): FluentBuilder
        /**
         * The tags for a Spot Fleet resource.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The progress of the Spot Fleet request.
         * If there is an error, the status is error.
         * After all requests are placed, the status is pending_fulfillment.
         * If the size of the fleet is equal to or greater than its target capacity, the status is fulfilled.
         * If the size of the fleet is decreased, the status is pending_termination
         * while Spot Instances are terminating.
         */
        var activityStatus: ActivityStatus?
        /**
         * The creation date and time of the request.
         */
        var createTime: Instant?
        /**
         * The configuration of the Spot Fleet request.
         */
        var spotFleetRequestConfig: SpotFleetRequestConfigData?
        /**
         * The ID of the Spot Fleet request.
         */
        var spotFleetRequestId: String?
        /**
         * The state of the Spot Fleet request.
         */
        var spotFleetRequestState: BatchState?
        /**
         * The tags for a Spot Fleet resource.
         */
        var tags: List<Tag>?

        fun build(): SpotFleetRequestConfig
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotFleetRequestConfigData] inside the given [block]
         */
        fun spotFleetRequestConfig(block: SpotFleetRequestConfigData.DslBuilder.() -> kotlin.Unit) {
            this.spotFleetRequestConfig = SpotFleetRequestConfigData.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activityStatus: ActivityStatus? = null
        override var createTime: Instant? = null
        override var spotFleetRequestConfig: SpotFleetRequestConfigData? = null
        override var spotFleetRequestId: String? = null
        override var spotFleetRequestState: BatchState? = null
        override var tags: List<Tag>? = null

        constructor(x: SpotFleetRequestConfig) : this() {
            this.activityStatus = x.activityStatus
            this.createTime = x.createTime
            this.spotFleetRequestConfig = x.spotFleetRequestConfig
            this.spotFleetRequestId = x.spotFleetRequestId
            this.spotFleetRequestState = x.spotFleetRequestState
            this.tags = x.tags
        }

        override fun build(): SpotFleetRequestConfig = SpotFleetRequestConfig(this)
        override fun activityStatus(activityStatus: ActivityStatus): FluentBuilder = apply { this.activityStatus = activityStatus }
        override fun createTime(createTime: Instant): FluentBuilder = apply { this.createTime = createTime }
        override fun spotFleetRequestConfig(spotFleetRequestConfig: SpotFleetRequestConfigData): FluentBuilder = apply { this.spotFleetRequestConfig = spotFleetRequestConfig }
        override fun spotFleetRequestId(spotFleetRequestId: String): FluentBuilder = apply { this.spotFleetRequestId = spotFleetRequestId }
        override fun spotFleetRequestState(spotFleetRequestState: BatchState): FluentBuilder = apply { this.spotFleetRequestState = spotFleetRequestState }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
