// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the configuration of a Spot Fleet request.
 */
class SpotFleetRequestConfigData private constructor(builder: BuilderImpl) {
    /**
     * Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by
     * the Spot Fleet request.
     * If the allocation strategy is lowestPrice, Spot Fleet launches instances from
     * the Spot Instance pools with the lowest price. This is the default allocation strategy.
     * If the allocation strategy is diversified, Spot Fleet launches instances from
     * all the Spot Instance pools that you specify.
     * If the allocation strategy is capacityOptimized (recommended), Spot Fleet
     * launches instances from Spot Instance pools with optimal capacity for the number of instances
     * that are launching. To give certain instance types a higher chance of launching first,
     * use capacityOptimizedPrioritized. Set a priority for each instance type by
     * using the Priority parameter for LaunchTemplateOverrides. You
     * can assign the same priority to different LaunchTemplateOverrides. EC2
     * implements the priorities on a best-effort basis, but optimizes for capacity first.
     * capacityOptimizedPrioritized is supported only if your Spot Fleet uses a
     * launch template. Note that if the OnDemandAllocationStrategy is set to
     * prioritized, the same priority is applied when fulfilling On-Demand
     * capacity.
     */
    val allocationStrategy: AllocationStrategy? = builder.allocationStrategy
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of your
     * listings. This helps to avoid duplicate listings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Reserved.
     */
    val context: String? = builder.context
    /**
     * Indicates whether running Spot Instances should be terminated if you decrease the
     * target capacity of the Spot Fleet request below the current size of the Spot
     * Fleet.
     */
    val excessCapacityTerminationPolicy: ExcessCapacityTerminationPolicy? = builder.excessCapacityTerminationPolicy
    /**
     * The number of units fulfilled by this request compared to the set target capacity. You
     * cannot set this value.
     */
    val fulfilledCapacity: Double? = builder.fulfilledCapacity
    /**
     * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
     * grants the Spot Fleet the permission to request, launch, terminate, and tag instances on
     * your behalf. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites">Spot
     * Fleet prerequisites in the Amazon EC2 User Guide for Linux Instances. Spot Fleet
     * can terminate Spot Instances on your behalf when you cancel its Spot Fleet request using
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests">CancelSpotFleetRequests or when the Spot Fleet request expires, if you set
     * TerminateInstancesWithExpiration.
     */
    val iamFleetRole: String? = builder.iamFleetRole
    /**
     * The behavior when a Spot Instance is interrupted. The default is
     * terminate.
     */
    val instanceInterruptionBehavior: InstanceInterruptionBehavior? = builder.instanceInterruptionBehavior
    /**
     * The number of Spot pools across which to allocate your target Spot capacity. Valid
     * only when Spot AllocationStrategy is set to
     * lowest-price. Spot Fleet selects the cheapest Spot pools and evenly
     * allocates your target Spot capacity across the number of Spot pools that you
     * specify.
     * Note that Spot Fleet attempts to draw Spot Instances from the number of pools that you specify on a
     * best effort basis. If a pool runs out of Spot capacity before fulfilling your target
     * capacity, Spot Fleet will continue to fulfill your request by drawing from the next cheapest
     * pool. To ensure that your target capacity is met, you might receive Spot Instances from more than
     * the number of pools that you specified. Similarly, if most of the pools have no Spot
     * capacity, you might receive your full target capacity from fewer than the number of
     * pools that you specified.
     */
    val instancePoolsToUseCount: Int? = builder.instancePoolsToUseCount
    /**
     * The launch specifications for the Spot Fleet request. If you specify
     * LaunchSpecifications, you can't specify
     * LaunchTemplateConfigs. If you include On-Demand capacity in your
     * request, you must use LaunchTemplateConfigs.
     */
    val launchSpecifications: List<SpotFleetLaunchSpecification>? = builder.launchSpecifications
    /**
     * The launch template and overrides. If you specify LaunchTemplateConfigs,
     * you can't specify LaunchSpecifications. If you include On-Demand capacity
     * in your request, you must use LaunchTemplateConfigs.
     */
    val launchTemplateConfigs: List<LaunchTemplateConfig>? = builder.launchTemplateConfigs
    /**
     * One or more Classic Load Balancers and target groups to attach to the Spot Fleet
     * request. Spot Fleet registers the running Spot Instances with the specified Classic Load
     * Balancers and target groups.
     * With Network Load Balancers, Spot Fleet cannot register instances that have the
     * following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2,
     * M3, and T1.
     */
    val loadBalancersConfig: LoadBalancersConfig? = builder.loadBalancersConfig
    /**
     * The order of the launch template overrides to use in fulfilling On-Demand capacity. If
     * you specify lowestPrice, Spot Fleet uses price to determine the order, launching
     * the lowest price first. If you specify prioritized, Spot Fleet uses the priority
     * that you assign to each Spot Fleet launch template override, launching the highest priority
     * first. If you do not specify a value, Spot Fleet defaults to lowestPrice.
     */
    val onDemandAllocationStrategy: OnDemandAllocationStrategy? = builder.onDemandAllocationStrategy
    /**
     * The number of On-Demand units fulfilled by this request compared to the set target
     * On-Demand capacity.
     */
    val onDemandFulfilledCapacity: Double? = builder.onDemandFulfilledCapacity
    /**
     * The maximum amount per hour for On-Demand Instances that you're willing to pay. You
     * can use the onDemandMaxTotalPrice parameter, the
     * spotMaxTotalPrice parameter, or both parameters to ensure that your
     * fleet cost does not exceed your budget. If you set a maximum price per hour for the
     * On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances until it reaches the
     * maximum amount you're willing to pay. When the maximum amount you're willing to pay is
     * reached, the fleet stops launching instances even if it hasn’t met the target
     * capacity.
     */
    val onDemandMaxTotalPrice: String? = builder.onDemandMaxTotalPrice
    /**
     * The number of On-Demand units to request. You can choose to set the target capacity in
     * terms of instances or a performance characteristic that is important to your application
     * workload, such as vCPUs, memory, or I/O. If the request type is maintain,
     * you can specify a target capacity of 0 and add capacity later.
     */
    val onDemandTargetCapacity: Int? = builder.onDemandTargetCapacity
    /**
     * Indicates whether Spot Fleet should replace unhealthy instances.
     */
    val replaceUnhealthyInstances: Boolean? = builder.replaceUnhealthyInstances
    /**
     * The strategies for managing your Spot Instances that are at an elevated risk of being
     * interrupted.
     */
    val spotMaintenanceStrategies: SpotMaintenanceStrategies? = builder.spotMaintenanceStrategies
    /**
     * The maximum amount per hour for Spot Instances that you're willing to pay. You can use
     * the spotdMaxTotalPrice parameter, the onDemandMaxTotalPrice
     * parameter, or both parameters to ensure that your fleet cost does not exceed your
     * budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances in your request,
     * Spot Fleet will launch instances until it reaches the maximum amount you're willing to pay.
     * When the maximum amount you're willing to pay is reached, the fleet stops launching
     * instances even if it hasn’t met the target capacity.
     */
    val spotMaxTotalPrice: String? = builder.spotMaxTotalPrice
    /**
     * The maximum price per unit hour that you are willing to pay for a Spot Instance. The
     * default is the On-Demand price.
     */
    val spotPrice: String? = builder.spotPrice
    /**
     * The key-value pair for tagging the Spot Fleet request on creation. The value for
     * ResourceType must be spot-fleet-request, otherwise the
     * Spot Fleet request fails. To tag instances at launch, specify the tags in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch
     * template (valid only if you use LaunchTemplateConfigs) or in
     * the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">
     * SpotFleetTagSpecification
     * (valid only if you use
     * LaunchSpecifications). For information about tagging after launch, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your Resources.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The number of units to request for the Spot Fleet. You can choose to set the target
     * capacity in terms of instances or a performance characteristic that is important to your
     * application workload, such as vCPUs, memory, or I/O. If the request type is
     * maintain, you can specify a target capacity of 0 and add capacity
     * later.
     */
    val targetCapacity: Int? = builder.targetCapacity
    /**
     * Indicates whether running Spot Instances are terminated when the Spot Fleet request
     * expires.
     */
    val terminateInstancesWithExpiration: Boolean? = builder.terminateInstancesWithExpiration
    /**
     * The type of request. Indicates whether the Spot Fleet only requests the target
     * capacity or also attempts to maintain it. When this value is request, the
     * Spot Fleet only places the required requests. It does not attempt to replenish Spot
     * Instances if capacity is diminished, nor does it submit requests in alternative Spot
     * pools if capacity is not available. When this value is maintain, the Spot
     * Fleet maintains the target capacity. The Spot Fleet places the required requests to meet
     * capacity and automatically replenishes any interrupted instances. Default:
     * maintain. instant is listed but is not used by Spot
     * Fleet.
     */
    val type: FleetType? = builder.type
    /**
     * The start date and time of the request, in UTC format
     * (YYYY-MM-DDTHH:MM:SSZ).
     * By default, Amazon EC2 starts fulfilling the request immediately.
     */
    val validFrom: Instant? = builder.validFrom
    /**
     * The end date and time of the request, in UTC format
     * (YYYY-MM-DDTHH:MM:SSZ).
     * After the end date and time, no new Spot Instance requests are placed or able to fulfill
     * the request. If no value is specified, the Spot Fleet request remains until you cancel
     * it.
     */
    val validUntil: Instant? = builder.validUntil

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SpotFleetRequestConfigData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SpotFleetRequestConfigData(")
        append("allocationStrategy=$allocationStrategy,")
        append("clientToken=$clientToken,")
        append("context=$context,")
        append("excessCapacityTerminationPolicy=$excessCapacityTerminationPolicy,")
        append("fulfilledCapacity=$fulfilledCapacity,")
        append("iamFleetRole=$iamFleetRole,")
        append("instanceInterruptionBehavior=$instanceInterruptionBehavior,")
        append("instancePoolsToUseCount=$instancePoolsToUseCount,")
        append("launchSpecifications=$launchSpecifications,")
        append("launchTemplateConfigs=$launchTemplateConfigs,")
        append("loadBalancersConfig=$loadBalancersConfig,")
        append("onDemandAllocationStrategy=$onDemandAllocationStrategy,")
        append("onDemandFulfilledCapacity=$onDemandFulfilledCapacity,")
        append("onDemandMaxTotalPrice=$onDemandMaxTotalPrice,")
        append("onDemandTargetCapacity=$onDemandTargetCapacity,")
        append("replaceUnhealthyInstances=$replaceUnhealthyInstances,")
        append("spotMaintenanceStrategies=$spotMaintenanceStrategies,")
        append("spotMaxTotalPrice=$spotMaxTotalPrice,")
        append("spotPrice=$spotPrice,")
        append("tagSpecifications=$tagSpecifications,")
        append("targetCapacity=$targetCapacity,")
        append("terminateInstancesWithExpiration=$terminateInstancesWithExpiration,")
        append("type=$type,")
        append("validFrom=$validFrom,")
        append("validUntil=$validUntil)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationStrategy?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (excessCapacityTerminationPolicy?.hashCode() ?: 0)
        result = 31 * result + (fulfilledCapacity?.hashCode() ?: 0)
        result = 31 * result + (iamFleetRole?.hashCode() ?: 0)
        result = 31 * result + (instanceInterruptionBehavior?.hashCode() ?: 0)
        result = 31 * result + (instancePoolsToUseCount ?: 0)
        result = 31 * result + (launchSpecifications?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateConfigs?.hashCode() ?: 0)
        result = 31 * result + (loadBalancersConfig?.hashCode() ?: 0)
        result = 31 * result + (onDemandAllocationStrategy?.hashCode() ?: 0)
        result = 31 * result + (onDemandFulfilledCapacity?.hashCode() ?: 0)
        result = 31 * result + (onDemandMaxTotalPrice?.hashCode() ?: 0)
        result = 31 * result + (onDemandTargetCapacity ?: 0)
        result = 31 * result + (replaceUnhealthyInstances?.hashCode() ?: 0)
        result = 31 * result + (spotMaintenanceStrategies?.hashCode() ?: 0)
        result = 31 * result + (spotMaxTotalPrice?.hashCode() ?: 0)
        result = 31 * result + (spotPrice?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (targetCapacity ?: 0)
        result = 31 * result + (terminateInstancesWithExpiration?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (validFrom?.hashCode() ?: 0)
        result = 31 * result + (validUntil?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SpotFleetRequestConfigData

        if (allocationStrategy != other.allocationStrategy) return false
        if (clientToken != other.clientToken) return false
        if (context != other.context) return false
        if (excessCapacityTerminationPolicy != other.excessCapacityTerminationPolicy) return false
        if (fulfilledCapacity != other.fulfilledCapacity) return false
        if (iamFleetRole != other.iamFleetRole) return false
        if (instanceInterruptionBehavior != other.instanceInterruptionBehavior) return false
        if (instancePoolsToUseCount != other.instancePoolsToUseCount) return false
        if (launchSpecifications != other.launchSpecifications) return false
        if (launchTemplateConfigs != other.launchTemplateConfigs) return false
        if (loadBalancersConfig != other.loadBalancersConfig) return false
        if (onDemandAllocationStrategy != other.onDemandAllocationStrategy) return false
        if (onDemandFulfilledCapacity != other.onDemandFulfilledCapacity) return false
        if (onDemandMaxTotalPrice != other.onDemandMaxTotalPrice) return false
        if (onDemandTargetCapacity != other.onDemandTargetCapacity) return false
        if (replaceUnhealthyInstances != other.replaceUnhealthyInstances) return false
        if (spotMaintenanceStrategies != other.spotMaintenanceStrategies) return false
        if (spotMaxTotalPrice != other.spotMaxTotalPrice) return false
        if (spotPrice != other.spotPrice) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (targetCapacity != other.targetCapacity) return false
        if (terminateInstancesWithExpiration != other.terminateInstancesWithExpiration) return false
        if (type != other.type) return false
        if (validFrom != other.validFrom) return false
        if (validUntil != other.validUntil) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SpotFleetRequestConfigData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SpotFleetRequestConfigData
        /**
         * Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by
         * the Spot Fleet request.
         * If the allocation strategy is lowestPrice, Spot Fleet launches instances from
         * the Spot Instance pools with the lowest price. This is the default allocation strategy.
         * If the allocation strategy is diversified, Spot Fleet launches instances from
         * all the Spot Instance pools that you specify.
         * If the allocation strategy is capacityOptimized (recommended), Spot Fleet
         * launches instances from Spot Instance pools with optimal capacity for the number of instances
         * that are launching. To give certain instance types a higher chance of launching first,
         * use capacityOptimizedPrioritized. Set a priority for each instance type by
         * using the Priority parameter for LaunchTemplateOverrides. You
         * can assign the same priority to different LaunchTemplateOverrides. EC2
         * implements the priorities on a best-effort basis, but optimizes for capacity first.
         * capacityOptimizedPrioritized is supported only if your Spot Fleet uses a
         * launch template. Note that if the OnDemandAllocationStrategy is set to
         * prioritized, the same priority is applied when fulfilling On-Demand
         * capacity.
         */
        fun allocationStrategy(allocationStrategy: AllocationStrategy): FluentBuilder
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of your
         * listings. This helps to avoid duplicate listings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Reserved.
         */
        fun context(context: String): FluentBuilder
        /**
         * Indicates whether running Spot Instances should be terminated if you decrease the
         * target capacity of the Spot Fleet request below the current size of the Spot
         * Fleet.
         */
        fun excessCapacityTerminationPolicy(excessCapacityTerminationPolicy: ExcessCapacityTerminationPolicy): FluentBuilder
        /**
         * The number of units fulfilled by this request compared to the set target capacity. You
         * cannot set this value.
         */
        fun fulfilledCapacity(fulfilledCapacity: Double): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
         * grants the Spot Fleet the permission to request, launch, terminate, and tag instances on
         * your behalf. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites">Spot
         * Fleet prerequisites in the Amazon EC2 User Guide for Linux Instances. Spot Fleet
         * can terminate Spot Instances on your behalf when you cancel its Spot Fleet request using
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests">CancelSpotFleetRequests or when the Spot Fleet request expires, if you set
         * TerminateInstancesWithExpiration.
         */
        fun iamFleetRole(iamFleetRole: String): FluentBuilder
        /**
         * The behavior when a Spot Instance is interrupted. The default is
         * terminate.
         */
        fun instanceInterruptionBehavior(instanceInterruptionBehavior: InstanceInterruptionBehavior): FluentBuilder
        /**
         * The number of Spot pools across which to allocate your target Spot capacity. Valid
         * only when Spot AllocationStrategy is set to
         * lowest-price. Spot Fleet selects the cheapest Spot pools and evenly
         * allocates your target Spot capacity across the number of Spot pools that you
         * specify.
         * Note that Spot Fleet attempts to draw Spot Instances from the number of pools that you specify on a
         * best effort basis. If a pool runs out of Spot capacity before fulfilling your target
         * capacity, Spot Fleet will continue to fulfill your request by drawing from the next cheapest
         * pool. To ensure that your target capacity is met, you might receive Spot Instances from more than
         * the number of pools that you specified. Similarly, if most of the pools have no Spot
         * capacity, you might receive your full target capacity from fewer than the number of
         * pools that you specified.
         */
        fun instancePoolsToUseCount(instancePoolsToUseCount: Int): FluentBuilder
        /**
         * The launch specifications for the Spot Fleet request. If you specify
         * LaunchSpecifications, you can't specify
         * LaunchTemplateConfigs. If you include On-Demand capacity in your
         * request, you must use LaunchTemplateConfigs.
         */
        fun launchSpecifications(launchSpecifications: List<SpotFleetLaunchSpecification>): FluentBuilder
        /**
         * The launch template and overrides. If you specify LaunchTemplateConfigs,
         * you can't specify LaunchSpecifications. If you include On-Demand capacity
         * in your request, you must use LaunchTemplateConfigs.
         */
        fun launchTemplateConfigs(launchTemplateConfigs: List<LaunchTemplateConfig>): FluentBuilder
        /**
         * One or more Classic Load Balancers and target groups to attach to the Spot Fleet
         * request. Spot Fleet registers the running Spot Instances with the specified Classic Load
         * Balancers and target groups.
         * With Network Load Balancers, Spot Fleet cannot register instances that have the
         * following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2,
         * M3, and T1.
         */
        fun loadBalancersConfig(loadBalancersConfig: LoadBalancersConfig): FluentBuilder
        /**
         * The order of the launch template overrides to use in fulfilling On-Demand capacity. If
         * you specify lowestPrice, Spot Fleet uses price to determine the order, launching
         * the lowest price first. If you specify prioritized, Spot Fleet uses the priority
         * that you assign to each Spot Fleet launch template override, launching the highest priority
         * first. If you do not specify a value, Spot Fleet defaults to lowestPrice.
         */
        fun onDemandAllocationStrategy(onDemandAllocationStrategy: OnDemandAllocationStrategy): FluentBuilder
        /**
         * The number of On-Demand units fulfilled by this request compared to the set target
         * On-Demand capacity.
         */
        fun onDemandFulfilledCapacity(onDemandFulfilledCapacity: Double): FluentBuilder
        /**
         * The maximum amount per hour for On-Demand Instances that you're willing to pay. You
         * can use the onDemandMaxTotalPrice parameter, the
         * spotMaxTotalPrice parameter, or both parameters to ensure that your
         * fleet cost does not exceed your budget. If you set a maximum price per hour for the
         * On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances until it reaches the
         * maximum amount you're willing to pay. When the maximum amount you're willing to pay is
         * reached, the fleet stops launching instances even if it hasn’t met the target
         * capacity.
         */
        fun onDemandMaxTotalPrice(onDemandMaxTotalPrice: String): FluentBuilder
        /**
         * The number of On-Demand units to request. You can choose to set the target capacity in
         * terms of instances or a performance characteristic that is important to your application
         * workload, such as vCPUs, memory, or I/O. If the request type is maintain,
         * you can specify a target capacity of 0 and add capacity later.
         */
        fun onDemandTargetCapacity(onDemandTargetCapacity: Int): FluentBuilder
        /**
         * Indicates whether Spot Fleet should replace unhealthy instances.
         */
        fun replaceUnhealthyInstances(replaceUnhealthyInstances: Boolean): FluentBuilder
        /**
         * The strategies for managing your Spot Instances that are at an elevated risk of being
         * interrupted.
         */
        fun spotMaintenanceStrategies(spotMaintenanceStrategies: SpotMaintenanceStrategies): FluentBuilder
        /**
         * The maximum amount per hour for Spot Instances that you're willing to pay. You can use
         * the spotdMaxTotalPrice parameter, the onDemandMaxTotalPrice
         * parameter, or both parameters to ensure that your fleet cost does not exceed your
         * budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances in your request,
         * Spot Fleet will launch instances until it reaches the maximum amount you're willing to pay.
         * When the maximum amount you're willing to pay is reached, the fleet stops launching
         * instances even if it hasn’t met the target capacity.
         */
        fun spotMaxTotalPrice(spotMaxTotalPrice: String): FluentBuilder
        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance. The
         * default is the On-Demand price.
         */
        fun spotPrice(spotPrice: String): FluentBuilder
        /**
         * The key-value pair for tagging the Spot Fleet request on creation. The value for
         * ResourceType must be spot-fleet-request, otherwise the
         * Spot Fleet request fails. To tag instances at launch, specify the tags in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch
         * template (valid only if you use LaunchTemplateConfigs) or in
         * the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">
         * SpotFleetTagSpecification
         * (valid only if you use
         * LaunchSpecifications). For information about tagging after launch, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your Resources.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The number of units to request for the Spot Fleet. You can choose to set the target
         * capacity in terms of instances or a performance characteristic that is important to your
         * application workload, such as vCPUs, memory, or I/O. If the request type is
         * maintain, you can specify a target capacity of 0 and add capacity
         * later.
         */
        fun targetCapacity(targetCapacity: Int): FluentBuilder
        /**
         * Indicates whether running Spot Instances are terminated when the Spot Fleet request
         * expires.
         */
        fun terminateInstancesWithExpiration(terminateInstancesWithExpiration: Boolean): FluentBuilder
        /**
         * The type of request. Indicates whether the Spot Fleet only requests the target
         * capacity or also attempts to maintain it. When this value is request, the
         * Spot Fleet only places the required requests. It does not attempt to replenish Spot
         * Instances if capacity is diminished, nor does it submit requests in alternative Spot
         * pools if capacity is not available. When this value is maintain, the Spot
         * Fleet maintains the target capacity. The Spot Fleet places the required requests to meet
         * capacity and automatically replenishes any interrupted instances. Default:
         * maintain. instant is listed but is not used by Spot
         * Fleet.
         */
        fun type(type: FleetType): FluentBuilder
        /**
         * The start date and time of the request, in UTC format
         * (YYYY-MM-DDTHH:MM:SSZ).
         * By default, Amazon EC2 starts fulfilling the request immediately.
         */
        fun validFrom(validFrom: Instant): FluentBuilder
        /**
         * The end date and time of the request, in UTC format
         * (YYYY-MM-DDTHH:MM:SSZ).
         * After the end date and time, no new Spot Instance requests are placed or able to fulfill
         * the request. If no value is specified, the Spot Fleet request remains until you cancel
         * it.
         */
        fun validUntil(validUntil: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by
         * the Spot Fleet request.
         * If the allocation strategy is lowestPrice, Spot Fleet launches instances from
         * the Spot Instance pools with the lowest price. This is the default allocation strategy.
         * If the allocation strategy is diversified, Spot Fleet launches instances from
         * all the Spot Instance pools that you specify.
         * If the allocation strategy is capacityOptimized (recommended), Spot Fleet
         * launches instances from Spot Instance pools with optimal capacity for the number of instances
         * that are launching. To give certain instance types a higher chance of launching first,
         * use capacityOptimizedPrioritized. Set a priority for each instance type by
         * using the Priority parameter for LaunchTemplateOverrides. You
         * can assign the same priority to different LaunchTemplateOverrides. EC2
         * implements the priorities on a best-effort basis, but optimizes for capacity first.
         * capacityOptimizedPrioritized is supported only if your Spot Fleet uses a
         * launch template. Note that if the OnDemandAllocationStrategy is set to
         * prioritized, the same priority is applied when fulfilling On-Demand
         * capacity.
         */
        var allocationStrategy: AllocationStrategy?
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of your
         * listings. This helps to avoid duplicate listings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: String?
        /**
         * Reserved.
         */
        var context: String?
        /**
         * Indicates whether running Spot Instances should be terminated if you decrease the
         * target capacity of the Spot Fleet request below the current size of the Spot
         * Fleet.
         */
        var excessCapacityTerminationPolicy: ExcessCapacityTerminationPolicy?
        /**
         * The number of units fulfilled by this request compared to the set target capacity. You
         * cannot set this value.
         */
        var fulfilledCapacity: Double?
        /**
         * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
         * grants the Spot Fleet the permission to request, launch, terminate, and tag instances on
         * your behalf. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites">Spot
         * Fleet prerequisites in the Amazon EC2 User Guide for Linux Instances. Spot Fleet
         * can terminate Spot Instances on your behalf when you cancel its Spot Fleet request using
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests">CancelSpotFleetRequests or when the Spot Fleet request expires, if you set
         * TerminateInstancesWithExpiration.
         */
        var iamFleetRole: String?
        /**
         * The behavior when a Spot Instance is interrupted. The default is
         * terminate.
         */
        var instanceInterruptionBehavior: InstanceInterruptionBehavior?
        /**
         * The number of Spot pools across which to allocate your target Spot capacity. Valid
         * only when Spot AllocationStrategy is set to
         * lowest-price. Spot Fleet selects the cheapest Spot pools and evenly
         * allocates your target Spot capacity across the number of Spot pools that you
         * specify.
         * Note that Spot Fleet attempts to draw Spot Instances from the number of pools that you specify on a
         * best effort basis. If a pool runs out of Spot capacity before fulfilling your target
         * capacity, Spot Fleet will continue to fulfill your request by drawing from the next cheapest
         * pool. To ensure that your target capacity is met, you might receive Spot Instances from more than
         * the number of pools that you specified. Similarly, if most of the pools have no Spot
         * capacity, you might receive your full target capacity from fewer than the number of
         * pools that you specified.
         */
        var instancePoolsToUseCount: Int?
        /**
         * The launch specifications for the Spot Fleet request. If you specify
         * LaunchSpecifications, you can't specify
         * LaunchTemplateConfigs. If you include On-Demand capacity in your
         * request, you must use LaunchTemplateConfigs.
         */
        var launchSpecifications: List<SpotFleetLaunchSpecification>?
        /**
         * The launch template and overrides. If you specify LaunchTemplateConfigs,
         * you can't specify LaunchSpecifications. If you include On-Demand capacity
         * in your request, you must use LaunchTemplateConfigs.
         */
        var launchTemplateConfigs: List<LaunchTemplateConfig>?
        /**
         * One or more Classic Load Balancers and target groups to attach to the Spot Fleet
         * request. Spot Fleet registers the running Spot Instances with the specified Classic Load
         * Balancers and target groups.
         * With Network Load Balancers, Spot Fleet cannot register instances that have the
         * following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2,
         * M3, and T1.
         */
        var loadBalancersConfig: LoadBalancersConfig?
        /**
         * The order of the launch template overrides to use in fulfilling On-Demand capacity. If
         * you specify lowestPrice, Spot Fleet uses price to determine the order, launching
         * the lowest price first. If you specify prioritized, Spot Fleet uses the priority
         * that you assign to each Spot Fleet launch template override, launching the highest priority
         * first. If you do not specify a value, Spot Fleet defaults to lowestPrice.
         */
        var onDemandAllocationStrategy: OnDemandAllocationStrategy?
        /**
         * The number of On-Demand units fulfilled by this request compared to the set target
         * On-Demand capacity.
         */
        var onDemandFulfilledCapacity: Double?
        /**
         * The maximum amount per hour for On-Demand Instances that you're willing to pay. You
         * can use the onDemandMaxTotalPrice parameter, the
         * spotMaxTotalPrice parameter, or both parameters to ensure that your
         * fleet cost does not exceed your budget. If you set a maximum price per hour for the
         * On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances until it reaches the
         * maximum amount you're willing to pay. When the maximum amount you're willing to pay is
         * reached, the fleet stops launching instances even if it hasn’t met the target
         * capacity.
         */
        var onDemandMaxTotalPrice: String?
        /**
         * The number of On-Demand units to request. You can choose to set the target capacity in
         * terms of instances or a performance characteristic that is important to your application
         * workload, such as vCPUs, memory, or I/O. If the request type is maintain,
         * you can specify a target capacity of 0 and add capacity later.
         */
        var onDemandTargetCapacity: Int?
        /**
         * Indicates whether Spot Fleet should replace unhealthy instances.
         */
        var replaceUnhealthyInstances: Boolean?
        /**
         * The strategies for managing your Spot Instances that are at an elevated risk of being
         * interrupted.
         */
        var spotMaintenanceStrategies: SpotMaintenanceStrategies?
        /**
         * The maximum amount per hour for Spot Instances that you're willing to pay. You can use
         * the spotdMaxTotalPrice parameter, the onDemandMaxTotalPrice
         * parameter, or both parameters to ensure that your fleet cost does not exceed your
         * budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances in your request,
         * Spot Fleet will launch instances until it reaches the maximum amount you're willing to pay.
         * When the maximum amount you're willing to pay is reached, the fleet stops launching
         * instances even if it hasn’t met the target capacity.
         */
        var spotMaxTotalPrice: String?
        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance. The
         * default is the On-Demand price.
         */
        var spotPrice: String?
        /**
         * The key-value pair for tagging the Spot Fleet request on creation. The value for
         * ResourceType must be spot-fleet-request, otherwise the
         * Spot Fleet request fails. To tag instances at launch, specify the tags in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch
         * template (valid only if you use LaunchTemplateConfigs) or in
         * the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">
         * SpotFleetTagSpecification
         * (valid only if you use
         * LaunchSpecifications). For information about tagging after launch, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your Resources.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The number of units to request for the Spot Fleet. You can choose to set the target
         * capacity in terms of instances or a performance characteristic that is important to your
         * application workload, such as vCPUs, memory, or I/O. If the request type is
         * maintain, you can specify a target capacity of 0 and add capacity
         * later.
         */
        var targetCapacity: Int?
        /**
         * Indicates whether running Spot Instances are terminated when the Spot Fleet request
         * expires.
         */
        var terminateInstancesWithExpiration: Boolean?
        /**
         * The type of request. Indicates whether the Spot Fleet only requests the target
         * capacity or also attempts to maintain it. When this value is request, the
         * Spot Fleet only places the required requests. It does not attempt to replenish Spot
         * Instances if capacity is diminished, nor does it submit requests in alternative Spot
         * pools if capacity is not available. When this value is maintain, the Spot
         * Fleet maintains the target capacity. The Spot Fleet places the required requests to meet
         * capacity and automatically replenishes any interrupted instances. Default:
         * maintain. instant is listed but is not used by Spot
         * Fleet.
         */
        var type: FleetType?
        /**
         * The start date and time of the request, in UTC format
         * (YYYY-MM-DDTHH:MM:SSZ).
         * By default, Amazon EC2 starts fulfilling the request immediately.
         */
        var validFrom: Instant?
        /**
         * The end date and time of the request, in UTC format
         * (YYYY-MM-DDTHH:MM:SSZ).
         * After the end date and time, no new Spot Instance requests are placed or able to fulfill
         * the request. If no value is specified, the Spot Fleet request remains until you cancel
         * it.
         */
        var validUntil: Instant?

        fun build(): SpotFleetRequestConfigData
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LoadBalancersConfig] inside the given [block]
         */
        fun loadBalancersConfig(block: LoadBalancersConfig.DslBuilder.() -> kotlin.Unit) {
            this.loadBalancersConfig = LoadBalancersConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotMaintenanceStrategies] inside the given [block]
         */
        fun spotMaintenanceStrategies(block: SpotMaintenanceStrategies.DslBuilder.() -> kotlin.Unit) {
            this.spotMaintenanceStrategies = SpotMaintenanceStrategies.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocationStrategy: AllocationStrategy? = null
        override var clientToken: String? = null
        override var context: String? = null
        override var excessCapacityTerminationPolicy: ExcessCapacityTerminationPolicy? = null
        override var fulfilledCapacity: Double? = null
        override var iamFleetRole: String? = null
        override var instanceInterruptionBehavior: InstanceInterruptionBehavior? = null
        override var instancePoolsToUseCount: Int? = null
        override var launchSpecifications: List<SpotFleetLaunchSpecification>? = null
        override var launchTemplateConfigs: List<LaunchTemplateConfig>? = null
        override var loadBalancersConfig: LoadBalancersConfig? = null
        override var onDemandAllocationStrategy: OnDemandAllocationStrategy? = null
        override var onDemandFulfilledCapacity: Double? = null
        override var onDemandMaxTotalPrice: String? = null
        override var onDemandTargetCapacity: Int? = null
        override var replaceUnhealthyInstances: Boolean? = null
        override var spotMaintenanceStrategies: SpotMaintenanceStrategies? = null
        override var spotMaxTotalPrice: String? = null
        override var spotPrice: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var targetCapacity: Int? = null
        override var terminateInstancesWithExpiration: Boolean? = null
        override var type: FleetType? = null
        override var validFrom: Instant? = null
        override var validUntil: Instant? = null

        constructor(x: SpotFleetRequestConfigData) : this() {
            this.allocationStrategy = x.allocationStrategy
            this.clientToken = x.clientToken
            this.context = x.context
            this.excessCapacityTerminationPolicy = x.excessCapacityTerminationPolicy
            this.fulfilledCapacity = x.fulfilledCapacity
            this.iamFleetRole = x.iamFleetRole
            this.instanceInterruptionBehavior = x.instanceInterruptionBehavior
            this.instancePoolsToUseCount = x.instancePoolsToUseCount
            this.launchSpecifications = x.launchSpecifications
            this.launchTemplateConfigs = x.launchTemplateConfigs
            this.loadBalancersConfig = x.loadBalancersConfig
            this.onDemandAllocationStrategy = x.onDemandAllocationStrategy
            this.onDemandFulfilledCapacity = x.onDemandFulfilledCapacity
            this.onDemandMaxTotalPrice = x.onDemandMaxTotalPrice
            this.onDemandTargetCapacity = x.onDemandTargetCapacity
            this.replaceUnhealthyInstances = x.replaceUnhealthyInstances
            this.spotMaintenanceStrategies = x.spotMaintenanceStrategies
            this.spotMaxTotalPrice = x.spotMaxTotalPrice
            this.spotPrice = x.spotPrice
            this.tagSpecifications = x.tagSpecifications
            this.targetCapacity = x.targetCapacity
            this.terminateInstancesWithExpiration = x.terminateInstancesWithExpiration
            this.type = x.type
            this.validFrom = x.validFrom
            this.validUntil = x.validUntil
        }

        override fun build(): SpotFleetRequestConfigData = SpotFleetRequestConfigData(this)
        override fun allocationStrategy(allocationStrategy: AllocationStrategy): FluentBuilder = apply { this.allocationStrategy = allocationStrategy }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun context(context: String): FluentBuilder = apply { this.context = context }
        override fun excessCapacityTerminationPolicy(excessCapacityTerminationPolicy: ExcessCapacityTerminationPolicy): FluentBuilder = apply { this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy }
        override fun fulfilledCapacity(fulfilledCapacity: Double): FluentBuilder = apply { this.fulfilledCapacity = fulfilledCapacity }
        override fun iamFleetRole(iamFleetRole: String): FluentBuilder = apply { this.iamFleetRole = iamFleetRole }
        override fun instanceInterruptionBehavior(instanceInterruptionBehavior: InstanceInterruptionBehavior): FluentBuilder = apply { this.instanceInterruptionBehavior = instanceInterruptionBehavior }
        override fun instancePoolsToUseCount(instancePoolsToUseCount: Int): FluentBuilder = apply { this.instancePoolsToUseCount = instancePoolsToUseCount }
        override fun launchSpecifications(launchSpecifications: List<SpotFleetLaunchSpecification>): FluentBuilder = apply { this.launchSpecifications = launchSpecifications }
        override fun launchTemplateConfigs(launchTemplateConfigs: List<LaunchTemplateConfig>): FluentBuilder = apply { this.launchTemplateConfigs = launchTemplateConfigs }
        override fun loadBalancersConfig(loadBalancersConfig: LoadBalancersConfig): FluentBuilder = apply { this.loadBalancersConfig = loadBalancersConfig }
        override fun onDemandAllocationStrategy(onDemandAllocationStrategy: OnDemandAllocationStrategy): FluentBuilder = apply { this.onDemandAllocationStrategy = onDemandAllocationStrategy }
        override fun onDemandFulfilledCapacity(onDemandFulfilledCapacity: Double): FluentBuilder = apply { this.onDemandFulfilledCapacity = onDemandFulfilledCapacity }
        override fun onDemandMaxTotalPrice(onDemandMaxTotalPrice: String): FluentBuilder = apply { this.onDemandMaxTotalPrice = onDemandMaxTotalPrice }
        override fun onDemandTargetCapacity(onDemandTargetCapacity: Int): FluentBuilder = apply { this.onDemandTargetCapacity = onDemandTargetCapacity }
        override fun replaceUnhealthyInstances(replaceUnhealthyInstances: Boolean): FluentBuilder = apply { this.replaceUnhealthyInstances = replaceUnhealthyInstances }
        override fun spotMaintenanceStrategies(spotMaintenanceStrategies: SpotMaintenanceStrategies): FluentBuilder = apply { this.spotMaintenanceStrategies = spotMaintenanceStrategies }
        override fun spotMaxTotalPrice(spotMaxTotalPrice: String): FluentBuilder = apply { this.spotMaxTotalPrice = spotMaxTotalPrice }
        override fun spotPrice(spotPrice: String): FluentBuilder = apply { this.spotPrice = spotPrice }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun targetCapacity(targetCapacity: Int): FluentBuilder = apply { this.targetCapacity = targetCapacity }
        override fun terminateInstancesWithExpiration(terminateInstancesWithExpiration: Boolean): FluentBuilder = apply { this.terminateInstancesWithExpiration = terminateInstancesWithExpiration }
        override fun type(type: FleetType): FluentBuilder = apply { this.type = type }
        override fun validFrom(validFrom: Instant): FluentBuilder = apply { this.validFrom = validFrom }
        override fun validUntil(validUntil: Instant): FluentBuilder = apply { this.validUntil = validUntil }
    }
}
