// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Spot Instance request.
 */
class SpotInstanceRequest private constructor(builder: BuilderImpl) {
    /**
     * Deprecated.
     */
    val actualBlockHourlyPrice: String? = builder.actualBlockHourlyPrice
    /**
     * The Availability Zone group. If you specify the same Availability Zone group for all Spot Instance requests, all Spot Instances are launched in the same Availability Zone.
     */
    val availabilityZoneGroup: String? = builder.availabilityZoneGroup
    /**
     * Deprecated.
     */
    val blockDurationMinutes: Int? = builder.blockDurationMinutes
    /**
     * The date and time when the Spot Instance request was created, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
     */
    val createTime: Instant? = builder.createTime
    /**
     * The fault codes for the Spot Instance request, if any.
     */
    val fault: SpotInstanceStateFault? = builder.fault
    /**
     * The instance ID, if an instance has been launched to fulfill the Spot Instance request.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The behavior when a Spot Instance is interrupted.
     */
    val instanceInterruptionBehavior: InstanceInterruptionBehavior? = builder.instanceInterruptionBehavior
    /**
     * The instance launch group. Launch groups are Spot Instances that launch together and terminate together.
     */
    val launchGroup: String? = builder.launchGroup
    /**
     * Additional information for launching instances.
     */
    val launchSpecification: LaunchSpecification? = builder.launchSpecification
    /**
     * The Availability Zone in which the request is launched.
     */
    val launchedAvailabilityZone: String? = builder.launchedAvailabilityZone
    /**
     * The product description associated with the Spot Instance.
     */
    val productDescription: RiProductDescription? = builder.productDescription
    /**
     * The ID of the Spot Instance request.
     */
    val spotInstanceRequestId: String? = builder.spotInstanceRequestId
    /**
     * The maximum price per hour that you are willing to pay for a Spot Instance.
     */
    val spotPrice: String? = builder.spotPrice
    /**
     * The state of the Spot Instance request. Spot status information helps track your Spot
     * Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot status in the
     * Amazon EC2 User Guide for Linux Instances.
     */
    val state: SpotInstanceState? = builder.state
    /**
     * The status code and status message describing the Spot Instance request.
     */
    val status: SpotInstanceStatus? = builder.status
    /**
     * Any tags assigned to the resource.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The Spot Instance request type.
     */
    val type: SpotInstanceType? = builder.type
    /**
     * The start date of the request, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     * The request becomes active at this date and time.
     */
    val validFrom: Instant? = builder.validFrom
    /**
     * The end date of the request, in UTC format
     * (YYYY-MM-DDTHH:MM:SSZ).
     * For a persistent request, the request remains active until the validUntil date
     * and time is reached. Otherwise, the request remains active until you cancel it.
     * For a one-time request, the request remains active until all instances launch,
     * the request is canceled, or the validUntil date and time is reached. By default, the
     * request is valid for 7 days from the date the request was created.
     */
    val validUntil: Instant? = builder.validUntil

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SpotInstanceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SpotInstanceRequest(")
        append("actualBlockHourlyPrice=$actualBlockHourlyPrice,")
        append("availabilityZoneGroup=$availabilityZoneGroup,")
        append("blockDurationMinutes=$blockDurationMinutes,")
        append("createTime=$createTime,")
        append("fault=$fault,")
        append("instanceId=$instanceId,")
        append("instanceInterruptionBehavior=$instanceInterruptionBehavior,")
        append("launchGroup=$launchGroup,")
        append("launchSpecification=$launchSpecification,")
        append("launchedAvailabilityZone=$launchedAvailabilityZone,")
        append("productDescription=$productDescription,")
        append("spotInstanceRequestId=$spotInstanceRequestId,")
        append("spotPrice=$spotPrice,")
        append("state=$state,")
        append("status=$status,")
        append("tags=$tags,")
        append("type=$type,")
        append("validFrom=$validFrom,")
        append("validUntil=$validUntil)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualBlockHourlyPrice?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneGroup?.hashCode() ?: 0)
        result = 31 * result + (blockDurationMinutes ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (fault?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceInterruptionBehavior?.hashCode() ?: 0)
        result = 31 * result + (launchGroup?.hashCode() ?: 0)
        result = 31 * result + (launchSpecification?.hashCode() ?: 0)
        result = 31 * result + (launchedAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (productDescription?.hashCode() ?: 0)
        result = 31 * result + (spotInstanceRequestId?.hashCode() ?: 0)
        result = 31 * result + (spotPrice?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (validFrom?.hashCode() ?: 0)
        result = 31 * result + (validUntil?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SpotInstanceRequest

        if (actualBlockHourlyPrice != other.actualBlockHourlyPrice) return false
        if (availabilityZoneGroup != other.availabilityZoneGroup) return false
        if (blockDurationMinutes != other.blockDurationMinutes) return false
        if (createTime != other.createTime) return false
        if (fault != other.fault) return false
        if (instanceId != other.instanceId) return false
        if (instanceInterruptionBehavior != other.instanceInterruptionBehavior) return false
        if (launchGroup != other.launchGroup) return false
        if (launchSpecification != other.launchSpecification) return false
        if (launchedAvailabilityZone != other.launchedAvailabilityZone) return false
        if (productDescription != other.productDescription) return false
        if (spotInstanceRequestId != other.spotInstanceRequestId) return false
        if (spotPrice != other.spotPrice) return false
        if (state != other.state) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (validFrom != other.validFrom) return false
        if (validUntil != other.validUntil) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SpotInstanceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SpotInstanceRequest
        /**
         * Deprecated.
         */
        fun actualBlockHourlyPrice(actualBlockHourlyPrice: String): FluentBuilder
        /**
         * The Availability Zone group. If you specify the same Availability Zone group for all Spot Instance requests, all Spot Instances are launched in the same Availability Zone.
         */
        fun availabilityZoneGroup(availabilityZoneGroup: String): FluentBuilder
        /**
         * Deprecated.
         */
        fun blockDurationMinutes(blockDurationMinutes: Int): FluentBuilder
        /**
         * The date and time when the Spot Instance request was created, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
         */
        fun createTime(createTime: Instant): FluentBuilder
        /**
         * The fault codes for the Spot Instance request, if any.
         */
        fun fault(fault: SpotInstanceStateFault): FluentBuilder
        /**
         * The instance ID, if an instance has been launched to fulfill the Spot Instance request.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The behavior when a Spot Instance is interrupted.
         */
        fun instanceInterruptionBehavior(instanceInterruptionBehavior: InstanceInterruptionBehavior): FluentBuilder
        /**
         * The instance launch group. Launch groups are Spot Instances that launch together and terminate together.
         */
        fun launchGroup(launchGroup: String): FluentBuilder
        /**
         * Additional information for launching instances.
         */
        fun launchSpecification(launchSpecification: LaunchSpecification): FluentBuilder
        /**
         * The Availability Zone in which the request is launched.
         */
        fun launchedAvailabilityZone(launchedAvailabilityZone: String): FluentBuilder
        /**
         * The product description associated with the Spot Instance.
         */
        fun productDescription(productDescription: RiProductDescription): FluentBuilder
        /**
         * The ID of the Spot Instance request.
         */
        fun spotInstanceRequestId(spotInstanceRequestId: String): FluentBuilder
        /**
         * The maximum price per hour that you are willing to pay for a Spot Instance.
         */
        fun spotPrice(spotPrice: String): FluentBuilder
        /**
         * The state of the Spot Instance request. Spot status information helps track your Spot
         * Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot status in the
         * Amazon EC2 User Guide for Linux Instances.
         */
        fun state(state: SpotInstanceState): FluentBuilder
        /**
         * The status code and status message describing the Spot Instance request.
         */
        fun status(status: SpotInstanceStatus): FluentBuilder
        /**
         * Any tags assigned to the resource.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The Spot Instance request type.
         */
        fun type(type: SpotInstanceType): FluentBuilder
        /**
         * The start date of the request, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * The request becomes active at this date and time.
         */
        fun validFrom(validFrom: Instant): FluentBuilder
        /**
         * The end date of the request, in UTC format
         * (YYYY-MM-DDTHH:MM:SSZ).
         * For a persistent request, the request remains active until the validUntil date
         * and time is reached. Otherwise, the request remains active until you cancel it.
         * For a one-time request, the request remains active until all instances launch,
         * the request is canceled, or the validUntil date and time is reached. By default, the
         * request is valid for 7 days from the date the request was created.
         */
        fun validUntil(validUntil: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Deprecated.
         */
        var actualBlockHourlyPrice: String?
        /**
         * The Availability Zone group. If you specify the same Availability Zone group for all Spot Instance requests, all Spot Instances are launched in the same Availability Zone.
         */
        var availabilityZoneGroup: String?
        /**
         * Deprecated.
         */
        var blockDurationMinutes: Int?
        /**
         * The date and time when the Spot Instance request was created, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
         */
        var createTime: Instant?
        /**
         * The fault codes for the Spot Instance request, if any.
         */
        var fault: SpotInstanceStateFault?
        /**
         * The instance ID, if an instance has been launched to fulfill the Spot Instance request.
         */
        var instanceId: String?
        /**
         * The behavior when a Spot Instance is interrupted.
         */
        var instanceInterruptionBehavior: InstanceInterruptionBehavior?
        /**
         * The instance launch group. Launch groups are Spot Instances that launch together and terminate together.
         */
        var launchGroup: String?
        /**
         * Additional information for launching instances.
         */
        var launchSpecification: LaunchSpecification?
        /**
         * The Availability Zone in which the request is launched.
         */
        var launchedAvailabilityZone: String?
        /**
         * The product description associated with the Spot Instance.
         */
        var productDescription: RiProductDescription?
        /**
         * The ID of the Spot Instance request.
         */
        var spotInstanceRequestId: String?
        /**
         * The maximum price per hour that you are willing to pay for a Spot Instance.
         */
        var spotPrice: String?
        /**
         * The state of the Spot Instance request. Spot status information helps track your Spot
         * Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot status in the
         * Amazon EC2 User Guide for Linux Instances.
         */
        var state: SpotInstanceState?
        /**
         * The status code and status message describing the Spot Instance request.
         */
        var status: SpotInstanceStatus?
        /**
         * Any tags assigned to the resource.
         */
        var tags: List<Tag>?
        /**
         * The Spot Instance request type.
         */
        var type: SpotInstanceType?
        /**
         * The start date of the request, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * The request becomes active at this date and time.
         */
        var validFrom: Instant?
        /**
         * The end date of the request, in UTC format
         * (YYYY-MM-DDTHH:MM:SSZ).
         * For a persistent request, the request remains active until the validUntil date
         * and time is reached. Otherwise, the request remains active until you cancel it.
         * For a one-time request, the request remains active until all instances launch,
         * the request is canceled, or the validUntil date and time is reached. By default, the
         * request is valid for 7 days from the date the request was created.
         */
        var validUntil: Instant?

        fun build(): SpotInstanceRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotInstanceStateFault] inside the given [block]
         */
        fun fault(block: SpotInstanceStateFault.DslBuilder.() -> kotlin.Unit) {
            this.fault = SpotInstanceStateFault.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchSpecification] inside the given [block]
         */
        fun launchSpecification(block: LaunchSpecification.DslBuilder.() -> kotlin.Unit) {
            this.launchSpecification = LaunchSpecification.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotInstanceStatus] inside the given [block]
         */
        fun status(block: SpotInstanceStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = SpotInstanceStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actualBlockHourlyPrice: String? = null
        override var availabilityZoneGroup: String? = null
        override var blockDurationMinutes: Int? = null
        override var createTime: Instant? = null
        override var fault: SpotInstanceStateFault? = null
        override var instanceId: String? = null
        override var instanceInterruptionBehavior: InstanceInterruptionBehavior? = null
        override var launchGroup: String? = null
        override var launchSpecification: LaunchSpecification? = null
        override var launchedAvailabilityZone: String? = null
        override var productDescription: RiProductDescription? = null
        override var spotInstanceRequestId: String? = null
        override var spotPrice: String? = null
        override var state: SpotInstanceState? = null
        override var status: SpotInstanceStatus? = null
        override var tags: List<Tag>? = null
        override var type: SpotInstanceType? = null
        override var validFrom: Instant? = null
        override var validUntil: Instant? = null

        constructor(x: SpotInstanceRequest) : this() {
            this.actualBlockHourlyPrice = x.actualBlockHourlyPrice
            this.availabilityZoneGroup = x.availabilityZoneGroup
            this.blockDurationMinutes = x.blockDurationMinutes
            this.createTime = x.createTime
            this.fault = x.fault
            this.instanceId = x.instanceId
            this.instanceInterruptionBehavior = x.instanceInterruptionBehavior
            this.launchGroup = x.launchGroup
            this.launchSpecification = x.launchSpecification
            this.launchedAvailabilityZone = x.launchedAvailabilityZone
            this.productDescription = x.productDescription
            this.spotInstanceRequestId = x.spotInstanceRequestId
            this.spotPrice = x.spotPrice
            this.state = x.state
            this.status = x.status
            this.tags = x.tags
            this.type = x.type
            this.validFrom = x.validFrom
            this.validUntil = x.validUntil
        }

        override fun build(): SpotInstanceRequest = SpotInstanceRequest(this)
        override fun actualBlockHourlyPrice(actualBlockHourlyPrice: String): FluentBuilder = apply { this.actualBlockHourlyPrice = actualBlockHourlyPrice }
        override fun availabilityZoneGroup(availabilityZoneGroup: String): FluentBuilder = apply { this.availabilityZoneGroup = availabilityZoneGroup }
        override fun blockDurationMinutes(blockDurationMinutes: Int): FluentBuilder = apply { this.blockDurationMinutes = blockDurationMinutes }
        override fun createTime(createTime: Instant): FluentBuilder = apply { this.createTime = createTime }
        override fun fault(fault: SpotInstanceStateFault): FluentBuilder = apply { this.fault = fault }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun instanceInterruptionBehavior(instanceInterruptionBehavior: InstanceInterruptionBehavior): FluentBuilder = apply { this.instanceInterruptionBehavior = instanceInterruptionBehavior }
        override fun launchGroup(launchGroup: String): FluentBuilder = apply { this.launchGroup = launchGroup }
        override fun launchSpecification(launchSpecification: LaunchSpecification): FluentBuilder = apply { this.launchSpecification = launchSpecification }
        override fun launchedAvailabilityZone(launchedAvailabilityZone: String): FluentBuilder = apply { this.launchedAvailabilityZone = launchedAvailabilityZone }
        override fun productDescription(productDescription: RiProductDescription): FluentBuilder = apply { this.productDescription = productDescription }
        override fun spotInstanceRequestId(spotInstanceRequestId: String): FluentBuilder = apply { this.spotInstanceRequestId = spotInstanceRequestId }
        override fun spotPrice(spotPrice: String): FluentBuilder = apply { this.spotPrice = spotPrice }
        override fun state(state: SpotInstanceState): FluentBuilder = apply { this.state = state }
        override fun status(status: SpotInstanceStatus): FluentBuilder = apply { this.status = status }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: SpotInstanceType): FluentBuilder = apply { this.type = type }
        override fun validFrom(validFrom: Instant): FluentBuilder = apply { this.validFrom = validFrom }
        override fun validUntil(validUntil: Instant): FluentBuilder = apply { this.validUntil = validUntil }
    }
}
