// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the status of a Spot Instance request.
 */
class SpotInstanceStatus private constructor(builder: BuilderImpl) {
    /**
     * The status code. For a list of status codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand">Spot status codes in the Amazon EC2 User Guide for Linux Instances.
     */
    val code: String? = builder.code
    /**
     * The description for the status code.
     */
    val message: String? = builder.message
    /**
     * The date and time of the most recent status update, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     */
    val updateTime: Instant? = builder.updateTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SpotInstanceStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SpotInstanceStatus(")
        append("code=$code,")
        append("message=$message,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SpotInstanceStatus

        if (code != other.code) return false
        if (message != other.message) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SpotInstanceStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SpotInstanceStatus
        /**
         * The status code. For a list of status codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand">Spot status codes in the Amazon EC2 User Guide for Linux Instances.
         */
        fun code(code: String): FluentBuilder
        /**
         * The description for the status code.
         */
        fun message(message: String): FluentBuilder
        /**
         * The date and time of the most recent status update, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        fun updateTime(updateTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The status code. For a list of status codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand">Spot status codes in the Amazon EC2 User Guide for Linux Instances.
         */
        var code: String?
        /**
         * The description for the status code.
         */
        var message: String?
        /**
         * The date and time of the most recent status update, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        var updateTime: Instant?

        fun build(): SpotInstanceStatus
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var code: String? = null
        override var message: String? = null
        override var updateTime: Instant? = null

        constructor(x: SpotInstanceStatus) : this() {
            this.code = x.code
            this.message = x.message
            this.updateTime = x.updateTime
        }

        override fun build(): SpotInstanceStatus = SpotInstanceStatus(this)
        override fun code(code: String): FluentBuilder = apply { this.code = code }
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun updateTime(updateTime: Instant): FluentBuilder = apply { this.updateTime = updateTime }
    }
}
