// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The options for Spot Instances.
 */
class SpotMarketOptions private constructor(builder: BuilderImpl) {
    /**
     * Deprecated.
     */
    val blockDurationMinutes: Int? = builder.blockDurationMinutes
    /**
     * The behavior when a Spot Instance is interrupted. The default is
     * terminate.
     */
    val instanceInterruptionBehavior: InstanceInterruptionBehavior? = builder.instanceInterruptionBehavior
    /**
     * The maximum hourly price you're willing to pay for the Spot Instances. The default is
     * the On-Demand price.
     */
    val maxPrice: String? = builder.maxPrice
    /**
     * The Spot Instance request type. For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances, persistent Spot
     * Instance requests are only supported when the instance interruption behavior is either hibernate or
     * stop.
     */
    val spotInstanceType: SpotInstanceType? = builder.spotInstanceType
    /**
     * The end date of the request, in UTC format
     * (YYYY-MM-DDTHH:MM:SSZ).
     * Supported only for persistent requests.
     * For a persistent request, the request remains active until the
     * ValidUntil date and time is reached. Otherwise, the request
     * remains active until you cancel it.
     * For a one-time request, ValidUntil is not supported. The request
     * remains active until all instances launch or you cancel the request.
     */
    val validUntil: Instant? = builder.validUntil

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SpotMarketOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SpotMarketOptions(")
        append("blockDurationMinutes=$blockDurationMinutes,")
        append("instanceInterruptionBehavior=$instanceInterruptionBehavior,")
        append("maxPrice=$maxPrice,")
        append("spotInstanceType=$spotInstanceType,")
        append("validUntil=$validUntil)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDurationMinutes ?: 0
        result = 31 * result + (instanceInterruptionBehavior?.hashCode() ?: 0)
        result = 31 * result + (maxPrice?.hashCode() ?: 0)
        result = 31 * result + (spotInstanceType?.hashCode() ?: 0)
        result = 31 * result + (validUntil?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SpotMarketOptions

        if (blockDurationMinutes != other.blockDurationMinutes) return false
        if (instanceInterruptionBehavior != other.instanceInterruptionBehavior) return false
        if (maxPrice != other.maxPrice) return false
        if (spotInstanceType != other.spotInstanceType) return false
        if (validUntil != other.validUntil) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SpotMarketOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SpotMarketOptions
        /**
         * Deprecated.
         */
        fun blockDurationMinutes(blockDurationMinutes: Int): FluentBuilder
        /**
         * The behavior when a Spot Instance is interrupted. The default is
         * terminate.
         */
        fun instanceInterruptionBehavior(instanceInterruptionBehavior: InstanceInterruptionBehavior): FluentBuilder
        /**
         * The maximum hourly price you're willing to pay for the Spot Instances. The default is
         * the On-Demand price.
         */
        fun maxPrice(maxPrice: String): FluentBuilder
        /**
         * The Spot Instance request type. For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances, persistent Spot
         * Instance requests are only supported when the instance interruption behavior is either hibernate or
         * stop.
         */
        fun spotInstanceType(spotInstanceType: SpotInstanceType): FluentBuilder
        /**
         * The end date of the request, in UTC format
         * (YYYY-MM-DDTHH:MM:SSZ).
         * Supported only for persistent requests.
         * For a persistent request, the request remains active until the
         * ValidUntil date and time is reached. Otherwise, the request
         * remains active until you cancel it.
         * For a one-time request, ValidUntil is not supported. The request
         * remains active until all instances launch or you cancel the request.
         */
        fun validUntil(validUntil: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Deprecated.
         */
        var blockDurationMinutes: Int?
        /**
         * The behavior when a Spot Instance is interrupted. The default is
         * terminate.
         */
        var instanceInterruptionBehavior: InstanceInterruptionBehavior?
        /**
         * The maximum hourly price you're willing to pay for the Spot Instances. The default is
         * the On-Demand price.
         */
        var maxPrice: String?
        /**
         * The Spot Instance request type. For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances, persistent Spot
         * Instance requests are only supported when the instance interruption behavior is either hibernate or
         * stop.
         */
        var spotInstanceType: SpotInstanceType?
        /**
         * The end date of the request, in UTC format
         * (YYYY-MM-DDTHH:MM:SSZ).
         * Supported only for persistent requests.
         * For a persistent request, the request remains active until the
         * ValidUntil date and time is reached. Otherwise, the request
         * remains active until you cancel it.
         * For a one-time request, ValidUntil is not supported. The request
         * remains active until all instances launch or you cancel the request.
         */
        var validUntil: Instant?

        fun build(): SpotMarketOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var blockDurationMinutes: Int? = null
        override var instanceInterruptionBehavior: InstanceInterruptionBehavior? = null
        override var maxPrice: String? = null
        override var spotInstanceType: SpotInstanceType? = null
        override var validUntil: Instant? = null

        constructor(x: SpotMarketOptions) : this() {
            this.blockDurationMinutes = x.blockDurationMinutes
            this.instanceInterruptionBehavior = x.instanceInterruptionBehavior
            this.maxPrice = x.maxPrice
            this.spotInstanceType = x.spotInstanceType
            this.validUntil = x.validUntil
        }

        override fun build(): SpotMarketOptions = SpotMarketOptions(this)
        override fun blockDurationMinutes(blockDurationMinutes: Int): FluentBuilder = apply { this.blockDurationMinutes = blockDurationMinutes }
        override fun instanceInterruptionBehavior(instanceInterruptionBehavior: InstanceInterruptionBehavior): FluentBuilder = apply { this.instanceInterruptionBehavior = instanceInterruptionBehavior }
        override fun maxPrice(maxPrice: String): FluentBuilder = apply { this.maxPrice = maxPrice }
        override fun spotInstanceType(spotInstanceType: SpotInstanceType): FluentBuilder = apply { this.spotInstanceType = spotInstanceType }
        override fun validUntil(validUntil: Instant): FluentBuilder = apply { this.validUntil = validUntil }
    }
}
