// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the configuration of Spot Instances in an EC2 Fleet request.
 */
class SpotOptionsRequest private constructor(builder: BuilderImpl) {
    /**
     * Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by
     * the EC2 Fleet.
     * If the allocation strategy is lowest-price, EC2 Fleet launches instances from
     * the Spot Instance pools with the lowest price. This is the default allocation strategy.
     * If the allocation strategy is diversified, EC2 Fleet launches instances from all
     * of the Spot Instance pools that you specify.
     * If the allocation strategy is capacity-optimized (recommended), EC2 Fleet
     * launches instances from Spot Instance pools with optimal capacity for the number of instances that
     * are launching. To give certain instance types a higher chance of launching first, use
     * capacity-optimized-prioritized. Set a priority for each instance type by
     * using the Priority parameter for LaunchTemplateOverrides. You can
     * assign the same priority to different LaunchTemplateOverrides. EC2 implements
     * the priorities on a best-effort basis, but optimizes for capacity first.
     * capacity-optimized-prioritized is supported only if your fleet uses a
     * launch template. Note that if the On-Demand AllocationStrategy is set to
     * prioritized, the same priority is applied when fulfilling On-Demand
     * capacity.
     */
    val allocationStrategy: SpotAllocationStrategy? = builder.allocationStrategy
    /**
     * The behavior when a Spot Instance is interrupted. The default is terminate.
     */
    val instanceInterruptionBehavior: SpotInstanceInterruptionBehavior? = builder.instanceInterruptionBehavior
    /**
     * The number of Spot pools across which to allocate your target Spot capacity. Valid only
     * when Spot AllocationStrategy is set to
     * lowest-price. EC2 Fleet selects the cheapest Spot pools and evenly allocates
     * your target Spot capacity across the number of Spot pools that you specify.
     * Note that EC2 Fleet attempts to draw Spot Instances from the number of pools that you specify on a
     * best effort basis. If a pool runs out of Spot capacity before fulfilling your target
     * capacity, EC2 Fleet will continue to fulfill your request by drawing from the next cheapest
     * pool. To ensure that your target capacity is met, you might receive Spot Instances from more than
     * the number of pools that you specified. Similarly, if most of the pools have no Spot
     * capacity, you might receive your full target capacity from fewer than the number of pools
     * that you specified.
     */
    val instancePoolsToUseCount: Int? = builder.instancePoolsToUseCount
    /**
     * The strategies for managing your Spot Instances that are at an elevated risk of being
     * interrupted.
     */
    val maintenanceStrategies: FleetSpotMaintenanceStrategiesRequest? = builder.maintenanceStrategies
    /**
     * The maximum amount per hour for Spot Instances that you're willing to pay.
     */
    val maxTotalPrice: String? = builder.maxTotalPrice
    /**
     * The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is
     * not reached, the fleet launches no instances.
     */
    val minTargetCapacity: Int? = builder.minTargetCapacity
    /**
     * Indicates that the fleet launches all Spot Instances into a single Availability Zone. Supported
     * only for fleets of type instant.
     */
    val singleAvailabilityZone: Boolean? = builder.singleAvailabilityZone
    /**
     * Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
     * Supported only for fleets of type instant.
     */
    val singleInstanceType: Boolean? = builder.singleInstanceType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SpotOptionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SpotOptionsRequest(")
        append("allocationStrategy=$allocationStrategy,")
        append("instanceInterruptionBehavior=$instanceInterruptionBehavior,")
        append("instancePoolsToUseCount=$instancePoolsToUseCount,")
        append("maintenanceStrategies=$maintenanceStrategies,")
        append("maxTotalPrice=$maxTotalPrice,")
        append("minTargetCapacity=$minTargetCapacity,")
        append("singleAvailabilityZone=$singleAvailabilityZone,")
        append("singleInstanceType=$singleInstanceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationStrategy?.hashCode() ?: 0
        result = 31 * result + (instanceInterruptionBehavior?.hashCode() ?: 0)
        result = 31 * result + (instancePoolsToUseCount ?: 0)
        result = 31 * result + (maintenanceStrategies?.hashCode() ?: 0)
        result = 31 * result + (maxTotalPrice?.hashCode() ?: 0)
        result = 31 * result + (minTargetCapacity ?: 0)
        result = 31 * result + (singleAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (singleInstanceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SpotOptionsRequest

        if (allocationStrategy != other.allocationStrategy) return false
        if (instanceInterruptionBehavior != other.instanceInterruptionBehavior) return false
        if (instancePoolsToUseCount != other.instancePoolsToUseCount) return false
        if (maintenanceStrategies != other.maintenanceStrategies) return false
        if (maxTotalPrice != other.maxTotalPrice) return false
        if (minTargetCapacity != other.minTargetCapacity) return false
        if (singleAvailabilityZone != other.singleAvailabilityZone) return false
        if (singleInstanceType != other.singleInstanceType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SpotOptionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SpotOptionsRequest
        /**
         * Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by
         * the EC2 Fleet.
         * If the allocation strategy is lowest-price, EC2 Fleet launches instances from
         * the Spot Instance pools with the lowest price. This is the default allocation strategy.
         * If the allocation strategy is diversified, EC2 Fleet launches instances from all
         * of the Spot Instance pools that you specify.
         * If the allocation strategy is capacity-optimized (recommended), EC2 Fleet
         * launches instances from Spot Instance pools with optimal capacity for the number of instances that
         * are launching. To give certain instance types a higher chance of launching first, use
         * capacity-optimized-prioritized. Set a priority for each instance type by
         * using the Priority parameter for LaunchTemplateOverrides. You can
         * assign the same priority to different LaunchTemplateOverrides. EC2 implements
         * the priorities on a best-effort basis, but optimizes for capacity first.
         * capacity-optimized-prioritized is supported only if your fleet uses a
         * launch template. Note that if the On-Demand AllocationStrategy is set to
         * prioritized, the same priority is applied when fulfilling On-Demand
         * capacity.
         */
        fun allocationStrategy(allocationStrategy: SpotAllocationStrategy): FluentBuilder
        /**
         * The behavior when a Spot Instance is interrupted. The default is terminate.
         */
        fun instanceInterruptionBehavior(instanceInterruptionBehavior: SpotInstanceInterruptionBehavior): FluentBuilder
        /**
         * The number of Spot pools across which to allocate your target Spot capacity. Valid only
         * when Spot AllocationStrategy is set to
         * lowest-price. EC2 Fleet selects the cheapest Spot pools and evenly allocates
         * your target Spot capacity across the number of Spot pools that you specify.
         * Note that EC2 Fleet attempts to draw Spot Instances from the number of pools that you specify on a
         * best effort basis. If a pool runs out of Spot capacity before fulfilling your target
         * capacity, EC2 Fleet will continue to fulfill your request by drawing from the next cheapest
         * pool. To ensure that your target capacity is met, you might receive Spot Instances from more than
         * the number of pools that you specified. Similarly, if most of the pools have no Spot
         * capacity, you might receive your full target capacity from fewer than the number of pools
         * that you specified.
         */
        fun instancePoolsToUseCount(instancePoolsToUseCount: Int): FluentBuilder
        /**
         * The strategies for managing your Spot Instances that are at an elevated risk of being
         * interrupted.
         */
        fun maintenanceStrategies(maintenanceStrategies: FleetSpotMaintenanceStrategiesRequest): FluentBuilder
        /**
         * The maximum amount per hour for Spot Instances that you're willing to pay.
         */
        fun maxTotalPrice(maxTotalPrice: String): FluentBuilder
        /**
         * The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is
         * not reached, the fleet launches no instances.
         */
        fun minTargetCapacity(minTargetCapacity: Int): FluentBuilder
        /**
         * Indicates that the fleet launches all Spot Instances into a single Availability Zone. Supported
         * only for fleets of type instant.
         */
        fun singleAvailabilityZone(singleAvailabilityZone: Boolean): FluentBuilder
        /**
         * Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
         * Supported only for fleets of type instant.
         */
        fun singleInstanceType(singleInstanceType: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by
         * the EC2 Fleet.
         * If the allocation strategy is lowest-price, EC2 Fleet launches instances from
         * the Spot Instance pools with the lowest price. This is the default allocation strategy.
         * If the allocation strategy is diversified, EC2 Fleet launches instances from all
         * of the Spot Instance pools that you specify.
         * If the allocation strategy is capacity-optimized (recommended), EC2 Fleet
         * launches instances from Spot Instance pools with optimal capacity for the number of instances that
         * are launching. To give certain instance types a higher chance of launching first, use
         * capacity-optimized-prioritized. Set a priority for each instance type by
         * using the Priority parameter for LaunchTemplateOverrides. You can
         * assign the same priority to different LaunchTemplateOverrides. EC2 implements
         * the priorities on a best-effort basis, but optimizes for capacity first.
         * capacity-optimized-prioritized is supported only if your fleet uses a
         * launch template. Note that if the On-Demand AllocationStrategy is set to
         * prioritized, the same priority is applied when fulfilling On-Demand
         * capacity.
         */
        var allocationStrategy: SpotAllocationStrategy?
        /**
         * The behavior when a Spot Instance is interrupted. The default is terminate.
         */
        var instanceInterruptionBehavior: SpotInstanceInterruptionBehavior?
        /**
         * The number of Spot pools across which to allocate your target Spot capacity. Valid only
         * when Spot AllocationStrategy is set to
         * lowest-price. EC2 Fleet selects the cheapest Spot pools and evenly allocates
         * your target Spot capacity across the number of Spot pools that you specify.
         * Note that EC2 Fleet attempts to draw Spot Instances from the number of pools that you specify on a
         * best effort basis. If a pool runs out of Spot capacity before fulfilling your target
         * capacity, EC2 Fleet will continue to fulfill your request by drawing from the next cheapest
         * pool. To ensure that your target capacity is met, you might receive Spot Instances from more than
         * the number of pools that you specified. Similarly, if most of the pools have no Spot
         * capacity, you might receive your full target capacity from fewer than the number of pools
         * that you specified.
         */
        var instancePoolsToUseCount: Int?
        /**
         * The strategies for managing your Spot Instances that are at an elevated risk of being
         * interrupted.
         */
        var maintenanceStrategies: FleetSpotMaintenanceStrategiesRequest?
        /**
         * The maximum amount per hour for Spot Instances that you're willing to pay.
         */
        var maxTotalPrice: String?
        /**
         * The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is
         * not reached, the fleet launches no instances.
         */
        var minTargetCapacity: Int?
        /**
         * Indicates that the fleet launches all Spot Instances into a single Availability Zone. Supported
         * only for fleets of type instant.
         */
        var singleAvailabilityZone: Boolean?
        /**
         * Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
         * Supported only for fleets of type instant.
         */
        var singleInstanceType: Boolean?

        fun build(): SpotOptionsRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.FleetSpotMaintenanceStrategiesRequest] inside the given [block]
         */
        fun maintenanceStrategies(block: FleetSpotMaintenanceStrategiesRequest.DslBuilder.() -> kotlin.Unit) {
            this.maintenanceStrategies = FleetSpotMaintenanceStrategiesRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocationStrategy: SpotAllocationStrategy? = null
        override var instanceInterruptionBehavior: SpotInstanceInterruptionBehavior? = null
        override var instancePoolsToUseCount: Int? = null
        override var maintenanceStrategies: FleetSpotMaintenanceStrategiesRequest? = null
        override var maxTotalPrice: String? = null
        override var minTargetCapacity: Int? = null
        override var singleAvailabilityZone: Boolean? = null
        override var singleInstanceType: Boolean? = null

        constructor(x: SpotOptionsRequest) : this() {
            this.allocationStrategy = x.allocationStrategy
            this.instanceInterruptionBehavior = x.instanceInterruptionBehavior
            this.instancePoolsToUseCount = x.instancePoolsToUseCount
            this.maintenanceStrategies = x.maintenanceStrategies
            this.maxTotalPrice = x.maxTotalPrice
            this.minTargetCapacity = x.minTargetCapacity
            this.singleAvailabilityZone = x.singleAvailabilityZone
            this.singleInstanceType = x.singleInstanceType
        }

        override fun build(): SpotOptionsRequest = SpotOptionsRequest(this)
        override fun allocationStrategy(allocationStrategy: SpotAllocationStrategy): FluentBuilder = apply { this.allocationStrategy = allocationStrategy }
        override fun instanceInterruptionBehavior(instanceInterruptionBehavior: SpotInstanceInterruptionBehavior): FluentBuilder = apply { this.instanceInterruptionBehavior = instanceInterruptionBehavior }
        override fun instancePoolsToUseCount(instancePoolsToUseCount: Int): FluentBuilder = apply { this.instancePoolsToUseCount = instancePoolsToUseCount }
        override fun maintenanceStrategies(maintenanceStrategies: FleetSpotMaintenanceStrategiesRequest): FluentBuilder = apply { this.maintenanceStrategies = maintenanceStrategies }
        override fun maxTotalPrice(maxTotalPrice: String): FluentBuilder = apply { this.maxTotalPrice = maxTotalPrice }
        override fun minTargetCapacity(minTargetCapacity: Int): FluentBuilder = apply { this.minTargetCapacity = minTargetCapacity }
        override fun singleAvailabilityZone(singleAvailabilityZone: Boolean): FluentBuilder = apply { this.singleAvailabilityZone = singleAvailabilityZone }
        override fun singleInstanceType(singleInstanceType: Boolean): FluentBuilder = apply { this.singleInstanceType = singleInstanceType }
    }
}
