// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a stale rule in a security group.
 */
class StaleIpPermission private constructor(builder: BuilderImpl) {
    /**
     * The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
     * -1 indicates all ICMP types.
     */
    val fromPort: Int? = builder.fromPort
    /**
     * The IP protocol name (for tcp, udp, and icmp) or number  (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
     */
    val ipProtocol: String? = builder.ipProtocol
    /**
     * The IP ranges. Not applicable for stale security group rules.
     */
    val ipRanges: List<String>? = builder.ipRanges
    /**
     * The prefix list IDs. Not applicable for stale security group rules.
     */
    val prefixListIds: List<String>? = builder.prefixListIds
    /**
     * The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
     * -1 indicates all ICMP types.
     */
    val toPort: Int? = builder.toPort
    /**
     * The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of the VPC peering connection.
     */
    val userIdGroupPairs: List<UserIdGroupPair>? = builder.userIdGroupPairs

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StaleIpPermission = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StaleIpPermission(")
        append("fromPort=$fromPort,")
        append("ipProtocol=$ipProtocol,")
        append("ipRanges=$ipRanges,")
        append("prefixListIds=$prefixListIds,")
        append("toPort=$toPort,")
        append("userIdGroupPairs=$userIdGroupPairs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fromPort ?: 0
        result = 31 * result + (ipProtocol?.hashCode() ?: 0)
        result = 31 * result + (ipRanges?.hashCode() ?: 0)
        result = 31 * result + (prefixListIds?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        result = 31 * result + (userIdGroupPairs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StaleIpPermission

        if (fromPort != other.fromPort) return false
        if (ipProtocol != other.ipProtocol) return false
        if (ipRanges != other.ipRanges) return false
        if (prefixListIds != other.prefixListIds) return false
        if (toPort != other.toPort) return false
        if (userIdGroupPairs != other.userIdGroupPairs) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StaleIpPermission = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StaleIpPermission
        /**
         * The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
         * -1 indicates all ICMP types.
         */
        fun fromPort(fromPort: Int): FluentBuilder
        /**
         * The IP protocol name (for tcp, udp, and icmp) or number  (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
         */
        fun ipProtocol(ipProtocol: String): FluentBuilder
        /**
         * The IP ranges. Not applicable for stale security group rules.
         */
        fun ipRanges(ipRanges: List<String>): FluentBuilder
        /**
         * The prefix list IDs. Not applicable for stale security group rules.
         */
        fun prefixListIds(prefixListIds: List<String>): FluentBuilder
        /**
         * The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
         * -1 indicates all ICMP types.
         */
        fun toPort(toPort: Int): FluentBuilder
        /**
         * The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of the VPC peering connection.
         */
        fun userIdGroupPairs(userIdGroupPairs: List<UserIdGroupPair>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
         * -1 indicates all ICMP types.
         */
        var fromPort: Int?
        /**
         * The IP protocol name (for tcp, udp, and icmp) or number  (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
         */
        var ipProtocol: String?
        /**
         * The IP ranges. Not applicable for stale security group rules.
         */
        var ipRanges: List<String>?
        /**
         * The prefix list IDs. Not applicable for stale security group rules.
         */
        var prefixListIds: List<String>?
        /**
         * The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
         * -1 indicates all ICMP types.
         */
        var toPort: Int?
        /**
         * The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of the VPC peering connection.
         */
        var userIdGroupPairs: List<UserIdGroupPair>?

        fun build(): StaleIpPermission
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fromPort: Int? = null
        override var ipProtocol: String? = null
        override var ipRanges: List<String>? = null
        override var prefixListIds: List<String>? = null
        override var toPort: Int? = null
        override var userIdGroupPairs: List<UserIdGroupPair>? = null

        constructor(x: StaleIpPermission) : this() {
            this.fromPort = x.fromPort
            this.ipProtocol = x.ipProtocol
            this.ipRanges = x.ipRanges
            this.prefixListIds = x.prefixListIds
            this.toPort = x.toPort
            this.userIdGroupPairs = x.userIdGroupPairs
        }

        override fun build(): StaleIpPermission = StaleIpPermission(this)
        override fun fromPort(fromPort: Int): FluentBuilder = apply { this.fromPort = fromPort }
        override fun ipProtocol(ipProtocol: String): FluentBuilder = apply { this.ipProtocol = ipProtocol }
        override fun ipRanges(ipRanges: List<String>): FluentBuilder = apply { this.ipRanges = ipRanges }
        override fun prefixListIds(prefixListIds: List<String>): FluentBuilder = apply { this.prefixListIds = prefixListIds }
        override fun toPort(toPort: Int): FluentBuilder = apply { this.toPort = toPort }
        override fun userIdGroupPairs(userIdGroupPairs: List<UserIdGroupPair>): FluentBuilder = apply { this.userIdGroupPairs = userIdGroupPairs }
    }
}
