// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a stale security group (a security group that contains stale rules).
 */
class StaleSecurityGroup private constructor(builder: BuilderImpl) {
    /**
     * The description of the security group.
     */
    val description: String? = builder.description
    /**
     * The ID of the security group.
     */
    val groupId: String? = builder.groupId
    /**
     * The name of the security group.
     */
    val groupName: String? = builder.groupName
    /**
     * Information about the stale inbound rules in the security group.
     */
    val staleIpPermissions: List<StaleIpPermission>? = builder.staleIpPermissions
    /**
     * Information about the stale outbound rules in the security group.
     */
    val staleIpPermissionsEgress: List<StaleIpPermission>? = builder.staleIpPermissionsEgress
    /**
     * The ID of the VPC for the security group.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StaleSecurityGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StaleSecurityGroup(")
        append("description=$description,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("staleIpPermissions=$staleIpPermissions,")
        append("staleIpPermissionsEgress=$staleIpPermissionsEgress,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (staleIpPermissions?.hashCode() ?: 0)
        result = 31 * result + (staleIpPermissionsEgress?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StaleSecurityGroup

        if (description != other.description) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (staleIpPermissions != other.staleIpPermissions) return false
        if (staleIpPermissionsEgress != other.staleIpPermissionsEgress) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StaleSecurityGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StaleSecurityGroup
        /**
         * The description of the security group.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ID of the security group.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * The name of the security group.
         */
        fun groupName(groupName: String): FluentBuilder
        /**
         * Information about the stale inbound rules in the security group.
         */
        fun staleIpPermissions(staleIpPermissions: List<StaleIpPermission>): FluentBuilder
        /**
         * Information about the stale outbound rules in the security group.
         */
        fun staleIpPermissionsEgress(staleIpPermissionsEgress: List<StaleIpPermission>): FluentBuilder
        /**
         * The ID of the VPC for the security group.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description of the security group.
         */
        var description: String?
        /**
         * The ID of the security group.
         */
        var groupId: String?
        /**
         * The name of the security group.
         */
        var groupName: String?
        /**
         * Information about the stale inbound rules in the security group.
         */
        var staleIpPermissions: List<StaleIpPermission>?
        /**
         * Information about the stale outbound rules in the security group.
         */
        var staleIpPermissionsEgress: List<StaleIpPermission>?
        /**
         * The ID of the VPC for the security group.
         */
        var vpcId: String?

        fun build(): StaleSecurityGroup
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var groupId: String? = null
        override var groupName: String? = null
        override var staleIpPermissions: List<StaleIpPermission>? = null
        override var staleIpPermissionsEgress: List<StaleIpPermission>? = null
        override var vpcId: String? = null

        constructor(x: StaleSecurityGroup) : this() {
            this.description = x.description
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.staleIpPermissions = x.staleIpPermissions
            this.staleIpPermissionsEgress = x.staleIpPermissionsEgress
            this.vpcId = x.vpcId
        }

        override fun build(): StaleSecurityGroup = StaleSecurityGroup(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun groupName(groupName: String): FluentBuilder = apply { this.groupName = groupName }
        override fun staleIpPermissions(staleIpPermissions: List<StaleIpPermission>): FluentBuilder = apply { this.staleIpPermissions = staleIpPermissions }
        override fun staleIpPermissionsEgress(staleIpPermissionsEgress: List<StaleIpPermission>): FluentBuilder = apply { this.staleIpPermissionsEgress = staleIpPermissionsEgress }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
