// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class StopInstancesRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Forces the instances to stop. The instances do not have an opportunity to flush file
     * system caches or file system metadata. If you use this option, you must perform file
     * system check and repair procedures. This option is not recommended for Windows
     * instances.
     * Default: false
     */
    val force: Boolean? = builder.force
    /**
     * Hibernates the instance if the instance was enabled for hibernation at launch. If the
     * instance cannot hibernate successfully, a normal shutdown occurs. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate
     * your instance in the Amazon EC2 User Guide.
     * Default: false
     */
    val hibernate: Boolean? = builder.hibernate
    /**
     * The IDs of the instances.
     */
    val instanceIds: List<String>? = builder.instanceIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StopInstancesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StopInstancesRequest(")
        append("dryRun=$dryRun,")
        append("force=$force,")
        append("hibernate=$hibernate,")
        append("instanceIds=$instanceIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (force?.hashCode() ?: 0)
        result = 31 * result + (hibernate?.hashCode() ?: 0)
        result = 31 * result + (instanceIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StopInstancesRequest

        if (dryRun != other.dryRun) return false
        if (force != other.force) return false
        if (hibernate != other.hibernate) return false
        if (instanceIds != other.instanceIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StopInstancesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StopInstancesRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Forces the instances to stop. The instances do not have an opportunity to flush file
         * system caches or file system metadata. If you use this option, you must perform file
         * system check and repair procedures. This option is not recommended for Windows
         * instances.
         * Default: false
         */
        fun force(force: Boolean): FluentBuilder
        /**
         * Hibernates the instance if the instance was enabled for hibernation at launch. If the
         * instance cannot hibernate successfully, a normal shutdown occurs. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate
         * your instance in the Amazon EC2 User Guide.
         * Default: false
         */
        fun hibernate(hibernate: Boolean): FluentBuilder
        /**
         * The IDs of the instances.
         */
        fun instanceIds(instanceIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * Forces the instances to stop. The instances do not have an opportunity to flush file
         * system caches or file system metadata. If you use this option, you must perform file
         * system check and repair procedures. This option is not recommended for Windows
         * instances.
         * Default: false
         */
        var force: Boolean?
        /**
         * Hibernates the instance if the instance was enabled for hibernation at launch. If the
         * instance cannot hibernate successfully, a normal shutdown occurs. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate
         * your instance in the Amazon EC2 User Guide.
         * Default: false
         */
        var hibernate: Boolean?
        /**
         * The IDs of the instances.
         */
        var instanceIds: List<String>?

        fun build(): StopInstancesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var force: Boolean? = null
        override var hibernate: Boolean? = null
        override var instanceIds: List<String>? = null

        constructor(x: StopInstancesRequest) : this() {
            this.dryRun = x.dryRun
            this.force = x.force
            this.hibernate = x.hibernate
            this.instanceIds = x.instanceIds
        }

        override fun build(): StopInstancesRequest = StopInstancesRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun force(force: Boolean): FluentBuilder = apply { this.force = force }
        override fun hibernate(hibernate: Boolean): FluentBuilder = apply { this.hibernate = hibernate }
        override fun instanceIds(instanceIds: List<String>): FluentBuilder = apply { this.instanceIds = instanceIds }
    }
}
