// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The information about the AMI store task, including the progress of the task.
 */
class StoreImageTaskResult private constructor(builder: BuilderImpl) {
    /**
     * The ID of the AMI that is being stored.
     */
    val amiId: String? = builder.amiId
    /**
     * The name of the Amazon S3 bucket that contains the stored AMI object.
     */
    val bucket: String? = builder.bucket
    /**
     * The progress of the task as a percentage.
     */
    val progressPercentage: Int? = builder.progressPercentage
    /**
     * The name of the stored AMI object in the bucket.
     */
    val s3ObjectKey: String? = builder.s3ObjectKey
    /**
     * If the tasks fails, the reason for the failure is returned. If the task succeeds,
     * null is returned.
     */
    val storeTaskFailureReason: String? = builder.storeTaskFailureReason
    /**
     * The state of the store task (InProgress, Completed, or
     * Failed).
     */
    val storeTaskState: String? = builder.storeTaskState
    /**
     * The time the task started.
     */
    val taskStartTime: Instant? = builder.taskStartTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StoreImageTaskResult = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StoreImageTaskResult(")
        append("amiId=$amiId,")
        append("bucket=$bucket,")
        append("progressPercentage=$progressPercentage,")
        append("s3ObjectKey=$s3ObjectKey,")
        append("storeTaskFailureReason=$storeTaskFailureReason,")
        append("storeTaskState=$storeTaskState,")
        append("taskStartTime=$taskStartTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiId?.hashCode() ?: 0
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (progressPercentage ?: 0)
        result = 31 * result + (s3ObjectKey?.hashCode() ?: 0)
        result = 31 * result + (storeTaskFailureReason?.hashCode() ?: 0)
        result = 31 * result + (storeTaskState?.hashCode() ?: 0)
        result = 31 * result + (taskStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StoreImageTaskResult

        if (amiId != other.amiId) return false
        if (bucket != other.bucket) return false
        if (progressPercentage != other.progressPercentage) return false
        if (s3ObjectKey != other.s3ObjectKey) return false
        if (storeTaskFailureReason != other.storeTaskFailureReason) return false
        if (storeTaskState != other.storeTaskState) return false
        if (taskStartTime != other.taskStartTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StoreImageTaskResult = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StoreImageTaskResult
        /**
         * The ID of the AMI that is being stored.
         */
        fun amiId(amiId: String): FluentBuilder
        /**
         * The name of the Amazon S3 bucket that contains the stored AMI object.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * The progress of the task as a percentage.
         */
        fun progressPercentage(progressPercentage: Int): FluentBuilder
        /**
         * The name of the stored AMI object in the bucket.
         */
        fun s3ObjectKey(s3ObjectKey: String): FluentBuilder
        /**
         * If the tasks fails, the reason for the failure is returned. If the task succeeds,
         * null is returned.
         */
        fun storeTaskFailureReason(storeTaskFailureReason: String): FluentBuilder
        /**
         * The state of the store task (InProgress, Completed, or
         * Failed).
         */
        fun storeTaskState(storeTaskState: String): FluentBuilder
        /**
         * The time the task started.
         */
        fun taskStartTime(taskStartTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the AMI that is being stored.
         */
        var amiId: String?
        /**
         * The name of the Amazon S3 bucket that contains the stored AMI object.
         */
        var bucket: String?
        /**
         * The progress of the task as a percentage.
         */
        var progressPercentage: Int?
        /**
         * The name of the stored AMI object in the bucket.
         */
        var s3ObjectKey: String?
        /**
         * If the tasks fails, the reason for the failure is returned. If the task succeeds,
         * null is returned.
         */
        var storeTaskFailureReason: String?
        /**
         * The state of the store task (InProgress, Completed, or
         * Failed).
         */
        var storeTaskState: String?
        /**
         * The time the task started.
         */
        var taskStartTime: Instant?

        fun build(): StoreImageTaskResult
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var amiId: String? = null
        override var bucket: String? = null
        override var progressPercentage: Int? = null
        override var s3ObjectKey: String? = null
        override var storeTaskFailureReason: String? = null
        override var storeTaskState: String? = null
        override var taskStartTime: Instant? = null

        constructor(x: StoreImageTaskResult) : this() {
            this.amiId = x.amiId
            this.bucket = x.bucket
            this.progressPercentage = x.progressPercentage
            this.s3ObjectKey = x.s3ObjectKey
            this.storeTaskFailureReason = x.storeTaskFailureReason
            this.storeTaskState = x.storeTaskState
            this.taskStartTime = x.taskStartTime
        }

        override fun build(): StoreImageTaskResult = StoreImageTaskResult(this)
        override fun amiId(amiId: String): FluentBuilder = apply { this.amiId = amiId }
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun progressPercentage(progressPercentage: Int): FluentBuilder = apply { this.progressPercentage = progressPercentage }
        override fun s3ObjectKey(s3ObjectKey: String): FluentBuilder = apply { this.s3ObjectKey = s3ObjectKey }
        override fun storeTaskFailureReason(storeTaskFailureReason: String): FluentBuilder = apply { this.storeTaskFailureReason = storeTaskFailureReason }
        override fun storeTaskState(storeTaskState: String): FluentBuilder = apply { this.storeTaskState = storeTaskState }
        override fun taskStartTime(taskStartTime: Instant): FluentBuilder = apply { this.taskStartTime = taskStartTime }
    }
}
