// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a subnet.
 */
class Subnet private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether a network interface created in this subnet (including a network
     * interface created by RunInstances) receives an IPv6 address.
     */
    val assignIpv6AddressOnCreation: Boolean? = builder.assignIpv6AddressOnCreation
    /**
     * The Availability Zone of the subnet.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The AZ ID of the subnet.
     */
    val availabilityZoneId: String? = builder.availabilityZoneId
    /**
     * The number of unused private IPv4 addresses in the subnet. The IPv4 addresses for any
     * stopped instances are considered unavailable.
     */
    val availableIpAddressCount: Int? = builder.availableIpAddressCount
    /**
     * The IPv4 CIDR block assigned to the subnet.
     */
    val cidrBlock: String? = builder.cidrBlock
    /**
     * The customer-owned IPv4 address pool associated with the subnet.
     */
    val customerOwnedIpv4Pool: String? = builder.customerOwnedIpv4Pool
    /**
     * Indicates whether this is the default subnet for the Availability Zone.
     */
    val defaultForAz: Boolean? = builder.defaultForAz
    /**
     * Information about the IPv6 CIDR blocks associated with the subnet.
     */
    val ipv6CidrBlockAssociationSet: List<SubnetIpv6CidrBlockAssociation>? = builder.ipv6CidrBlockAssociationSet
    /**
     * Indicates whether a network interface created in this subnet (including a network
     * interface created by RunInstances) receives a customer-owned IPv4 address.
     */
    val mapCustomerOwnedIpOnLaunch: Boolean? = builder.mapCustomerOwnedIpOnLaunch
    /**
     * Indicates whether instances launched in this subnet receive a public IPv4 address.
     */
    val mapPublicIpOnLaunch: Boolean? = builder.mapPublicIpOnLaunch
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * The ID of the Amazon Web Services account that owns the subnet.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The current state of the subnet.
     */
    val state: SubnetState? = builder.state
    /**
     * The Amazon Resource Name (ARN) of the subnet.
     */
    val subnetArn: String? = builder.subnetArn
    /**
     * The ID of the subnet.
     */
    val subnetId: String? = builder.subnetId
    /**
     * Any tags assigned to the subnet.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC the subnet is in.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Subnet = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Subnet(")
        append("assignIpv6AddressOnCreation=$assignIpv6AddressOnCreation,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("availableIpAddressCount=$availableIpAddressCount,")
        append("cidrBlock=$cidrBlock,")
        append("customerOwnedIpv4Pool=$customerOwnedIpv4Pool,")
        append("defaultForAz=$defaultForAz,")
        append("ipv6CidrBlockAssociationSet=$ipv6CidrBlockAssociationSet,")
        append("mapCustomerOwnedIpOnLaunch=$mapCustomerOwnedIpOnLaunch,")
        append("mapPublicIpOnLaunch=$mapPublicIpOnLaunch,")
        append("outpostArn=$outpostArn,")
        append("ownerId=$ownerId,")
        append("state=$state,")
        append("subnetArn=$subnetArn,")
        append("subnetId=$subnetId,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignIpv6AddressOnCreation?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (availableIpAddressCount ?: 0)
        result = 31 * result + (cidrBlock?.hashCode() ?: 0)
        result = 31 * result + (customerOwnedIpv4Pool?.hashCode() ?: 0)
        result = 31 * result + (defaultForAz?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlockAssociationSet?.hashCode() ?: 0)
        result = 31 * result + (mapCustomerOwnedIpOnLaunch?.hashCode() ?: 0)
        result = 31 * result + (mapPublicIpOnLaunch?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnetArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Subnet

        if (assignIpv6AddressOnCreation != other.assignIpv6AddressOnCreation) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (availableIpAddressCount != other.availableIpAddressCount) return false
        if (cidrBlock != other.cidrBlock) return false
        if (customerOwnedIpv4Pool != other.customerOwnedIpv4Pool) return false
        if (defaultForAz != other.defaultForAz) return false
        if (ipv6CidrBlockAssociationSet != other.ipv6CidrBlockAssociationSet) return false
        if (mapCustomerOwnedIpOnLaunch != other.mapCustomerOwnedIpOnLaunch) return false
        if (mapPublicIpOnLaunch != other.mapPublicIpOnLaunch) return false
        if (outpostArn != other.outpostArn) return false
        if (ownerId != other.ownerId) return false
        if (state != other.state) return false
        if (subnetArn != other.subnetArn) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Subnet = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Subnet
        /**
         * Indicates whether a network interface created in this subnet (including a network
         * interface created by RunInstances) receives an IPv6 address.
         */
        fun assignIpv6AddressOnCreation(assignIpv6AddressOnCreation: Boolean): FluentBuilder
        /**
         * The Availability Zone of the subnet.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The AZ ID of the subnet.
         */
        fun availabilityZoneId(availabilityZoneId: String): FluentBuilder
        /**
         * The number of unused private IPv4 addresses in the subnet. The IPv4 addresses for any
         * stopped instances are considered unavailable.
         */
        fun availableIpAddressCount(availableIpAddressCount: Int): FluentBuilder
        /**
         * The IPv4 CIDR block assigned to the subnet.
         */
        fun cidrBlock(cidrBlock: String): FluentBuilder
        /**
         * The customer-owned IPv4 address pool associated with the subnet.
         */
        fun customerOwnedIpv4Pool(customerOwnedIpv4Pool: String): FluentBuilder
        /**
         * Indicates whether this is the default subnet for the Availability Zone.
         */
        fun defaultForAz(defaultForAz: Boolean): FluentBuilder
        /**
         * Information about the IPv6 CIDR blocks associated with the subnet.
         */
        fun ipv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet: List<SubnetIpv6CidrBlockAssociation>): FluentBuilder
        /**
         * Indicates whether a network interface created in this subnet (including a network
         * interface created by RunInstances) receives a customer-owned IPv4 address.
         */
        fun mapCustomerOwnedIpOnLaunch(mapCustomerOwnedIpOnLaunch: Boolean): FluentBuilder
        /**
         * Indicates whether instances launched in this subnet receive a public IPv4 address.
         */
        fun mapPublicIpOnLaunch(mapPublicIpOnLaunch: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the subnet.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The current state of the subnet.
         */
        fun state(state: SubnetState): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the subnet.
         */
        fun subnetArn(subnetArn: String): FluentBuilder
        /**
         * The ID of the subnet.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * Any tags assigned to the subnet.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the VPC the subnet is in.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether a network interface created in this subnet (including a network
         * interface created by RunInstances) receives an IPv6 address.
         */
        var assignIpv6AddressOnCreation: Boolean?
        /**
         * The Availability Zone of the subnet.
         */
        var availabilityZone: String?
        /**
         * The AZ ID of the subnet.
         */
        var availabilityZoneId: String?
        /**
         * The number of unused private IPv4 addresses in the subnet. The IPv4 addresses for any
         * stopped instances are considered unavailable.
         */
        var availableIpAddressCount: Int?
        /**
         * The IPv4 CIDR block assigned to the subnet.
         */
        var cidrBlock: String?
        /**
         * The customer-owned IPv4 address pool associated with the subnet.
         */
        var customerOwnedIpv4Pool: String?
        /**
         * Indicates whether this is the default subnet for the Availability Zone.
         */
        var defaultForAz: Boolean?
        /**
         * Information about the IPv6 CIDR blocks associated with the subnet.
         */
        var ipv6CidrBlockAssociationSet: List<SubnetIpv6CidrBlockAssociation>?
        /**
         * Indicates whether a network interface created in this subnet (including a network
         * interface created by RunInstances) receives a customer-owned IPv4 address.
         */
        var mapCustomerOwnedIpOnLaunch: Boolean?
        /**
         * Indicates whether instances launched in this subnet receive a public IPv4 address.
         */
        var mapPublicIpOnLaunch: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        var outpostArn: String?
        /**
         * The ID of the Amazon Web Services account that owns the subnet.
         */
        var ownerId: String?
        /**
         * The current state of the subnet.
         */
        var state: SubnetState?
        /**
         * The Amazon Resource Name (ARN) of the subnet.
         */
        var subnetArn: String?
        /**
         * The ID of the subnet.
         */
        var subnetId: String?
        /**
         * Any tags assigned to the subnet.
         */
        var tags: List<Tag>?
        /**
         * The ID of the VPC the subnet is in.
         */
        var vpcId: String?

        fun build(): Subnet
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assignIpv6AddressOnCreation: Boolean? = null
        override var availabilityZone: String? = null
        override var availabilityZoneId: String? = null
        override var availableIpAddressCount: Int? = null
        override var cidrBlock: String? = null
        override var customerOwnedIpv4Pool: String? = null
        override var defaultForAz: Boolean? = null
        override var ipv6CidrBlockAssociationSet: List<SubnetIpv6CidrBlockAssociation>? = null
        override var mapCustomerOwnedIpOnLaunch: Boolean? = null
        override var mapPublicIpOnLaunch: Boolean? = null
        override var outpostArn: String? = null
        override var ownerId: String? = null
        override var state: SubnetState? = null
        override var subnetArn: String? = null
        override var subnetId: String? = null
        override var tags: List<Tag>? = null
        override var vpcId: String? = null

        constructor(x: Subnet) : this() {
            this.assignIpv6AddressOnCreation = x.assignIpv6AddressOnCreation
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.availableIpAddressCount = x.availableIpAddressCount
            this.cidrBlock = x.cidrBlock
            this.customerOwnedIpv4Pool = x.customerOwnedIpv4Pool
            this.defaultForAz = x.defaultForAz
            this.ipv6CidrBlockAssociationSet = x.ipv6CidrBlockAssociationSet
            this.mapCustomerOwnedIpOnLaunch = x.mapCustomerOwnedIpOnLaunch
            this.mapPublicIpOnLaunch = x.mapPublicIpOnLaunch
            this.outpostArn = x.outpostArn
            this.ownerId = x.ownerId
            this.state = x.state
            this.subnetArn = x.subnetArn
            this.subnetId = x.subnetId
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        override fun build(): Subnet = Subnet(this)
        override fun assignIpv6AddressOnCreation(assignIpv6AddressOnCreation: Boolean): FluentBuilder = apply { this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun availabilityZoneId(availabilityZoneId: String): FluentBuilder = apply { this.availabilityZoneId = availabilityZoneId }
        override fun availableIpAddressCount(availableIpAddressCount: Int): FluentBuilder = apply { this.availableIpAddressCount = availableIpAddressCount }
        override fun cidrBlock(cidrBlock: String): FluentBuilder = apply { this.cidrBlock = cidrBlock }
        override fun customerOwnedIpv4Pool(customerOwnedIpv4Pool: String): FluentBuilder = apply { this.customerOwnedIpv4Pool = customerOwnedIpv4Pool }
        override fun defaultForAz(defaultForAz: Boolean): FluentBuilder = apply { this.defaultForAz = defaultForAz }
        override fun ipv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet: List<SubnetIpv6CidrBlockAssociation>): FluentBuilder = apply { this.ipv6CidrBlockAssociationSet = ipv6CidrBlockAssociationSet }
        override fun mapCustomerOwnedIpOnLaunch(mapCustomerOwnedIpOnLaunch: Boolean): FluentBuilder = apply { this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch }
        override fun mapPublicIpOnLaunch(mapPublicIpOnLaunch: Boolean): FluentBuilder = apply { this.mapPublicIpOnLaunch = mapPublicIpOnLaunch }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun state(state: SubnetState): FluentBuilder = apply { this.state = state }
        override fun subnetArn(subnetArn: String): FluentBuilder = apply { this.subnetArn = subnetArn }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
