// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an IPv6 CIDR block associated with a subnet.
 */
class SubnetIpv6CidrBlockAssociation private constructor(builder: BuilderImpl) {
    /**
     * The association ID for the CIDR block.
     */
    val associationId: String? = builder.associationId
    /**
     * The IPv6 CIDR block.
     */
    val ipv6CidrBlock: String? = builder.ipv6CidrBlock
    /**
     * Information about the state of the CIDR block.
     */
    val ipv6CidrBlockState: SubnetCidrBlockState? = builder.ipv6CidrBlockState

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SubnetIpv6CidrBlockAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SubnetIpv6CidrBlockAssociation(")
        append("associationId=$associationId,")
        append("ipv6CidrBlock=$ipv6CidrBlock,")
        append("ipv6CidrBlockState=$ipv6CidrBlockState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (ipv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlockState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SubnetIpv6CidrBlockAssociation

        if (associationId != other.associationId) return false
        if (ipv6CidrBlock != other.ipv6CidrBlock) return false
        if (ipv6CidrBlockState != other.ipv6CidrBlockState) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SubnetIpv6CidrBlockAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SubnetIpv6CidrBlockAssociation
        /**
         * The association ID for the CIDR block.
         */
        fun associationId(associationId: String): FluentBuilder
        /**
         * The IPv6 CIDR block.
         */
        fun ipv6CidrBlock(ipv6CidrBlock: String): FluentBuilder
        /**
         * Information about the state of the CIDR block.
         */
        fun ipv6CidrBlockState(ipv6CidrBlockState: SubnetCidrBlockState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The association ID for the CIDR block.
         */
        var associationId: String?
        /**
         * The IPv6 CIDR block.
         */
        var ipv6CidrBlock: String?
        /**
         * Information about the state of the CIDR block.
         */
        var ipv6CidrBlockState: SubnetCidrBlockState?

        fun build(): SubnetIpv6CidrBlockAssociation
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SubnetCidrBlockState] inside the given [block]
         */
        fun ipv6CidrBlockState(block: SubnetCidrBlockState.DslBuilder.() -> kotlin.Unit) {
            this.ipv6CidrBlockState = SubnetCidrBlockState.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associationId: String? = null
        override var ipv6CidrBlock: String? = null
        override var ipv6CidrBlockState: SubnetCidrBlockState? = null

        constructor(x: SubnetIpv6CidrBlockAssociation) : this() {
            this.associationId = x.associationId
            this.ipv6CidrBlock = x.ipv6CidrBlock
            this.ipv6CidrBlockState = x.ipv6CidrBlockState
        }

        override fun build(): SubnetIpv6CidrBlockAssociation = SubnetIpv6CidrBlockAssociation(this)
        override fun associationId(associationId: String): FluentBuilder = apply { this.associationId = associationId }
        override fun ipv6CidrBlock(ipv6CidrBlock: String): FluentBuilder = apply { this.ipv6CidrBlock = ipv6CidrBlock }
        override fun ipv6CidrBlockState(ipv6CidrBlockState: SubnetCidrBlockState): FluentBuilder = apply { this.ipv6CidrBlockState = ipv6CidrBlockState }
    }
}
