// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The number of units to request. You can choose to set the target capacity as the number of
 * instances. Or you can set the target capacity to a performance characteristic that is important to your application workload,
 * such as vCPUs, memory, or I/O. If the request type is maintain, you can
 * specify a target capacity of 0 and add capacity later.
 * You can use the On-Demand Instance MaxTotalPrice parameter, the Spot Instance
 * MaxTotalPrice parameter, or both parameters to ensure that your fleet cost
 * does not exceed your budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances
 * in your request, EC2 Fleet will launch instances until it reaches the maximum amount that you're
 * willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops
 * launching instances even if it hasn’t met the target capacity. The
 * MaxTotalPrice parameters are located in <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_OnDemandOptionsRequest">OnDemandOptionsRequest
 * and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotOptionsRequest">SpotOptionsRequest.
 */
class TargetCapacitySpecificationRequest private constructor(builder: BuilderImpl) {
    /**
     * The default TotalTargetCapacity, which is either Spot or
     * On-Demand.
     */
    val defaultTargetCapacityType: DefaultTargetCapacityType? = builder.defaultTargetCapacityType
    /**
     * The number of On-Demand units to request.
     */
    val onDemandTargetCapacity: Int? = builder.onDemandTargetCapacity
    /**
     * The number of Spot units to request.
     */
    val spotTargetCapacity: Int? = builder.spotTargetCapacity
    /**
     * The number of units to request, filled using
     * DefaultTargetCapacityType.
     */
    val totalTargetCapacity: Int? = builder.totalTargetCapacity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TargetCapacitySpecificationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TargetCapacitySpecificationRequest(")
        append("defaultTargetCapacityType=$defaultTargetCapacityType,")
        append("onDemandTargetCapacity=$onDemandTargetCapacity,")
        append("spotTargetCapacity=$spotTargetCapacity,")
        append("totalTargetCapacity=$totalTargetCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultTargetCapacityType?.hashCode() ?: 0
        result = 31 * result + (onDemandTargetCapacity ?: 0)
        result = 31 * result + (spotTargetCapacity ?: 0)
        result = 31 * result + (totalTargetCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TargetCapacitySpecificationRequest

        if (defaultTargetCapacityType != other.defaultTargetCapacityType) return false
        if (onDemandTargetCapacity != other.onDemandTargetCapacity) return false
        if (spotTargetCapacity != other.spotTargetCapacity) return false
        if (totalTargetCapacity != other.totalTargetCapacity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TargetCapacitySpecificationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TargetCapacitySpecificationRequest
        /**
         * The default TotalTargetCapacity, which is either Spot or
         * On-Demand.
         */
        fun defaultTargetCapacityType(defaultTargetCapacityType: DefaultTargetCapacityType): FluentBuilder
        /**
         * The number of On-Demand units to request.
         */
        fun onDemandTargetCapacity(onDemandTargetCapacity: Int): FluentBuilder
        /**
         * The number of Spot units to request.
         */
        fun spotTargetCapacity(spotTargetCapacity: Int): FluentBuilder
        /**
         * The number of units to request, filled using
         * DefaultTargetCapacityType.
         */
        fun totalTargetCapacity(totalTargetCapacity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The default TotalTargetCapacity, which is either Spot or
         * On-Demand.
         */
        var defaultTargetCapacityType: DefaultTargetCapacityType?
        /**
         * The number of On-Demand units to request.
         */
        var onDemandTargetCapacity: Int?
        /**
         * The number of Spot units to request.
         */
        var spotTargetCapacity: Int?
        /**
         * The number of units to request, filled using
         * DefaultTargetCapacityType.
         */
        var totalTargetCapacity: Int?

        fun build(): TargetCapacitySpecificationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var defaultTargetCapacityType: DefaultTargetCapacityType? = null
        override var onDemandTargetCapacity: Int? = null
        override var spotTargetCapacity: Int? = null
        override var totalTargetCapacity: Int? = null

        constructor(x: TargetCapacitySpecificationRequest) : this() {
            this.defaultTargetCapacityType = x.defaultTargetCapacityType
            this.onDemandTargetCapacity = x.onDemandTargetCapacity
            this.spotTargetCapacity = x.spotTargetCapacity
            this.totalTargetCapacity = x.totalTargetCapacity
        }

        override fun build(): TargetCapacitySpecificationRequest = TargetCapacitySpecificationRequest(this)
        override fun defaultTargetCapacityType(defaultTargetCapacityType: DefaultTargetCapacityType): FluentBuilder = apply { this.defaultTargetCapacityType = defaultTargetCapacityType }
        override fun onDemandTargetCapacity(onDemandTargetCapacity: Int): FluentBuilder = apply { this.onDemandTargetCapacity = onDemandTargetCapacity }
        override fun spotTargetCapacity(spotTargetCapacity: Int): FluentBuilder = apply { this.spotTargetCapacity = spotTargetCapacity }
        override fun totalTargetCapacity(totalTargetCapacity: Int): FluentBuilder = apply { this.totalTargetCapacity = totalTargetCapacity }
    }
}
