// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a target network associated with a Client VPN endpoint.
 */
class TargetNetwork private constructor(builder: BuilderImpl) {
    /**
     * The ID of the association.
     */
    val associationId: String? = builder.associationId
    /**
     * The ID of the Client VPN endpoint with which the target network is associated.
     */
    val clientVpnEndpointId: String? = builder.clientVpnEndpointId
    /**
     * The IDs of the security groups applied to the target network association.
     */
    val securityGroups: List<String>? = builder.securityGroups
    /**
     * The current state of the target network association.
     */
    val status: AssociationStatus? = builder.status
    /**
     * The ID of the subnet specified as the target network.
     */
    val targetNetworkId: String? = builder.targetNetworkId
    /**
     * The ID of the VPC in which the target network (subnet) is located.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TargetNetwork = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TargetNetwork(")
        append("associationId=$associationId,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("securityGroups=$securityGroups,")
        append("status=$status,")
        append("targetNetworkId=$targetNetworkId,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetNetworkId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TargetNetwork

        if (associationId != other.associationId) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (securityGroups != other.securityGroups) return false
        if (status != other.status) return false
        if (targetNetworkId != other.targetNetworkId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TargetNetwork = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TargetNetwork
        /**
         * The ID of the association.
         */
        fun associationId(associationId: String): FluentBuilder
        /**
         * The ID of the Client VPN endpoint with which the target network is associated.
         */
        fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder
        /**
         * The IDs of the security groups applied to the target network association.
         */
        fun securityGroups(securityGroups: List<String>): FluentBuilder
        /**
         * The current state of the target network association.
         */
        fun status(status: AssociationStatus): FluentBuilder
        /**
         * The ID of the subnet specified as the target network.
         */
        fun targetNetworkId(targetNetworkId: String): FluentBuilder
        /**
         * The ID of the VPC in which the target network (subnet) is located.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the association.
         */
        var associationId: String?
        /**
         * The ID of the Client VPN endpoint with which the target network is associated.
         */
        var clientVpnEndpointId: String?
        /**
         * The IDs of the security groups applied to the target network association.
         */
        var securityGroups: List<String>?
        /**
         * The current state of the target network association.
         */
        var status: AssociationStatus?
        /**
         * The ID of the subnet specified as the target network.
         */
        var targetNetworkId: String?
        /**
         * The ID of the VPC in which the target network (subnet) is located.
         */
        var vpcId: String?

        fun build(): TargetNetwork
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AssociationStatus] inside the given [block]
         */
        fun status(block: AssociationStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = AssociationStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associationId: String? = null
        override var clientVpnEndpointId: String? = null
        override var securityGroups: List<String>? = null
        override var status: AssociationStatus? = null
        override var targetNetworkId: String? = null
        override var vpcId: String? = null

        constructor(x: TargetNetwork) : this() {
            this.associationId = x.associationId
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.securityGroups = x.securityGroups
            this.status = x.status
            this.targetNetworkId = x.targetNetworkId
            this.vpcId = x.vpcId
        }

        override fun build(): TargetNetwork = TargetNetwork(this)
        override fun associationId(associationId: String): FluentBuilder = apply { this.associationId = associationId }
        override fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder = apply { this.clientVpnEndpointId = clientVpnEndpointId }
        override fun securityGroups(securityGroups: List<String>): FluentBuilder = apply { this.securityGroups = securityGroups }
        override fun status(status: AssociationStatus): FluentBuilder = apply { this.status = status }
        override fun targetNetworkId(targetNetworkId: String): FluentBuilder = apply { this.targetNetworkId = targetNetworkId }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
