// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a Traffic Mirror session.
 */
class TrafficMirrorSession private constructor(builder: BuilderImpl) {
    /**
     * The description of the Traffic Mirror session.
     */
    val description: String? = builder.description
    /**
     * The ID of the Traffic Mirror session's network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The ID of the account that owns the Traffic Mirror session.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The number of bytes in each packet to mirror. These are the bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet
     */
    val packetLength: Int? = builder.packetLength
    /**
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
     * Valid values are 1-32766.
     */
    val sessionNumber: Int? = builder.sessionNumber
    /**
     * The tags assigned to the Traffic Mirror session.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the Traffic Mirror filter.
     */
    val trafficMirrorFilterId: String? = builder.trafficMirrorFilterId
    /**
     * The ID for the Traffic Mirror session.
     */
    val trafficMirrorSessionId: String? = builder.trafficMirrorSessionId
    /**
     * The ID of the Traffic Mirror target.
     */
    val trafficMirrorTargetId: String? = builder.trafficMirrorTargetId
    /**
     * The virtual network ID associated with the Traffic Mirror session.
     */
    val virtualNetworkId: Int? = builder.virtualNetworkId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TrafficMirrorSession = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficMirrorSession(")
        append("description=$description,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("ownerId=$ownerId,")
        append("packetLength=$packetLength,")
        append("sessionNumber=$sessionNumber,")
        append("tags=$tags,")
        append("trafficMirrorFilterId=$trafficMirrorFilterId,")
        append("trafficMirrorSessionId=$trafficMirrorSessionId,")
        append("trafficMirrorTargetId=$trafficMirrorTargetId,")
        append("virtualNetworkId=$virtualNetworkId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (packetLength ?: 0)
        result = 31 * result + (sessionNumber ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorFilterId?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorSessionId?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorTargetId?.hashCode() ?: 0)
        result = 31 * result + (virtualNetworkId ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TrafficMirrorSession

        if (description != other.description) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (ownerId != other.ownerId) return false
        if (packetLength != other.packetLength) return false
        if (sessionNumber != other.sessionNumber) return false
        if (tags != other.tags) return false
        if (trafficMirrorFilterId != other.trafficMirrorFilterId) return false
        if (trafficMirrorSessionId != other.trafficMirrorSessionId) return false
        if (trafficMirrorTargetId != other.trafficMirrorTargetId) return false
        if (virtualNetworkId != other.virtualNetworkId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TrafficMirrorSession = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TrafficMirrorSession
        /**
         * The description of the Traffic Mirror session.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ID of the Traffic Mirror session's network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The ID of the account that owns the Traffic Mirror session.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The number of bytes in each packet to mirror. These are the bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet
         */
        fun packetLength(packetLength: Int): FluentBuilder
        /**
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
         * Valid values are 1-32766.
         */
        fun sessionNumber(sessionNumber: Int): FluentBuilder
        /**
         * The tags assigned to the Traffic Mirror session.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the Traffic Mirror filter.
         */
        fun trafficMirrorFilterId(trafficMirrorFilterId: String): FluentBuilder
        /**
         * The ID for the Traffic Mirror session.
         */
        fun trafficMirrorSessionId(trafficMirrorSessionId: String): FluentBuilder
        /**
         * The ID of the Traffic Mirror target.
         */
        fun trafficMirrorTargetId(trafficMirrorTargetId: String): FluentBuilder
        /**
         * The virtual network ID associated with the Traffic Mirror session.
         */
        fun virtualNetworkId(virtualNetworkId: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description of the Traffic Mirror session.
         */
        var description: String?
        /**
         * The ID of the Traffic Mirror session's network interface.
         */
        var networkInterfaceId: String?
        /**
         * The ID of the account that owns the Traffic Mirror session.
         */
        var ownerId: String?
        /**
         * The number of bytes in each packet to mirror. These are the bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet
         */
        var packetLength: Int?
        /**
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
         * Valid values are 1-32766.
         */
        var sessionNumber: Int?
        /**
         * The tags assigned to the Traffic Mirror session.
         */
        var tags: List<Tag>?
        /**
         * The ID of the Traffic Mirror filter.
         */
        var trafficMirrorFilterId: String?
        /**
         * The ID for the Traffic Mirror session.
         */
        var trafficMirrorSessionId: String?
        /**
         * The ID of the Traffic Mirror target.
         */
        var trafficMirrorTargetId: String?
        /**
         * The virtual network ID associated with the Traffic Mirror session.
         */
        var virtualNetworkId: Int?

        fun build(): TrafficMirrorSession
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var networkInterfaceId: String? = null
        override var ownerId: String? = null
        override var packetLength: Int? = null
        override var sessionNumber: Int? = null
        override var tags: List<Tag>? = null
        override var trafficMirrorFilterId: String? = null
        override var trafficMirrorSessionId: String? = null
        override var trafficMirrorTargetId: String? = null
        override var virtualNetworkId: Int? = null

        constructor(x: TrafficMirrorSession) : this() {
            this.description = x.description
            this.networkInterfaceId = x.networkInterfaceId
            this.ownerId = x.ownerId
            this.packetLength = x.packetLength
            this.sessionNumber = x.sessionNumber
            this.tags = x.tags
            this.trafficMirrorFilterId = x.trafficMirrorFilterId
            this.trafficMirrorSessionId = x.trafficMirrorSessionId
            this.trafficMirrorTargetId = x.trafficMirrorTargetId
            this.virtualNetworkId = x.virtualNetworkId
        }

        override fun build(): TrafficMirrorSession = TrafficMirrorSession(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun packetLength(packetLength: Int): FluentBuilder = apply { this.packetLength = packetLength }
        override fun sessionNumber(sessionNumber: Int): FluentBuilder = apply { this.sessionNumber = sessionNumber }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun trafficMirrorFilterId(trafficMirrorFilterId: String): FluentBuilder = apply { this.trafficMirrorFilterId = trafficMirrorFilterId }
        override fun trafficMirrorSessionId(trafficMirrorSessionId: String): FluentBuilder = apply { this.trafficMirrorSessionId = trafficMirrorSessionId }
        override fun trafficMirrorTargetId(trafficMirrorTargetId: String): FluentBuilder = apply { this.trafficMirrorTargetId = trafficMirrorTargetId }
        override fun virtualNetworkId(virtualNetworkId: Int): FluentBuilder = apply { this.virtualNetworkId = virtualNetworkId }
    }
}
